/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.topia.generator;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.eugene.GeneratorUtil;
import org.nuiton.eugene.java.ObjectModelTransformerToJava;
import org.nuiton.eugene.models.object.ObjectModel;
import org.nuiton.eugene.models.object.ObjectModelAttribute;
import org.nuiton.eugene.models.object.ObjectModelClass;
import org.nuiton.eugene.models.object.ObjectModelClassifier;
import org.nuiton.eugene.models.object.ObjectModelModifier;
import org.nuiton.eugene.models.object.ObjectModelOperation;
import org.nuiton.topia.generator.TopiaGeneratorUtil;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.util.TopiaEntityBinder;
import org.nuiton.topia.persistence.util.TopiaEntityHelper;
import org.nuiton.util.beans.BinderBuilder;
import org.nuiton.util.beans.BinderProvider;

public class BinderHelperTransformer
extends ObjectModelTransformerToJava {
    private static final Log log = LogFactory.getLog(BinderHelperTransformer.class);

    public void transformFromModel(ObjectModel model) {
        String packageName = this.getOutputProperties().getProperty("defaultPackage");
        String modelName = model.getName();
        String binderHelperClazzName = modelName + "BinderHelper";
        String daoHelperClazzName = modelName + "DAOHelper";
        ObjectModelClass resultClass = this.createClass(binderHelperClazzName, packageName);
        this.setSuperClass(resultClass, BinderProvider.class);
        List<ObjectModelClass> classes = TopiaGeneratorUtil.getEntityClasses(model, true);
        this.addImport((ObjectModelClassifier)resultClass, TopiaEntityBinder.class);
        this.addImport((ObjectModelClassifier)resultClass, TopiaEntityHelper.class);
        this.addImport((ObjectModelClassifier)resultClass, TopiaEntity.class);
        this.addImport((ObjectModelClassifier)resultClass, BinderBuilder.class);
        ObjectModelOperation op = this.addOperation((ObjectModelClassifier)resultClass, "getTopiaBinder", "<E extends TopiaEntity> TopiaEntityBinder<E>", new ObjectModelModifier[]{ObjectModelModifier.PUBLIC, ObjectModelModifier.STATIC});
        this.addParameter(op, "Class<E>", "entityClass");
        this.addParameter(op, "String", "contextName");
        this.setOperationBody(op, "\n        return (TopiaEntityBinder<E>) getBinder(entityClass, contextName);\n    ");
        op = this.addOperation((ObjectModelClassifier)resultClass, "getSimpleTopiaBinder", "<E extends TopiaEntity> TopiaEntityBinder<E>", new ObjectModelModifier[]{ObjectModelModifier.PUBLIC, ObjectModelModifier.STATIC});
        this.addParameter(op, "Class<E>", "entityClass");
        this.setOperationBody(op, "\n        return getTopiaBinder(entityClass, \"" + modelName + "\");\n" + "    ");
        op = this.addOperation((ObjectModelClassifier)resultClass, "registerTopiaBinder", "void", new ObjectModelModifier[]{ObjectModelModifier.PUBLIC, ObjectModelModifier.STATIC});
        this.addParameter(op, "BinderBuilder", "builder");
        this.addParameter(op, "String", "contextName");
        this.setOperationBody(op, "\n       BinderProvider.registerBinder(builder, TopiaEntityBinder.class, contextName);\n    ");
        op = this.addOperation((ObjectModelClassifier)resultClass, "copy", "<E extends TopiaEntity> void", new ObjectModelModifier[]{ObjectModelModifier.PUBLIC, ObjectModelModifier.STATIC});
        this.addParameter(op, "String", "contextName");
        this.addParameter(op, "E", "source");
        this.addParameter(op, "E", "target");
        this.addParameter(op, "boolean", "tech");
        this.setOperationBody(op, "\n        Class<E> entityClass = (Class<E>) TopiaEntityHelper.getContractClass(" + daoHelperClazzName + ".getContracts(), target.getClass());\n" + "        TopiaEntityBinder<E> binder = getTopiaBinder(entityClass, contextName);\n" + "        if (binder == null) {\n" + "            throw new NullPointerException(\"could not find a simple topia binder of type : \" + target.getClass());\n" + "        }\n" + "        binder.load(source, target, tech);\n" + "    ");
        op = this.addOperation((ObjectModelClassifier)resultClass, "simpleCopy", "<E extends TopiaEntity> void", new ObjectModelModifier[]{ObjectModelModifier.PUBLIC, ObjectModelModifier.STATIC});
        this.addParameter(op, "E", "source");
        this.addParameter(op, "E", "target");
        this.addParameter(op, "boolean", "tech");
        this.setOperationBody(op, "\n        Class<E> entityClass = (Class<E>) TopiaEntityHelper.getContractClass(" + daoHelperClazzName + ".getContracts(), target.getClass());\n" + "        TopiaEntityBinder<E> binder = getSimpleTopiaBinder(entityClass);\n" + "        if (binder == null) {\n" + "            throw new NullPointerException(\"could not find a simple topia binder of type : \" + target.getClass());\n" + "        }\n" + "        binder.load(source, target, tech);\n" + "    ");
        StringBuilder initCode = new StringBuilder();
        initCode.append("\n         BinderBuilder builder = new BinderBuilder();\n");
        for (ObjectModelClass clazz : classes) {
            this.generateBinder(modelName, clazz, resultClass, initCode);
        }
        op = this.addOperation((ObjectModelClassifier)resultClass, "initBinders", "void", new ObjectModelModifier[]{ObjectModelModifier.PROTECTED, ObjectModelModifier.STATIC});
        this.setOperationBody(op, initCode.toString());
        op = this.addOperation((ObjectModelClassifier)resultClass, null, null, new ObjectModelModifier[]{ObjectModelModifier.STATIC});
        this.setOperationBody(op, "\n    initBinders();\n");
    }

    protected void generateBinder(String modelName, ObjectModelClass clazz, ObjectModelClass resultClass, StringBuilder initCode) {
        ArrayList<ObjectModelAttribute> list = new ArrayList<ObjectModelAttribute>();
        for (ObjectModelAttribute attr : clazz.getAttributes()) {
            if (!attr.isNavigable() || GeneratorUtil.isNMultiplicity((ObjectModelAttribute)attr)) continue;
            list.add(attr);
        }
        String clazzName = clazz.getName();
        if (list.isEmpty()) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("no attribute to add in a binder for " + clazzName + ", will not generate it."));
            }
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("generate simple binder for " + clazzName));
        }
        this.addImport((ObjectModelClassifier)resultClass, clazz);
        initCode.append("\n        builder.createBinderModel(" + clazzName + ".class);\n" + "        builder.addSimpleProperties(\n" + "");
        Iterator itr = list.iterator();
        while (itr.hasNext()) {
            ObjectModelAttribute attr = (ObjectModelAttribute)itr.next();
            String attrName = attr.getName();
            boolean hasNext = itr.hasNext();
            initCode.append("            " + clazzName + "." + this.getConstantName(attrName) + "" + (hasNext ? ",\n" : "") + "");
        }
        initCode.append("\n        );\n        registerTopiaBinder(builder, \"" + modelName + "\");\n" + "    ");
    }
}

