/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.topia.generator;

import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.eugene.GeneratorUtil;
import org.nuiton.eugene.ObjectModelGenerator;
import org.nuiton.eugene.models.Model;
import org.nuiton.eugene.models.object.ObjectModel;
import org.nuiton.eugene.models.object.ObjectModelClass;
import org.nuiton.eugene.models.object.ObjectModelElement;
import org.nuiton.topia.TopiaContext;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.framework.TopiaContextImplementor;
import org.nuiton.topia.generator.TopiaGeneratorUtil;
import org.nuiton.topia.persistence.TopiaDAO;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.util.EntityOperator;
import org.nuiton.topia.persistence.util.EntityOperatorStore;

public class DAOHelperGenerator
extends ObjectModelGenerator {
    private Log log = LogFactory.getLog(DAOHelperGenerator.class);

    public String getFilenameForModel(ObjectModel model) {
        String modelName = GeneratorUtil.capitalize((String)model.getName());
        return (this.getProperty("defaultPackage") + ".").replace('.', File.separatorChar) + modelName + "DAOHelper.java";
    }

    public void generateFromModel(Writer output, ObjectModel model) throws IOException {
        String clazzName;
        String copyright = TopiaGeneratorUtil.getCopyright((Model)model);
        if (TopiaGeneratorUtil.notEmpty(copyright)) {
            output.write("" + copyright + "\n");
            output.write("");
        }
        String packageName = this.getProperty("defaultPackage");
        output.write("package " + packageName + ";\n");
        output.write("\n");
        output.write("");
        String modelName = GeneratorUtil.capitalize((String)model.getName());
        String modelVersion = model.getVersion();
        String daoHelperClazzName = modelName + "DAOHelper";
        String entityEnumName = modelName + "EntityEnum";
        List<ObjectModelClass> classes = TopiaGeneratorUtil.getEntityClasses(model, true);
        boolean generateOperator = TopiaGeneratorUtil.shouldgenerateOperatorForDAOHelper(null, model);
        List<String> imports = this.computeImports(generateOperator, packageName, classes);
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("imports for class <" + daoHelperClazzName + ">"));
        }
        for (String anImport : imports) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("import " + anImport));
            }
            output.write("import " + anImport + ";\n");
            output.write("");
        }
        output.write("\n");
        output.write("public class " + daoHelperClazzName + " {\n");
        output.write("\n");
        output.write("");
        output.write("    /**\n");
        output.write("     * no instance for this helper\n");
        output.write("     */\n");
        output.write("    protected " + daoHelperClazzName + "() {\n");
        output.write("    }\n");
        output.write("\n");
        output.write("    /**\n");
        output.write("     * Model version.\n");
        output.write("     * \n");
        output.write("     * @return model version\n");
        output.write("     */\n");
        output.write("    public static String getModelVersion() {\n");
        output.write("        return \"" + modelVersion + "\";\n");
        output.write("    }\n");
        output.write("");
        for (ObjectModelClass clazz : classes) {
            clazzName = clazz.getName();
            String daoClazzName = clazzName + "DAO";
            output.write("\n");
            output.write("    public static " + daoClazzName + " get" + daoClazzName + "(TopiaContext context) throws TopiaException {\n");
            output.write("        TopiaContextImplementor ci = (TopiaContextImplementor) context;\n");
            output.write("        " + daoClazzName + " result = (" + daoClazzName + ") ci.getDAO(" + clazzName + ".class);\n");
            output.write("        return result;\n");
            output.write("    }\n");
            output.write("");
        }
        output.write("\n");
        output.write("    @SuppressWarnings({\"unchecked\"})\n");
        output.write("    public static <T extends TopiaEntity, D extends TopiaDAO<? super T>> D getDAO(TopiaContext context, Class<T> klass) throws TopiaException {\n");
        output.write("        TopiaContextImplementor ci = (TopiaContextImplementor) context;\n");
        output.write("        " + entityEnumName + " constant = " + entityEnumName + ".valueOf(klass);\n");
        output.write("        D dao = (D) ci.getDAO(constant.getContract());\n");
        output.write("        return dao;\n");
        output.write("    }\n");
        output.write("\n");
        output.write("    @SuppressWarnings({\"unchecked\"})\n");
        output.write("    public static <T extends TopiaEntity, D extends TopiaDAO<? super T>> D getDAO(TopiaContext context, T entity) throws TopiaException {\n");
        output.write("        TopiaContextImplementor ci = (TopiaContextImplementor) context;\n");
        output.write("        " + entityEnumName + " constant = " + entityEnumName + ".valueOf(entity);\n");
        output.write("        D dao = (D) ci.getDAO(constant.getContract());\n");
        output.write("        return dao;\n");
        output.write("    }\n");
        output.write("\n");
        output.write("    @SuppressWarnings({\"unchecked\"})\n");
        output.write("    public static <T extends TopiaEntity> Class<T> getContractClass(Class<T> klass) {\n");
        output.write("        " + entityEnumName + " constant = " + entityEnumName + ".valueOf(klass);\n");
        output.write("        return (Class<T>) constant.getContract();\n");
        output.write("    }\n");
        output.write("\n");
        output.write("    @SuppressWarnings({\"unchecked\"})\n");
        output.write("    public static <T extends TopiaEntity> Class<T> getImplementationClass(Class<T> klass) {\n");
        output.write("        " + entityEnumName + " constant = " + entityEnumName + ".valueOf(klass);\n");
        output.write("        return (Class<T>) constant.getImplementation();\n");
        output.write("    }\n");
        output.write("\n");
        output.write("    @SuppressWarnings({\"unchecked\"})\n");
        output.write("    public static Class<? extends TopiaEntity>[] getContractClasses() {\n");
        output.write("        " + entityEnumName + "[] values = " + entityEnumName + ".values();\n");
        output.write("        Class<? extends TopiaEntity>[] result = (Class<? extends TopiaEntity>[]) Array.newInstance(Class.class, values.length);\n");
        output.write("        for (int i = 0; i < values.length; i++) {\n");
        output.write("            result[i] = values[i].getContract();\n");
        output.write("        }\n");
        output.write("        return result;\n");
        output.write("    }\n");
        output.write("\n");
        output.write("    @SuppressWarnings({\"unchecked\"})\n");
        output.write("    public static Class<? extends TopiaEntity>[] getImplementationClasses() {\n");
        output.write("        " + entityEnumName + "[] values = " + entityEnumName + ".values();\n");
        output.write("        Class<? extends TopiaEntity>[] result = (Class<? extends TopiaEntity>[]) Array.newInstance(Class.class, values.length);\n");
        output.write("        for (int i = 0; i < values.length; i++) {\n");
        output.write("            result[i] = values[i].getImplementation();\n");
        output.write("        }\n");
        output.write("        return result;\n");
        output.write("    }\n");
        output.write("\n");
        output.write("    public static String getImplementationClassesAsString() {\n");
        output.write("        StringBuilder buffer = new StringBuilder();\n");
        output.write("        for (Class<? extends TopiaEntity> aClass : getImplementationClasses()) {\n");
        output.write("            buffer.append(',').append(aClass.getName());\n");
        output.write("        }\n");
        output.write("        return buffer.substring(1);\n");
        output.write("    }\n");
        output.write("\n");
        output.write("    public static " + entityEnumName + "[] getContracts() {\n");
        output.write("        return " + entityEnumName + ".values();\n");
        output.write("    }\n");
        output.write("");
        if (generateOperator) {
            output.write("\n");
            output.write("    @SuppressWarnings({\"unchecked\"})\n");
            output.write("    public static <T extends TopiaEntity> EntityOperator<T> getOperator(Class<T> klass) {\n");
            output.write("        " + entityEnumName + " constant = " + entityEnumName + ".valueOf(klass);\n");
            output.write("        return (EntityOperator<T>) EntityOperatorStore.getOperator(constant);\n");
            output.write("    }\n");
            output.write("");
        }
        output.write("\n");
        output.write("    /*\n");
        output.write("     * Enumeration of all types of entities managed by this helper.\n");
        output.write("     */\n");
        output.write("    public enum " + entityEnumName + " implements org.nuiton.topia.persistence.TopiaEntityEnum {\n");
        output.write("");
        Iterator<ObjectModelClass> i = classes.iterator();
        while (i.hasNext()) {
            ObjectModelClass clazz;
            clazz = i.next();
            clazzName = clazz.getName();
            output.write("\n");
            output.write("        " + clazzName + "(" + clazzName + ".class)" + (i.hasNext() ? "," : ";") + "");
        }
        output.write("\n");
        output.write("\n");
        output.write("        /** the contract of the entity */\n");
        output.write("        private Class<? extends TopiaEntity> contract;\n");
        output.write("\n");
        output.write("        /** the fully qualified name of the implementation of the entity */\n");
        output.write("        private String implementationFQN;\n");
        output.write("\n");
        output.write("        /** the implementation class of the entity (will be lazy computed at runtime)*/\n");
        output.write("        private Class<? extends TopiaEntity> implementation;\n");
        output.write("\n");
        output.write("        " + entityEnumName + "(Class<? extends TopiaEntity > contract) {\n");
        output.write("            this.contract = contract;\n");
        output.write("            this.implementationFQN = contract.getName()+\"Impl\";\n");
        output.write("        }\n");
        output.write("\n");
        output.write("        @Override\n");
        output.write("        public Class<? extends TopiaEntity> getContract() {\n");
        output.write("            return contract;\n");
        output.write("        }\n");
        output.write("       \n");
        output.write("        @Deprecated\n");
        output.write("        public Class<? extends TopiaEntity> getContractClass() {\n");
        output.write("            return getContract();\n");
        output.write("        }\n");
        output.write("        \n");
        output.write("        @Deprecated\n");
        output.write("        public Class<? extends TopiaEntity> getImplementationClass() {\n");
        output.write("            return getImplementation();\n");
        output.write("        }\n");
        output.write("\n");
        output.write("        @Override\n");
        output.write("        public String getImplementationFQN() {\n");
        output.write("            return implementationFQN;\n");
        output.write("        }\n");
        output.write("\n");
        output.write("        @Override\n");
        output.write("        public synchronized void setImplementationFQN(String implementationFQN) {\n");
        output.write("            this.implementationFQN = implementationFQN;\n");
        output.write("            this.implementation = null;\n");
        output.write("");
        if (generateOperator) {
            output.write("            // on reinitialise le magasin d'operators\n");
            output.write("            EntityOperatorStore.clear();\n");
            output.write("");
        }
        output.write("        }\n");
        output.write("\n");
        output.write("        @Override\n");
        output.write("        public boolean accept(Class<? extends TopiaEntity> klass) {\n");
        output.write("            return " + daoHelperClazzName + ".getContractClass(klass) == contract;\n");
        output.write("        }\n");
        output.write(" \n");
        output.write("        @Override\n");
        output.write("        @SuppressWarnings({\"unchecked\"})\n");
        output.write("        public Class<? extends TopiaEntity> getImplementation() {\n");
        output.write("            if (implementation == null) {\n");
        output.write("                try {\n");
        output.write("                    implementation = (Class<? extends TopiaEntity>) Class.forName(implementationFQN);\n");
        output.write("                } catch (ClassNotFoundException e) {\n");
        output.write("                    throw new RuntimeException(\"could not find class \" + implementationFQN);\n");
        output.write("                }\n");
        output.write("            }\n");
        output.write("            return implementation;\n");
        output.write("        }\n");
        output.write("\n");
        output.write("        public static " + entityEnumName + " valueOf(TopiaEntity entity) {\n");
        output.write("            return valueOf(entity.getClass());\n");
        output.write("        }\n");
        output.write("\n");
        output.write("        public static " + entityEnumName + " valueOf(Class<?> klass) {\n");
        output.write("            if (klass.isInterface()) {\n");
        output.write("                return " + entityEnumName + ".valueOf(klass.getSimpleName());\n");
        output.write("            }\n");
        output.write("            for (" + entityEnumName + " entityEnum : " + entityEnumName + ".values()) {\n");
        output.write("                if (entityEnum.getContract().isAssignableFrom(klass)) {\n");
        output.write("                    //todo check it works for inheritance\n");
        output.write("                    return entityEnum;\n");
        output.write("                }\n");
        output.write("            }\n");
        output.write("            throw new IllegalArgumentException(\"no entity defined for the class \" + klass + \" in : \" + Arrays.toString(" + entityEnumName + ".values()));\n");
        output.write("        }        \n");
        output.write("    }\n");
        output.write("");
        String entitiesList = "";
        if (classes.isEmpty()) {
            output.write("\n");
            output.write("    /**\n");
            output.write("      * @eprecated (prefer use {@link #getImplementationClassesAsString()}\n");
            output.write("      */ \n");
            output.write("    public static final String entitiesList = \"\";\n");
            output.write("");
        } else {
            output.write("\n");
            output.write("    /**\n");
            output.write("     * use {@link #getImplementationClassesAsString()}\n");
            output.write("     *\n");
            output.write("     * @deprecated (will be removed soon).\n");
            output.write("     */\n");
            output.write("    public static final String entitiesList = \"\" +\n");
            output.write("");
            Iterator<ObjectModelClass> i2 = classes.iterator();
            while (i2.hasNext()) {
                ObjectModelClass clazz = i2.next();
                String doType = TopiaGeneratorUtil.getDOType((ObjectModelElement)clazz, model);
                entitiesList = entitiesList + doType + (i2.hasNext() ? "," : "");
                output.write("        \"" + doType + "" + (i2.hasNext() ? ",\" +" : "\";") + "\n");
                output.write("");
            }
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Full entities list : " + entitiesList));
        }
        output.write("\n");
        output.write("} //" + daoHelperClazzName + "\n");
        output.write("");
    }

    protected List<String> computeImports(boolean generateOperator, String packageName, List<ObjectModelClass> classes) {
        HashSet<String> imports = new HashSet<String>(Arrays.asList(Array.class.getName(), Arrays.class.getName(), TopiaContext.class.getName(), TopiaException.class.getName(), TopiaContextImplementor.class.getName(), TopiaDAO.class.getName(), TopiaEntity.class.getName()));
        if (generateOperator) {
            imports.add(EntityOperator.class.getName());
            imports.add(EntityOperatorStore.class.getName());
        }
        for (ObjectModelClass clazz : classes) {
            String clazzFQN = clazz.getQualifiedName();
            imports.add(clazzFQN);
            imports.add(clazzFQN + "DAO");
        }
        List<String> cleanImports = TopiaGeneratorUtil.cleanImports(packageName, imports);
        Collections.sort(cleanImports);
        return cleanImports;
    }
}

