package org.nuiton.topia.it.mapping.test4;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import javax.annotation.Generated;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.nuiton.topia.persistence.TopiaEntityVisitor;
import org.nuiton.topia.persistence.TopiaException;
import org.nuiton.topia.persistence.internal.AbstractTopiaEntity;

@Generated(value = "org.nuiton.topia.templates.EntityTransformer", date = "Wed Apr 09 18:07:33 CEST 2014")
public abstract class A4Abstract extends AbstractTopiaEntity implements A4 {

    /**
     * Nom de l'attribut en BD : strings
     */
    protected Collection<String> strings;

    /**
     * Nom de l'attribut en BD : enumerations
     */
    protected Collection<E4> enumerations;

    /**
     * Nom de l'attribut en BD : dates
     */
    protected Collection<Date> dates;

    private static final long serialVersionUID = 7233681941381853744L;

    @Override
    public void accept(TopiaEntityVisitor visitor) throws TopiaException {
        visitor.start(this);
        visitor.visit(this, PROPERTY_STRINGS, Collection.class, String.class, strings);
        visitor.visit(this, PROPERTY_ENUMERATIONS, Collection.class, E4.class, enumerations);
        visitor.visit(this, PROPERTY_DATES, Collection.class, Date.class, dates);
        visitor.end(this);
    }

    @Override
    public void addStrings(String strings) {
        fireOnPreWrite(PROPERTY_STRINGS, null, strings);
        if (this.strings == null) {
            this.strings = new ArrayList<String>();
        }

        this.strings.add(strings);
        fireOnPostWrite(PROPERTY_STRINGS, this.strings.size(), null, strings);
    }

    @Override
    public void addAllStrings(Collection<String> strings) {
        if (strings == null) {
            return;
        }
        for (String item : strings) {
            addStrings(item);
        }
    }

    @Override
    public void setStrings(Collection<String> strings) {
        // Copy elements to keep data for fire with new reference
        Collection<String> oldValue = this.strings != null ? new ArrayList<String>(this.strings) : null;
        fireOnPreWrite(PROPERTY_STRINGS, oldValue, strings);
        this.strings = strings;
        fireOnPostWrite(PROPERTY_STRINGS, oldValue, strings);
    }

    @Override
    public void removeStrings(String strings) {
        fireOnPreWrite(PROPERTY_STRINGS, strings, null);
        if (this.strings == null || !this.strings.remove(strings)) {
            throw new IllegalArgumentException("List does not contain given element");
        }

        fireOnPostWrite(PROPERTY_STRINGS, this.strings.size() + 1, strings, null);
    }

    @Override
    public void clearStrings() {
        if (this.strings == null) {
            return;
        }
        Collection<String> oldValue = new ArrayList<String>(this.strings);
        fireOnPreWrite(PROPERTY_STRINGS, oldValue, this.strings);
        this.strings.clear();
        fireOnPostWrite(PROPERTY_STRINGS, oldValue, this.strings);
    }

    @Override
    public Collection<String> getStrings() {
        return strings;
    }

    @Override
    public int sizeStrings() {
        if (strings == null) {
            return 0;
        }
        return strings.size();
    }

    @Override
    public boolean isStringsEmpty() {
        int size = sizeStrings();
        return size == 0;
    }

    @Override
    public boolean isStringsNotEmpty() {
        boolean empty = isStringsEmpty();
        return ! empty;
    }

    @Override
    public void addEnumerations(E4 enumerations) {
        fireOnPreWrite(PROPERTY_ENUMERATIONS, null, enumerations);
        if (this.enumerations == null) {
            this.enumerations = new ArrayList<E4>();
        }

        this.enumerations.add(enumerations);
        fireOnPostWrite(PROPERTY_ENUMERATIONS, this.enumerations.size(), null, enumerations);
    }

    @Override
    public void addAllEnumerations(Collection<E4> enumerations) {
        if (enumerations == null) {
            return;
        }
        for (E4 item : enumerations) {
            addEnumerations(item);
        }
    }

    @Override
    public void setEnumerations(Collection<E4> enumerations) {
        // Copy elements to keep data for fire with new reference
        Collection<E4> oldValue = this.enumerations != null ? new ArrayList<E4>(this.enumerations) : null;
        fireOnPreWrite(PROPERTY_ENUMERATIONS, oldValue, enumerations);
        this.enumerations = enumerations;
        fireOnPostWrite(PROPERTY_ENUMERATIONS, oldValue, enumerations);
    }

    @Override
    public void removeEnumerations(E4 enumerations) {
        fireOnPreWrite(PROPERTY_ENUMERATIONS, enumerations, null);
        if (this.enumerations == null || !this.enumerations.remove(enumerations)) {
            throw new IllegalArgumentException("List does not contain given element");
        }

        fireOnPostWrite(PROPERTY_ENUMERATIONS, this.enumerations.size() + 1, enumerations, null);
    }

    @Override
    public void clearEnumerations() {
        if (this.enumerations == null) {
            return;
        }
        Collection<E4> oldValue = new ArrayList<E4>(this.enumerations);
        fireOnPreWrite(PROPERTY_ENUMERATIONS, oldValue, this.enumerations);
        this.enumerations.clear();
        fireOnPostWrite(PROPERTY_ENUMERATIONS, oldValue, this.enumerations);
    }

    @Override
    public Collection<E4> getEnumerations() {
        return enumerations;
    }

    @Override
    public int sizeEnumerations() {
        if (enumerations == null) {
            return 0;
        }
        return enumerations.size();
    }

    @Override
    public boolean isEnumerationsEmpty() {
        int size = sizeEnumerations();
        return size == 0;
    }

    @Override
    public boolean isEnumerationsNotEmpty() {
        boolean empty = isEnumerationsEmpty();
        return ! empty;
    }

    @Override
    public void addDates(Date dates) {
        fireOnPreWrite(PROPERTY_DATES, null, dates);
        if (this.dates == null) {
            this.dates = new ArrayList<Date>();
        }

        this.dates.add(dates);
        fireOnPostWrite(PROPERTY_DATES, this.dates.size(), null, dates);
    }

    @Override
    public void addAllDates(Collection<Date> dates) {
        if (dates == null) {
            return;
        }
        for (Date item : dates) {
            addDates(item);
        }
    }

    @Override
    public void setDates(Collection<Date> dates) {
        // Copy elements to keep data for fire with new reference
        Collection<Date> oldValue = this.dates != null ? new ArrayList<Date>(this.dates) : null;
        fireOnPreWrite(PROPERTY_DATES, oldValue, dates);
        this.dates = dates;
        fireOnPostWrite(PROPERTY_DATES, oldValue, dates);
    }

    @Override
    public void removeDates(Date dates) {
        fireOnPreWrite(PROPERTY_DATES, dates, null);
        if (this.dates == null || !this.dates.remove(dates)) {
            throw new IllegalArgumentException("List does not contain given element");
        }

        fireOnPostWrite(PROPERTY_DATES, this.dates.size() + 1, dates, null);
    }

    @Override
    public void clearDates() {
        if (this.dates == null) {
            return;
        }
        Collection<Date> oldValue = new ArrayList<Date>(this.dates);
        fireOnPreWrite(PROPERTY_DATES, oldValue, this.dates);
        this.dates.clear();
        fireOnPostWrite(PROPERTY_DATES, oldValue, this.dates);
    }

    @Override
    public Collection<Date> getDates() {
        return dates;
    }

    @Override
    public int sizeDates() {
        if (dates == null) {
            return 0;
        }
        return dates.size();
    }

    @Override
    public boolean isDatesEmpty() {
        int size = sizeDates();
        return size == 0;
    }

    @Override
    public boolean isDatesNotEmpty() {
        boolean empty = isDatesEmpty();
        return ! empty;
    }

    @Override
    public String toString() {
        String result = new ToStringBuilder(this).
            append(PROPERTY_STRINGS, this.strings).
            append(PROPERTY_ENUMERATIONS, this.enumerations).
            append(PROPERTY_DATES, this.dates).
         toString();
        return result;
    }

} //A4Abstract
