/*
 * Decompiled with CFR 0.152.
 */
package org.fife.ui.rsyntaxtextarea;

import java.awt.Container;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.util.Stack;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.Segment;
import javax.swing.text.TextAction;
import org.fife.ui.rsyntaxtextarea.CodeTemplateManager;
import org.fife.ui.rsyntaxtextarea.RSyntaxDocument;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextArea;
import org.fife.ui.rsyntaxtextarea.RSyntaxUtilities;
import org.fife.ui.rsyntaxtextarea.Style;
import org.fife.ui.rsyntaxtextarea.SyntaxScheme;
import org.fife.ui.rsyntaxtextarea.Token;
import org.fife.ui.rsyntaxtextarea.templates.CodeTemplate;
import org.fife.ui.rtextarea.RTextArea;
import org.fife.ui.rtextarea.RTextAreaEditorKit;
import org.fife.ui.rtextarea.RecordableTextAction;

public class RSyntaxTextAreaEditorKit
extends RTextAreaEditorKit {
    private static final long serialVersionUID = 1L;
    public static final String rstaCloseCurlyBraceAction = "RSTA.CloseCurlyBraceAction";
    public static final String rstaCloseMarkupTagAction = "RSTA.CloseMarkupTagAction";
    public static final String rstaCopyAsRtfAction = "RSTA.CopyAsRtfAction";
    public static final String rstaDecreaseIndentAction = "RSTA.DecreaseIndentAction";
    public static final String rstaGoToMatchingBracketAction = "RSTA.GoToMatchingBracketAction";
    public static final String rstaPossiblyInsertTemplateAction = "RSTA.TemplateAction";
    public static final String rstaToggleCommentAction = "RSTA.ToggleCommentAction";
    private static final Action[] defaultActions = new Action[]{new CloseCurlyBraceAction(), new CloseMarkupTagAction(), new BeginWordAction("caret-begin-word", false), new BeginWordAction("selection-begin-word", true), new CopyAsRtfAction(), new DecreaseIndentAction(), new EndWordAction("caret-end-word", false), new EndWordAction("caret-end-word", true), new GoToMatchingBracketAction(), new InsertBreakAction(), new InsertTabAction(), new NextWordAction("caret-next-word", false), new NextWordAction("selection-next-word", true), new PossiblyInsertTemplateAction(), new PreviousWordAction("caret-previous-word", false), new PreviousWordAction("selection-previous-word", true), new SelectWordAction(), new ToggleCommentAction()};

    @Override
    public Document createDefaultDocument() {
        return new RSyntaxDocument("text/plain");
    }

    @Override
    public Action[] getActions() {
        return TextAction.augmentList(super.getActions(), defaultActions);
    }

    public static class ToggleCommentAction
    extends RecordableTextAction {
        public ToggleCommentAction() {
            super(RSyntaxTextAreaEditorKit.rstaToggleCommentAction);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void actionPerformedImpl(ActionEvent e, RTextArea textArea) {
            int end;
            int line2;
            if (!textArea.isEditable() || !textArea.isEnabled()) {
                UIManager.getLookAndFeel().provideErrorFeedback(textArea);
                return;
            }
            RSyntaxDocument doc = (RSyntaxDocument)textArea.getDocument();
            String[] startEnd = doc.getLineCommentStartAndEnd();
            if (startEnd == null) {
                UIManager.getLookAndFeel().provideErrorFeedback(textArea);
                return;
            }
            Element map = doc.getDefaultRootElement();
            Caret c = textArea.getCaret();
            int dot = c.getDot();
            int mark = c.getMark();
            int line1 = map.getElementIndex(dot);
            int start = Math.min(line1, line2 = map.getElementIndex(mark));
            if (start != (end = Math.max(line1, line2))) {
                Element elem = map.getElement(end);
                if (Math.max(dot, mark) == elem.getStartOffset()) {
                    --end;
                }
            }
            textArea.beginAtomicEdit();
            try {
                boolean add = this.getDoAdd(doc, map, start, end, startEnd);
                for (line1 = start; line1 <= end; ++line1) {
                    Element elem = map.getElement(line1);
                    this.handleToggleComment(elem, doc, startEnd, add);
                }
            }
            catch (BadLocationException ble) {
                ble.printStackTrace();
                UIManager.getLookAndFeel().provideErrorFeedback(textArea);
            }
            finally {
                textArea.endAtomicEdit();
            }
        }

        private boolean getDoAdd(Document doc, Element map, int startLine, int endLine, String[] startEnd) throws BadLocationException {
            boolean doAdd = false;
            for (int i = startLine; i <= endLine; ++i) {
                Element elem = map.getElement(i);
                int start = elem.getStartOffset();
                String t = doc.getText(start, elem.getEndOffset() - start - 1);
                if (t.startsWith(startEnd[0]) && (startEnd[1] == null || t.endsWith(startEnd[1]))) continue;
                doAdd = true;
                break;
            }
            return doAdd;
        }

        private void handleToggleComment(Element elem, Document doc, String[] startEnd, boolean add) throws BadLocationException {
            int start = elem.getStartOffset();
            int end = elem.getEndOffset() - 1;
            if (add) {
                doc.insertString(start, startEnd[0], null);
                if (startEnd[1] != null) {
                    doc.insertString(end + startEnd[0].length(), startEnd[1], null);
                }
            } else {
                doc.remove(start, startEnd[0].length());
                if (startEnd[1] != null) {
                    int temp = startEnd[1].length();
                    doc.remove(end - startEnd[0].length() - temp, temp);
                }
            }
        }

        @Override
        public final String getMacroID() {
            return RSyntaxTextAreaEditorKit.rstaToggleCommentAction;
        }
    }

    public static class SelectWordAction
    extends RTextAreaEditorKit.SelectWordAction {
        @Override
        protected void createActions() {
            this.start = new BeginWordAction("pigdog", false);
            this.end = new EndWordAction("pigdog", true);
        }
    }

    public static class PreviousWordAction
    extends RTextAreaEditorKit.PreviousWordAction {
        private Segment seg = new Segment();

        public PreviousWordAction(String nm, boolean select) {
            super(nm, select);
        }

        @Override
        protected int getPreviousWord(RTextArea textArea, int offs) throws BadLocationException {
            if (offs == 0) {
                return offs;
            }
            RSyntaxDocument doc = (RSyntaxDocument)textArea.getDocument();
            int line = textArea.getLineOfOffset(offs);
            int start = textArea.getLineStartOffset(line);
            if (offs == start) {
                return start - 1;
            }
            doc.getText(start, offs - start, this.seg);
            char ch = this.seg.last();
            while (Character.isWhitespace(ch)) {
                ch = this.seg.previous();
            }
            if (Character.isLetterOrDigit(ch)) {
                while (Character.isLetterOrDigit(ch = this.seg.previous())) {
                }
            } else if (!Character.isWhitespace(ch)) {
                while ((ch = this.seg.previous()) != '\uffff' && !Character.isLetterOrDigit(ch) && !Character.isWhitespace(ch)) {
                }
            }
            offs -= this.seg.getEndIndex() - this.seg.getIndex();
            if (ch != '\uffff') {
                ++offs;
            }
            return offs;
        }
    }

    public static class PossiblyInsertTemplateAction
    extends RecordableTextAction {
        private static final long serialVersionUID = 1L;

        public PossiblyInsertTemplateAction() {
            super(RSyntaxTextAreaEditorKit.rstaPossiblyInsertTemplateAction);
        }

        @Override
        public void actionPerformedImpl(ActionEvent e, RTextArea textArea) {
            block7: {
                if (!textArea.isEditable() || !textArea.isEnabled()) {
                    return;
                }
                RSyntaxTextArea rsta = (RSyntaxTextArea)textArea;
                if (RSyntaxTextArea.getTemplatesEnabled()) {
                    Document doc = textArea.getDocument();
                    if (doc != null) {
                        try {
                            CodeTemplate template;
                            CodeTemplateManager manager = RSyntaxTextArea.getCodeTemplateManager();
                            CodeTemplate codeTemplate = template = manager == null ? null : manager.getTemplate(rsta);
                            if (template != null) {
                                template.invoke(rsta);
                                break block7;
                            }
                            this.doDefaultInsert(rsta);
                        }
                        catch (BadLocationException ble) {
                            UIManager.getLookAndFeel().provideErrorFeedback(textArea);
                        }
                    }
                } else {
                    this.doDefaultInsert(rsta);
                }
            }
        }

        private final void doDefaultInsert(RTextArea textArea) {
            textArea.replaceSelection(" ");
        }

        @Override
        public final String getMacroID() {
            return RSyntaxTextAreaEditorKit.rstaPossiblyInsertTemplateAction;
        }
    }

    public static class NextWordAction
    extends RTextAreaEditorKit.NextWordAction {
        private Segment seg = new Segment();

        public NextWordAction(String nm, boolean select) {
            super(nm, select);
        }

        @Override
        protected int getNextWord(RTextArea textArea, int offs) throws BadLocationException {
            RSyntaxDocument doc = (RSyntaxDocument)textArea.getDocument();
            if (offs == doc.getLength()) {
                return offs;
            }
            int line = textArea.getLineOfOffset(offs);
            int end = textArea.getLineEndOffset(line);
            if (offs == end) {
                return offs + 1;
            }
            doc.getText(offs, end - offs, this.seg);
            char ch = this.seg.first();
            if (Character.isLetterOrDigit(ch)) {
                while (Character.isLetterOrDigit(ch = this.seg.next())) {
                }
            } else if (!Character.isWhitespace(ch)) {
                while ((ch = this.seg.next()) != '\uffff' && !Character.isLetterOrDigit(ch) && !Character.isWhitespace(ch)) {
                }
            }
            while (Character.isWhitespace(ch)) {
                ch = this.seg.next();
            }
            return offs += this.seg.getIndex() - this.seg.getBeginIndex();
        }
    }

    public static class InsertTabAction
    extends RecordableTextAction {
        private static final long serialVersionUID = 1L;

        public InsertTabAction() {
            super("insert-tab");
        }

        public InsertTabAction(String name) {
            super(name);
        }

        @Override
        public void actionPerformedImpl(ActionEvent e, RTextArea textArea) {
            int markLine;
            if (!textArea.isEditable() || !textArea.isEnabled()) {
                UIManager.getLookAndFeel().provideErrorFeedback(textArea);
                return;
            }
            Document document = textArea.getDocument();
            Element map = document.getDefaultRootElement();
            Caret c = textArea.getCaret();
            int dot = c.getDot();
            int mark = c.getMark();
            int dotLine = map.getElementIndex(dot);
            if (dotLine != (markLine = map.getElementIndex(mark))) {
                int first = Math.min(dotLine, markLine);
                int last = Math.max(dotLine, markLine);
                try {
                    int start;
                    Element elem;
                    for (int i = first; i < last; ++i) {
                        elem = map.getElement(i);
                        start = elem.getStartOffset();
                        document.insertString(start, "\t", null);
                    }
                    elem = map.getElement(last);
                    start = elem.getStartOffset();
                    if (Math.max(c.getDot(), c.getMark()) != start) {
                        document.insertString(start, "\t", null);
                    }
                }
                catch (BadLocationException ble) {
                    ble.printStackTrace();
                    UIManager.getLookAndFeel().provideErrorFeedback(textArea);
                }
            } else {
                textArea.replaceSelection("\t");
            }
        }

        @Override
        public final String getMacroID() {
            return "insert-tab";
        }
    }

    public static class InsertBreakAction
    extends RTextAreaEditorKit.InsertBreakAction {
        private static final long serialVersionUID = 1L;

        @Override
        public void actionPerformedImpl(ActionEvent e, RTextArea textArea) {
            boolean noSelection;
            if (!textArea.isEditable() || !textArea.isEnabled()) {
                UIManager.getLookAndFeel().provideErrorFeedback(textArea);
                return;
            }
            RSyntaxTextArea sta = (RSyntaxTextArea)textArea;
            boolean bl = noSelection = sta.getSelectionStart() == sta.getSelectionEnd();
            if (noSelection && sta.isAutoIndentEnabled()) {
                this.insertNewlineWithAutoIndent(sta);
            } else {
                textArea.replaceSelection("\n");
                if (noSelection) {
                    this.possiblyCloseCurlyBrace(sta, null);
                }
            }
        }

        private static final int atEndOfLine(int pos, String s, int sLen) {
            for (int i = pos; i < sLen; ++i) {
                if (RSyntaxUtilities.isWhitespace(s.charAt(i))) continue;
                return i;
            }
            return -1;
        }

        private static final int getOpenBraceCount(RSyntaxDocument doc) {
            int openCount = 0;
            Element root = doc.getDefaultRootElement();
            int lineCount = root.getElementCount();
            for (int i = 0; i < lineCount; ++i) {
                for (Token t = doc.getTokenListForLine(i); t != null && t.isPaintable(); t = t.getNextToken()) {
                    if (t.type != 17 || t.textCount != 1) continue;
                    char ch = t.text[t.textOffset];
                    if (ch == '{') {
                        ++openCount;
                        continue;
                    }
                    if (ch != '}') continue;
                    --openCount;
                }
            }
            return openCount;
        }

        private void insertNewlineWithAutoIndent(RSyntaxTextArea sta) {
            try {
                int caretPos = sta.getCaretPosition();
                Document doc = sta.getDocument();
                Element map = doc.getDefaultRootElement();
                int lineNum = map.getElementIndex(caretPos);
                Element line = map.getElement(lineNum);
                int start = line.getStartOffset();
                int end = line.getEndOffset() - 1;
                int len = end - start;
                String s = doc.getText(start, len);
                String leadingWS = RSyntaxUtilities.getLeadingWhitespace(s);
                StringBuffer sb = new StringBuffer("\n");
                sb.append(leadingWS);
                int nonWhitespacePos = InsertBreakAction.atEndOfLine(caretPos - start, s, len);
                if (nonWhitespacePos == -1) {
                    if (leadingWS.length() == len && sta.isClearWhitespaceLinesEnabled()) {
                        sta.setSelectionStart(start);
                        sta.setSelectionEnd(end);
                    }
                    sta.replaceSelection(sb.toString());
                } else {
                    sb.append(s.substring(nonWhitespacePos));
                    sta.replaceRange(sb.toString(), caretPos, end);
                    sta.setCaretPosition(caretPos + leadingWS.length() + 1);
                }
                if (sta.getShouldIndentNextLine(lineNum)) {
                    sta.replaceSelection("\t");
                }
                this.possiblyCloseCurlyBrace(sta, leadingWS);
            }
            catch (BadLocationException ble) {
                sta.replaceSelection("\n");
                ble.printStackTrace();
            }
        }

        private void possiblyCloseCurlyBrace(RSyntaxTextArea textArea, String leadingWS) {
            RSyntaxDocument doc = (RSyntaxDocument)textArea.getDocument();
            if (textArea.getCloseCurlyBraces() && doc.getCurlyBracesDenoteCodeBlocks()) {
                int line = textArea.getCaretLineNumber();
                Token t = doc.getTokenListForLine(line - 1);
                if ((t = t.getLastNonCommentNonWhitespaceToken()) != null && t.type == 17 && t.textCount == 1 && t.text[t.textOffset] == '{' && InsertBreakAction.getOpenBraceCount(doc) > 0) {
                    StringBuffer sb = new StringBuffer();
                    if (line == textArea.getLineCount() - 1) {
                        sb.append('\n');
                    }
                    if (leadingWS != null) {
                        sb.append(leadingWS);
                    }
                    sb.append("}\n");
                    int dot = textArea.getCaretPosition();
                    int end = textArea.getLineEndOffsetOfCurrentLine();
                    textArea.insert(sb.toString(), end);
                    textArea.setCaretPosition(dot);
                }
            }
        }
    }

    public static class IncreaseFontSizeAction
    extends RTextAreaEditorKit.IncreaseFontSizeAction {
        private static final long serialVersionUID = 1L;

        public IncreaseFontSizeAction() {
        }

        public IncreaseFontSizeAction(String name, Icon icon, String desc, Integer mnemonic, KeyStroke accelerator) {
            super(name, icon, desc, mnemonic, accelerator);
        }

        @Override
        public void actionPerformedImpl(ActionEvent e, RTextArea textArea) {
            RSyntaxTextArea rsta = (RSyntaxTextArea)textArea;
            SyntaxScheme scheme = rsta.getSyntaxScheme();
            boolean changed = false;
            for (Style ss : scheme.styles) {
                Font font;
                if (ss == null || (font = ss.font) == null) continue;
                float oldSize = font.getSize2D();
                float newSize = oldSize + this.increaseAmount;
                if (newSize <= 40.0f) {
                    ss.font = font.deriveFont(newSize);
                    changed = true;
                    continue;
                }
                if (!(oldSize < 40.0f)) continue;
                ss.font = font.deriveFont(40.0f);
                changed = true;
            }
            Font font = rsta.getFont();
            float oldSize = font.getSize2D();
            float newSize = oldSize + this.increaseAmount;
            if (newSize <= 40.0f) {
                rsta.setFont(font.deriveFont(newSize));
                changed = true;
            } else if (oldSize < 40.0f) {
                rsta.setFont(font.deriveFont(40.0f));
                changed = true;
            }
            if (changed) {
                rsta.setSyntaxScheme(scheme);
                Container parent = rsta.getParent();
                if (parent instanceof JViewport && (parent = parent.getParent()) instanceof JScrollPane) {
                    parent.repaint();
                }
            } else {
                UIManager.getLookAndFeel().provideErrorFeedback(rsta);
            }
        }
    }

    public static class GoToMatchingBracketAction
    extends RecordableTextAction {
        private static final long serialVersionUID = 1L;

        public GoToMatchingBracketAction() {
            super(RSyntaxTextAreaEditorKit.rstaGoToMatchingBracketAction);
        }

        public GoToMatchingBracketAction(String name, Icon icon, String desc, Integer mnemonic, KeyStroke accelerator) {
            super(name, icon, desc, mnemonic, accelerator);
        }

        @Override
        public void actionPerformedImpl(ActionEvent e, RTextArea textArea) {
            RSyntaxTextArea rsta = (RSyntaxTextArea)textArea;
            int pos = RSyntaxUtilities.getMatchingBracketPosition(rsta);
            if (pos > -1) {
                rsta.setCaretPosition(pos + 1);
            } else {
                UIManager.getLookAndFeel().provideErrorFeedback(rsta);
            }
        }

        @Override
        public final String getMacroID() {
            return RSyntaxTextAreaEditorKit.rstaGoToMatchingBracketAction;
        }
    }

    protected static class EndWordAction
    extends RTextAreaEditorKit.EndWordAction {
        private Segment seg = new Segment();

        protected EndWordAction(String name, boolean select) {
            super(name, select);
        }

        @Override
        protected int getWordEnd(RTextArea textArea, int offs) throws BadLocationException {
            RSyntaxDocument doc = (RSyntaxDocument)textArea.getDocument();
            if (offs == doc.getLength()) {
                return offs;
            }
            int line = textArea.getLineOfOffset(offs);
            int end = textArea.getLineEndOffset(line);
            if (line != textArea.getLineCount() - 1) {
                --end;
            }
            if (offs == end) {
                return end;
            }
            doc.getText(offs, end - offs, this.seg);
            char ch = this.seg.first();
            if (Character.isLetterOrDigit(ch)) {
                while (Character.isLetterOrDigit(ch = this.seg.next())) {
                }
            } else if (Character.isWhitespace(ch)) {
                while (Character.isWhitespace(ch = this.seg.next())) {
                }
            }
            return offs += this.seg.getIndex() - this.seg.getBeginIndex();
        }
    }

    public static class DecreaseIndentAction
    extends RecordableTextAction {
        private static final long serialVersionUID = 1L;
        private Segment s = new Segment();

        public DecreaseIndentAction() {
            this(RSyntaxTextAreaEditorKit.rstaDecreaseIndentAction);
        }

        public DecreaseIndentAction(String name) {
            super(name);
        }

        @Override
        public void actionPerformedImpl(ActionEvent e, RTextArea textArea) {
            if (!textArea.isEditable() || !textArea.isEnabled()) {
                UIManager.getLookAndFeel().provideErrorFeedback(textArea);
                return;
            }
            Document document = textArea.getDocument();
            Element map = document.getDefaultRootElement();
            Caret c = textArea.getCaret();
            int dot = c.getDot();
            int mark = c.getMark();
            int line1 = map.getElementIndex(dot);
            int tabSize = textArea.getTabSize();
            if (dot != mark) {
                int line2 = map.getElementIndex(mark);
                dot = Math.min(line1, line2);
                mark = Math.max(line1, line2);
                try {
                    Element elem;
                    for (line1 = dot; line1 < mark; ++line1) {
                        elem = map.getElement(line1);
                        this.handleDecreaseIndent(elem, document, tabSize);
                    }
                    elem = map.getElement(mark);
                    int start = elem.getStartOffset();
                    if (Math.max(c.getDot(), c.getMark()) != start) {
                        this.handleDecreaseIndent(elem, document, tabSize);
                    }
                }
                catch (BadLocationException ble) {
                    ble.printStackTrace();
                    UIManager.getLookAndFeel().provideErrorFeedback(textArea);
                }
            } else {
                Element elem = map.getElement(line1);
                try {
                    this.handleDecreaseIndent(elem, document, tabSize);
                }
                catch (BadLocationException ble) {
                    ble.printStackTrace();
                    UIManager.getLookAndFeel().provideErrorFeedback(textArea);
                }
            }
        }

        @Override
        public final String getMacroID() {
            return RSyntaxTextAreaEditorKit.rstaDecreaseIndentAction;
        }

        private final void handleDecreaseIndent(Element elem, Document doc, int tabSize) throws BadLocationException {
            int start = elem.getStartOffset();
            int end = elem.getEndOffset() - 1;
            doc.getText(start, end - start, this.s);
            int i = this.s.offset;
            end = i + this.s.count;
            if (end > i) {
                if (this.s.array[i] == '\t') {
                    doc.remove(start, 1);
                } else if (this.s.array[i] == ' ') {
                    int toRemove;
                    ++i;
                    for (toRemove = 1; i < end && this.s.array[i] == ' ' && toRemove < tabSize; ++i, ++toRemove) {
                    }
                    doc.remove(start, toRemove);
                }
            }
        }
    }

    public static class DecreaseFontSizeAction
    extends RTextAreaEditorKit.DecreaseFontSizeAction {
        private static final long serialVersionUID = 1L;

        public DecreaseFontSizeAction() {
        }

        public DecreaseFontSizeAction(String name, Icon icon, String desc, Integer mnemonic, KeyStroke accelerator) {
            super(name, icon, desc, mnemonic, accelerator);
        }

        @Override
        public void actionPerformedImpl(ActionEvent e, RTextArea textArea) {
            RSyntaxTextArea rsta = (RSyntaxTextArea)textArea;
            SyntaxScheme scheme = rsta.getSyntaxScheme();
            boolean changed = false;
            for (Style ss : scheme.styles) {
                Font font;
                if (ss == null || (font = ss.font) == null) continue;
                float oldSize = font.getSize2D();
                float newSize = oldSize - this.decreaseAmount;
                if (newSize >= 2.0f) {
                    ss.font = font.deriveFont(newSize);
                    changed = true;
                    continue;
                }
                if (!(oldSize > 2.0f)) continue;
                ss.font = font.deriveFont(2.0f);
                changed = true;
            }
            Font font = rsta.getFont();
            float oldSize = font.getSize2D();
            float newSize = oldSize - this.decreaseAmount;
            if (newSize >= 2.0f) {
                rsta.setFont(font.deriveFont(newSize));
                changed = true;
            } else if (oldSize > 2.0f) {
                rsta.setFont(font.deriveFont(2.0f));
                changed = true;
            }
            if (changed) {
                rsta.setSyntaxScheme(scheme);
                Container parent = rsta.getParent();
                if (parent instanceof JViewport && (parent = parent.getParent()) instanceof JScrollPane) {
                    parent.repaint();
                }
            } else {
                UIManager.getLookAndFeel().provideErrorFeedback(rsta);
            }
        }
    }

    public static class CopyAsRtfAction
    extends RecordableTextAction {
        private static final long serialVersionUID = 1L;

        public CopyAsRtfAction() {
            super(RSyntaxTextAreaEditorKit.rstaCopyAsRtfAction);
        }

        public CopyAsRtfAction(String name, Icon icon, String desc, Integer mnemonic, KeyStroke accelerator) {
            super(name, icon, desc, mnemonic, accelerator);
        }

        @Override
        public void actionPerformedImpl(ActionEvent e, RTextArea textArea) {
            ((RSyntaxTextArea)textArea).copyAsRtf();
            textArea.requestFocusInWindow();
        }

        @Override
        public final String getMacroID() {
            return this.getName();
        }
    }

    public static class CloseMarkupTagAction
    extends RecordableTextAction {
        private static final long serialVersionUID = 1L;

        public CloseMarkupTagAction() {
            super(RSyntaxTextAreaEditorKit.rstaCloseMarkupTagAction);
        }

        @Override
        public void actionPerformedImpl(ActionEvent e, RTextArea textArea) {
            if (!textArea.isEditable() || !textArea.isEnabled()) {
                UIManager.getLookAndFeel().provideErrorFeedback(textArea);
                return;
            }
            RSyntaxTextArea rsta = (RSyntaxTextArea)textArea;
            RSyntaxDocument doc = (RSyntaxDocument)rsta.getDocument();
            Caret c = rsta.getCaret();
            boolean selection = c.getDot() != c.getMark();
            rsta.replaceSelection("/");
            int dot = c.getDot();
            if (doc.getLanguageIsMarkup() && doc.getCompleteMarkupCloseTags() && !selection && rsta.getCloseMarkupTags() && dot > 1) {
                try {
                    char ch = doc.charAt(dot - 2);
                    if (ch == '<' || ch == '[') {
                        String tagName;
                        Token t = doc.getTokenListForLine(rsta.getCaretLineNumber());
                        if ((t = RSyntaxUtilities.getTokenAtOffset(t, dot - 1)) != null && t.type == 20 && (tagName = this.discoverTagName(doc, dot)) != null) {
                            rsta.replaceSelection(tagName + (char)(ch + 2));
                        }
                    }
                }
                catch (BadLocationException ble) {
                    UIManager.getLookAndFeel().provideErrorFeedback(rsta);
                    ble.printStackTrace();
                }
            }
        }

        private String discoverTagName(RSyntaxDocument doc, int dot) {
            Stack<String> stack = new Stack<String>();
            Element root = doc.getDefaultRootElement();
            int curLine = root.getElementIndex(dot);
            for (int i = 0; i <= curLine; ++i) {
                block1: for (Token t = doc.getTokenListForLine(i); t != null && t.isPaintable(); t = t.getNextToken()) {
                    if (t.type != 20) continue;
                    if (t.isSingleChar('<') || t.isSingleChar('[')) {
                        for (t = t.getNextToken(); t != null && t.isPaintable(); t = t.getNextToken()) {
                            if (t.type != 21 && t.type != 22) continue;
                            stack.push(t.getLexeme());
                            continue block1;
                        }
                        continue;
                    }
                    if (t.textCount == 2 && t.text[t.textOffset] == '/' && (t.text[t.textOffset + 1] == '>' || t.text[t.textOffset + 1] == ']')) {
                        if (stack.isEmpty()) continue;
                        stack.pop();
                        continue;
                    }
                    if (t.textCount != 2 || t.text[t.textOffset] != '<' && t.text[t.textOffset] != '[' || t.text[t.textOffset + 1] != '/') continue;
                    String tagName = null;
                    if (!stack.isEmpty()) {
                        tagName = (String)stack.pop();
                    }
                    if (t.offset + t.textCount < dot) continue;
                    return tagName;
                }
            }
            return null;
        }

        @Override
        public String getMacroID() {
            return this.getName();
        }
    }

    public static class CloseCurlyBraceAction
    extends RecordableTextAction {
        private static final long serialVersionUID = 1L;
        private Segment seg = new Segment();

        public CloseCurlyBraceAction() {
            super(RSyntaxTextAreaEditorKit.rstaCloseCurlyBraceAction);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void actionPerformedImpl(ActionEvent e, RTextArea textArea) {
            block15: {
                boolean alignCurlyBraces;
                RSyntaxTextArea rsta = (RSyntaxTextArea)textArea;
                RSyntaxDocument doc = (RSyntaxDocument)rsta.getDocument();
                boolean bl = alignCurlyBraces = rsta.isAutoIndentEnabled() && doc.getCurlyBracesDenoteCodeBlocks();
                if (alignCurlyBraces) {
                    textArea.beginAtomicEdit();
                }
                try {
                    textArea.replaceSelection("}");
                    if (!alignCurlyBraces) break block15;
                    Element root = doc.getDefaultRootElement();
                    int dot = rsta.getCaretPosition() - 1;
                    int line = root.getElementIndex(dot);
                    Element elem = root.getElement(line);
                    int start = elem.getStartOffset();
                    try {
                        doc.getText(start, dot - start, this.seg);
                    }
                    catch (BadLocationException ble) {
                        ble.printStackTrace();
                        if (alignCurlyBraces) {
                            textArea.endAtomicEdit();
                        }
                        return;
                    }
                    for (int i = 0; i < this.seg.count; ++i) {
                        char ch = this.seg.array[this.seg.offset + i];
                        if (Character.isWhitespace(ch)) continue;
                        return;
                    }
                    int match = RSyntaxUtilities.getMatchingBracketPosition(rsta);
                    if (match <= -1) break block15;
                    elem = root.getElement(root.getElementIndex(match));
                    int start2 = elem.getStartOffset();
                    int end = elem.getEndOffset() - 1;
                    String text = null;
                    try {
                        text = doc.getText(start2, end - start2);
                    }
                    catch (BadLocationException ble) {
                        ble.printStackTrace();
                        if (alignCurlyBraces) {
                            textArea.endAtomicEdit();
                        }
                        return;
                    }
                    String ws = RSyntaxUtilities.getLeadingWhitespace(text);
                    rsta.replaceRange(ws, start, dot);
                }
                finally {
                    if (alignCurlyBraces) {
                        textArea.endAtomicEdit();
                    }
                }
            }
        }

        @Override
        public final String getMacroID() {
            return RSyntaxTextAreaEditorKit.rstaCloseCurlyBraceAction;
        }
    }

    protected static class BeginWordAction
    extends RTextAreaEditorKit.BeginWordAction {
        private Segment seg = new Segment();

        protected BeginWordAction(String name, boolean select) {
            super(name, select);
        }

        @Override
        protected int getWordStart(RTextArea textArea, int offs) throws BadLocationException {
            char nextCh;
            if (offs == 0) {
                return offs;
            }
            RSyntaxDocument doc = (RSyntaxDocument)textArea.getDocument();
            int line = textArea.getLineOfOffset(offs);
            int start = textArea.getLineStartOffset(line);
            if (offs == start) {
                return start;
            }
            int end = textArea.getLineEndOffset(line);
            if (line != textArea.getLineCount() - 1) {
                --end;
            }
            doc.getText(start, end - start, this.seg);
            int firstIndex = this.seg.getBeginIndex() + (offs - start) - 1;
            this.seg.setIndex(firstIndex);
            char ch = this.seg.current();
            char c = nextCh = offs == end ? (char)'\u0000' : this.seg.array[this.seg.getIndex() + 1];
            if (Character.isLetterOrDigit(ch)) {
                if (offs != end && !Character.isLetterOrDigit(nextCh)) {
                    return offs;
                }
                while (Character.isLetterOrDigit(ch = this.seg.previous())) {
                }
            } else if (Character.isWhitespace(ch)) {
                if (offs != end && !Character.isWhitespace(nextCh)) {
                    return offs;
                }
                while (Character.isWhitespace(ch = this.seg.previous())) {
                }
            }
            offs -= firstIndex - this.seg.getIndex() + 1;
            if (ch != '\uffff' && nextCh != '\n') {
                ++offs;
            }
            return offs;
        }
    }
}

