/*
 * Decompiled with CFR 0.152.
 */
package jregex;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import jregex.Bitset;
import jregex.PatternSyntaxException;
import jregex.Term;
import jregex.UnicodeConstants;

class CharacterClass
extends Term
implements UnicodeConstants {
    static final Bitset DIGIT = new Bitset();
    static final Bitset WORDCHAR = new Bitset();
    static final Bitset SPACE = new Bitset();
    static final Bitset UDIGIT = new Bitset();
    static final Bitset UWORDCHAR = new Bitset();
    static final Bitset USPACE = new Bitset();
    static final Bitset NONDIGIT = new Bitset();
    static final Bitset NONWORDCHAR = new Bitset();
    static final Bitset NONSPACE = new Bitset();
    static final Bitset UNONDIGIT = new Bitset();
    static final Bitset UNONWORDCHAR = new Bitset();
    static final Bitset UNONSPACE = new Bitset();
    private static boolean namesInitialized = false;
    static final Hashtable namedClasses = new Hashtable();
    static final Vector unicodeBlocks = new Vector();
    static final Vector posixClasses = new Vector();
    static final Vector unicodeCategories = new Vector();
    private static final int ADD = 1;
    private static final int SUBTRACT = 2;
    private static final int INTERSECT = 3;
    private static final String blockData = "0000..007F:InBasicLatin;0080..00FF:InLatin-1Supplement;0100..017F:InLatinExtended-A;0180..024F:InLatinExtended-B;0250..02AF:InIPAExtensions;02B0..02FF:InSpacingModifierLetters;0300..036F:InCombiningDiacriticalMarks;0370..03FF:InGreek;0400..04FF:InCyrillic;0530..058F:InArmenian;0590..05FF:InHebrew;0600..06FF:InArabic;0700..074F:InSyriac;0780..07BF:InThaana;0900..097F:InDevanagari;0980..09FF:InBengali;0A00..0A7F:InGurmukhi;0A80..0AFF:InGujarati;0B00..0B7F:InOriya;0B80..0BFF:InTamil;0C00..0C7F:InTelugu;0C80..0CFF:InKannada;0D00..0D7F:InMalayalam;0D80..0DFF:InSinhala;0E00..0E7F:InThai;0E80..0EFF:InLao;0F00..0FFF:InTibetan;1000..109F:InMyanmar;10A0..10FF:InGeorgian;1100..11FF:InHangulJamo;1200..137F:InEthiopic;13A0..13FF:InCherokee;1400..167F:InUnifiedCanadianAboriginalSyllabics;1680..169F:InOgham;16A0..16FF:InRunic;1780..17FF:InKhmer;1800..18AF:InMongolian;1E00..1EFF:InLatinExtendedAdditional;1F00..1FFF:InGreekExtended;2000..206F:InGeneralPunctuation;2070..209F:InSuperscriptsAndSubscripts;20A0..20CF:InCurrencySymbols;20D0..20FF:InCombiningMarksForSymbols;2100..214F:InLetterLikeSymbols;2150..218F:InNumberForms;2190..21FF:InArrows;2200..22FF:InMathematicalOperators;2300..23FF:InMiscellaneousTechnical;2400..243F:InControlPictures;2440..245F:InOpticalCharacterRecognition;2460..24FF:InEnclosedAlphanumerics;2500..257F:InBoxDrawing;2580..259F:InBlockElements;25A0..25FF:InGeometricShapes;2600..26FF:InMiscellaneousSymbols;2700..27BF:InDingbats;2800..28FF:InBraillePatterns;2E80..2EFF:InCJKRadicalsSupplement;2F00..2FDF:InKangxiRadicals;2FF0..2FFF:InIdeographicDescriptionCharacters;3000..303F:InCJKSymbolsAndPunctuation;3040..309F:InHiragana;30A0..30FF:InKatakana;3100..312F:InBopomofo;3130..318F:InHangulCompatibilityJamo;3190..319F:InKanbun;31A0..31BF:InBopomofoExtended;3200..32FF:InEnclosedCJKLettersAndMonths;3300..33FF:InCJKCompatibility;3400..4DB5:InCJKUnifiedIdeographsExtensionA;4E00..9FFF:InCJKUnifiedIdeographs;A000..A48F:InYiSyllables;A490..A4CF:InYiRadicals;AC00..D7A3:InHangulSyllables;D800..DB7F:InHighSurrogates;DB80..DBFF:InHighPrivateUseSurrogates;DC00..DFFF:InLowSurrogates;E000..F8FF:InPrivateUse;F900..FAFF:InCJKCompatibilityIdeographs;FB00..FB4F:InAlphabeticPresentationForms;FB50..FDFF:InArabicPresentationForms-A;FE20..FE2F:InCombiningHalfMarks;FE30..FE4F:InCJKCompatibilityForms;FE50..FE6F:InSmallFormVariants;FE70..FEFE:InArabicPresentationForms-B;FEFF..FEFF:InSpecials;FF00..FFEF:InHalfWidthAndFullWidthForms;FFF0..FFFD:InSpecials";

    CharacterClass() {
    }

    private static void registerClass(String string, Bitset bitset, Vector vector) {
        namedClasses.put(string, bitset);
        if (!vector.contains(string)) {
            vector.addElement(string);
        }
    }

    private static void initPosixClasses() {
        Bitset bitset = new Bitset();
        bitset.setRange('a', 'z');
        CharacterClass.registerClass("Lower", bitset, posixClasses);
        Bitset bitset2 = new Bitset();
        bitset2.setRange('A', 'Z');
        CharacterClass.registerClass("Upper", bitset2, posixClasses);
        Bitset bitset3 = new Bitset();
        bitset3.setRange('\u0000', '\u007f');
        CharacterClass.registerClass("ASCII", bitset3, posixClasses);
        Bitset bitset4 = new Bitset();
        bitset4.add(bitset);
        bitset4.add(bitset2);
        CharacterClass.registerClass("Alpha", bitset4, posixClasses);
        Bitset bitset5 = new Bitset();
        bitset5.setRange('0', '9');
        CharacterClass.registerClass("Digit", bitset5, posixClasses);
        Bitset bitset6 = new Bitset();
        bitset6.add(bitset4);
        bitset6.add(bitset5);
        CharacterClass.registerClass("Alnum", bitset6, posixClasses);
        Bitset bitset7 = new Bitset();
        bitset7.setChars("!\"#$%&'()*+,-./:;<=>?@[\\]^_`{|}~");
        CharacterClass.registerClass("Punct", bitset7, posixClasses);
        Bitset bitset8 = new Bitset();
        bitset8.add(bitset6);
        bitset8.add(bitset7);
        CharacterClass.registerClass("Graph", bitset8, posixClasses);
        CharacterClass.registerClass("Print", bitset8, posixClasses);
        Bitset bitset9 = new Bitset();
        bitset9.setChars(" \t");
        CharacterClass.registerClass("Blank", bitset9, posixClasses);
        Bitset bitset10 = new Bitset();
        bitset10.setRange('\u0000', '\u001f');
        bitset10.setChar('\u007f');
        CharacterClass.registerClass("Cntrl", bitset10, posixClasses);
        Bitset bitset11 = new Bitset();
        bitset11.setRange('0', '9');
        bitset11.setRange('a', 'f');
        bitset11.setRange('A', 'F');
        CharacterClass.registerClass("XDigit", bitset11, posixClasses);
        Bitset bitset12 = new Bitset();
        bitset12.setChars(" \t\n\r\f\u000b");
        CharacterClass.registerClass("Space", bitset12, posixClasses);
    }

    private static void initNames() {
        CharacterClass.initNamedCategory("C", new int[]{0, 15, 16, 18, 19});
        CharacterClass.initNamedCategory("Cn", 0);
        CharacterClass.initNamedCategory("Cc", 15);
        CharacterClass.initNamedCategory("Cf", 16);
        CharacterClass.initNamedCategory("Co", 18);
        CharacterClass.initNamedCategory("Cs", 19);
        CharacterClass.initNamedCategory("L", new int[]{1, 2, 3, 4, 5});
        CharacterClass.initNamedCategory("Lu", 1);
        CharacterClass.initNamedCategory("Ll", 2);
        CharacterClass.initNamedCategory("Lt", 3);
        CharacterClass.initNamedCategory("Lm", 4);
        CharacterClass.initNamedCategory("Lo", 5);
        CharacterClass.initNamedCategory("M", new int[]{6, 7, 8});
        CharacterClass.initNamedCategory("Mn", 6);
        CharacterClass.initNamedCategory("Me", 7);
        CharacterClass.initNamedCategory("Mc", 8);
        CharacterClass.initNamedCategory("N", new int[]{9, 10, 11});
        CharacterClass.initNamedCategory("Nd", 9);
        CharacterClass.initNamedCategory("Nl", 10);
        CharacterClass.initNamedCategory("No", 11);
        CharacterClass.initNamedCategory("Z", new int[]{12, 13, 14});
        CharacterClass.initNamedCategory("Zs", 12);
        CharacterClass.initNamedCategory("Zl", 13);
        CharacterClass.initNamedCategory("Zp", 14);
        CharacterClass.initNamedCategory("P", new int[]{20, 21, 21, 22, 22, 23, 24});
        CharacterClass.initNamedCategory("Pd", 20);
        CharacterClass.initNamedCategory("Ps", 21);
        CharacterClass.initNamedCategory("Pi", 21);
        CharacterClass.initNamedCategory("Pe", 22);
        CharacterClass.initNamedCategory("Pf", 22);
        CharacterClass.initNamedCategory("Pc", 23);
        CharacterClass.initNamedCategory("Po", 24);
        CharacterClass.initNamedCategory("S", new int[]{25, 26, 27, 28});
        CharacterClass.initNamedCategory("Sm", 25);
        CharacterClass.initNamedCategory("Sc", 26);
        CharacterClass.initNamedCategory("Sk", 27);
        CharacterClass.initNamedCategory("So", 28);
        Bitset bitset = new Bitset();
        bitset.setCategory(0);
        CharacterClass.registerClass("UNASSIGNED", bitset, unicodeCategories);
        bitset = new Bitset();
        bitset.setCategory(0);
        bitset.setPositive(false);
        CharacterClass.registerClass("ASSIGNED", bitset, unicodeCategories);
        StringTokenizer stringTokenizer = new StringTokenizer(blockData, ".,:;");
        while (stringTokenizer.hasMoreTokens()) {
            try {
                int n = Integer.parseInt(stringTokenizer.nextToken(), 16);
                int n2 = Integer.parseInt(stringTokenizer.nextToken(), 16);
                String string = stringTokenizer.nextToken();
                CharacterClass.initNamedBlock(string, n, n2);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        CharacterClass.initNamedBlock("ALL", 0, 65535);
        namesInitialized = true;
    }

    private static void initNamedBlock(String string, int n, int n2) {
        if (n < 0 || n > 65535) {
            throw new IllegalArgumentException("wrong start code (" + n + ") in block " + string);
        }
        if (n2 < 0 || n2 > 65535) {
            throw new IllegalArgumentException("wrong end code (" + n2 + ") in block " + string);
        }
        if (n2 < n) {
            throw new IllegalArgumentException("end code < start code in block " + string);
        }
        Bitset bitset = (Bitset)namedClasses.get(string);
        if (bitset == null) {
            bitset = new Bitset();
            CharacterClass.registerClass(string, bitset, unicodeBlocks);
        }
        bitset.setRange((char)n, (char)n2);
    }

    private static void initNamedCategory(String string, int n) {
        Bitset bitset = new Bitset();
        bitset.setCategory(n);
        CharacterClass.registerClass(string, bitset, unicodeCategories);
    }

    private static void initNamedCategory(String string, int[] nArray) {
        Bitset bitset = new Bitset();
        int n = 0;
        while (n < nArray.length) {
            bitset.setCategory(nArray[n]);
            ++n;
        }
        namedClasses.put(string, bitset);
    }

    private static Bitset getNamedClass(String string) {
        if (!namesInitialized) {
            CharacterClass.initNames();
        }
        return (Bitset)namedClasses.get(string);
    }

    static void makeICase(Term term, char c) {
        Bitset bitset = new Bitset();
        bitset.setChar(Character.toLowerCase(c));
        bitset.setChar(Character.toUpperCase(c));
        bitset.setChar(Character.toTitleCase(c));
        Bitset.unify(bitset, term);
    }

    static void makeDigit(Term term, boolean bl, boolean bl2) {
        Bitset bitset = bl2 ? (bl ? UNONDIGIT : UDIGIT) : (bl ? NONDIGIT : DIGIT);
        Bitset.unify(bitset, term);
    }

    static void makeSpace(Term term, boolean bl, boolean bl2) {
        Bitset bitset = bl2 ? (bl ? UNONSPACE : USPACE) : (bl ? NONSPACE : SPACE);
        Bitset.unify(bitset, term);
    }

    static void makeWordChar(Term term, boolean bl, boolean bl2) {
        Bitset bitset = bl2 ? (bl ? UNONWORDCHAR : UWORDCHAR) : (bl ? NONWORDCHAR : WORDCHAR);
        Bitset.unify(bitset, term);
    }

    static void makeWordBoundary(Term term, boolean bl, boolean bl2) {
        CharacterClass.makeWordChar(term, bl, bl2);
        term.type = bl2 ? 13 : 11;
    }

    static void makeWordStart(Term term, boolean bl) {
        CharacterClass.makeWordChar(term, false, bl);
        term.type = bl ? 14 : 12;
    }

    static void makeWordEnd(Term term, boolean bl) {
        CharacterClass.makeWordChar(term, true, bl);
        term.type = bl ? 14 : 12;
    }

    static final void parseGroup(char[] cArray, int n, int n2, Term term, boolean bl, boolean bl2, boolean bl3, boolean bl4) throws PatternSyntaxException {
        Bitset bitset = new Bitset();
        Bitset bitset2 = new Bitset();
        int n3 = 1;
        block12: while (n < n2) {
            char c = cArray[n++];
            switch (c) {
                case '+': {
                    n3 = 1;
                    break;
                }
                case '-': {
                    n3 = 2;
                    break;
                }
                case '&': {
                    n3 = 3;
                    break;
                }
                case '[': {
                    bitset2.reset();
                    n = CharacterClass.parseClass(cArray, n, n2, bitset2, bl, bl2, bl3, bl4);
                    switch (n3) {
                        case 1: {
                            bitset.add(bitset2);
                            break;
                        }
                        case 2: {
                            bitset.subtract(bitset2);
                            break;
                        }
                        case 3: {
                            bitset.intersect(bitset2);
                        }
                    }
                    continue block12;
                }
                case ')': {
                    throw new PatternSyntaxException("unbalanced class group");
                }
            }
        }
        Bitset.unify(bitset, term);
    }

    static final int parseClass(char[] cArray, int n, int n2, Term term, boolean bl, boolean bl2, boolean bl3, boolean bl4) throws PatternSyntaxException {
        Bitset bitset = new Bitset();
        n = CharacterClass.parseClass(cArray, n, n2, bitset, bl, bl2, bl3, bl4);
        Bitset.unify(bitset, term);
        return n;
    }

    static final int parseName(char[] cArray, int n, int n2, Term term, boolean bl, boolean bl2) throws PatternSyntaxException {
        StringBuffer stringBuffer = new StringBuffer();
        n = CharacterClass.parseName(cArray, n, n2, stringBuffer, bl2);
        Bitset bitset = CharacterClass.getNamedClass(stringBuffer.toString());
        if (bitset == null) {
            throw new PatternSyntaxException("unknow class: {" + stringBuffer + "}");
        }
        Bitset.unify(bitset, term);
        term.inverse = bl;
        return n;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private static final int parseClass(char[] var0, int var1_1, int var2_2, Bitset var3_3, boolean var4_4, boolean var5_5, boolean var6_6, boolean var7_7) throws PatternSyntaxException {
        var9_8 = '\uffffffff';
        var10_9 = true;
        var11_10 = false;
        var12_11 = false;
        var13_12 = null;
        var14_13 = null;
        while (var1_1 < var2_2) {
            var8_14 = var0[var1_1++];
            block0 : switch (var8_14) {
                case ']': {
                    if (!var10_9) {
                        if (var12_11) {
                            var3_3.setChar('-');
                        }
                        if (var9_8 >= '\u0000') {
                            var15_16 = var9_8;
                            if (var4_4) {
                                var3_3.setChar(Character.toLowerCase(var15_16));
                                var3_3.setChar(Character.toUpperCase(var15_16));
                                var3_3.setChar(Character.toTitleCase(var15_16));
                            } else {
                                var3_3.setChar(var15_16);
                            }
                        }
                        return var1_1;
                    }
                    ** GOTO lbl169
                }
                case '-': {
                    if (!var10_9 && !var12_11) {
                        var12_11 = true;
                        break;
                    }
                    ** GOTO lbl169
                }
                case '[': {
                    if (var12_11 && var7_7) {
                        if (var9_8 >= '\u0000') {
                            var3_3.setChar(var9_8);
                        }
                        if (var13_12 == null) {
                            var13_12 = new Bitset();
                        } else {
                            var13_12.reset();
                        }
                        var1_1 = CharacterClass.parseClass(var0, var1_1, var2_2, var13_12, var4_4, var5_5, var6_6, var7_7);
                        var3_3.subtract(var13_12);
                        var12_11 = false;
                        var9_8 = '\uffffffff';
                        break;
                    }
                    ** GOTO lbl169
                }
                case '^': {
                    if (var10_9) {
                        var3_3.setPositive(false);
                        var11_10 = true;
                        break;
                    }
                    ** GOTO lbl169
                }
                case '\t': 
                case '\n': 
                case '\f': 
                case '\r': 
                case ' ': {
                    if (var5_5) {
                        break;
                    }
                    ** GOTO lbl169
                }
                case '\\': {
                    var15_15 = null;
                    var16_17 = false;
                    var8_14 = var0[var1_1++];
                    switch (var8_14) {
                        case 'r': {
                            var8_14 = '\r';
                            ** GOTO lbl169
                        }
                        case 'n': {
                            var8_14 = '\n';
                            ** GOTO lbl169
                        }
                        case 't': {
                            var8_14 = '\t';
                            ** GOTO lbl169
                        }
                        case 'f': {
                            var8_14 = '\f';
                            ** GOTO lbl169
                        }
                        case 'u': {
                            if (var1_1 >= var2_2 - 4) {
                                throw new PatternSyntaxException("incomplete escape sequence \\uXXXX");
                            }
                            var8_14 = (char)((CharacterClass.toHexDigit(var8_14) << 12) + (CharacterClass.toHexDigit(var0[var1_1++]) << 8) + (CharacterClass.toHexDigit(var0[var1_1++]) << 4) + CharacterClass.toHexDigit(var0[var1_1++]));
                            ** GOTO lbl169
                        }
                        case 'v': {
                            var8_14 = (char)((CharacterClass.toHexDigit(var8_14) << 24) + (CharacterClass.toHexDigit(var0[var1_1++]) << 16) + (CharacterClass.toHexDigit(var0[var1_1++]) << 12) + (CharacterClass.toHexDigit(var0[var1_1++]) << 8) + (CharacterClass.toHexDigit(var0[var1_1++]) << 4) + CharacterClass.toHexDigit(var0[var1_1++]));
                            ** GOTO lbl169
                        }
                        case 'b': {
                            var8_14 = '\b';
                            ** GOTO lbl169
                        }
                        case 'x': {
                            var17_18 = 0;
                            var18_19 = var0[var1_1++];
                            if (var18_19 == 123) {
                                while ((var18_19 = var0[var1_1++]) != 125) {
                                    var17_18 = (var17_18 << 4) + CharacterClass.toHexDigit((char)var18_19);
                                }
                                if (var17_18 > 65535) {
                                    throw new PatternSyntaxException("\\x{<out of range>}");
                                }
                            } else {
                                var17_18 = (CharacterClass.toHexDigit((char)var18_19) << 4) + CharacterClass.toHexDigit(var0[var1_1++]);
                            }
                            var8_14 = (char)var17_18;
                            ** GOTO lbl169
                        }
                        case 'o': {
                            var17_18 = 0;
                            while ((var18_19 = var0[var1_1++]) >= 48 && var18_19 <= 55) {
                                var17_18 *= 8;
                                if ((var17_18 += var18_19 - 48) <= 65535) continue;
                            }
                            var8_14 = (char)var17_18;
                            ** GOTO lbl169
                        }
                        case 'm': {
                            var18_19 = 0;
                            while ((var19_20 = var0[var1_1++]) >= '0' && var19_20 <= '9') {
                                var18_19 *= 10;
                                if ((var18_19 += var19_20 - 48) <= 65535) continue;
                            }
                            var8_14 = (char)var18_19;
                            ** GOTO lbl169
                        }
                        case 'c': {
                            var8_14 = (char)(var0[var1_1++] & 31);
                            ** GOTO lbl169
                        }
                        case 'D': {
                            var15_15 = var6_6 != false ? CharacterClass.UNONDIGIT : CharacterClass.NONDIGIT;
                            break;
                        }
                        case 'S': {
                            var15_15 = var6_6 != false ? CharacterClass.UNONSPACE : CharacterClass.NONSPACE;
                            break;
                        }
                        case 'W': {
                            var15_15 = var6_6 != false ? CharacterClass.UNONWORDCHAR : CharacterClass.NONWORDCHAR;
                            break;
                        }
                        case 'd': {
                            if (var12_11) {
                                throw new PatternSyntaxException("illegal range: [..." + var9_8 + "-\\d...]");
                            }
                            var3_3.setDigit(var6_6);
                            break block0;
                        }
                        case 's': {
                            if (var12_11) {
                                throw new PatternSyntaxException("illegal range: [..." + var9_8 + "-\\s...]");
                            }
                            var3_3.setSpace(var6_6);
                            break block0;
                        }
                        case 'w': {
                            if (var12_11) {
                                throw new PatternSyntaxException("illegal range: [..." + var9_8 + "-\\w...]");
                            }
                            var3_3.setWordChar(var6_6);
                            break block0;
                        }
                        case 'P': {
                            var16_17 = true;
                        }
                        case 'p': {
                            if (var12_11) {
                                throw new PatternSyntaxException("illegal range: [..." + var9_8 + "-\\w...]");
                            }
                            if (var14_13 == null) {
                                var14_13 = new StringBuffer();
                            } else {
                                var14_13.setLength(0);
                            }
                            var1_1 = CharacterClass.parseName(var0, var1_1, var2_2, var14_13, var5_5);
                            var19_21 = CharacterClass.getNamedClass(var14_13.toString());
                            if (var19_21 == null) {
                                throw new PatternSyntaxException("unknown named class: {" + var14_13 + "}");
                            }
                            var3_3.add(var19_21, var16_17);
                            break block0;
                        }
                        default: {
                            ** GOTO lbl169
                        }
                    }
                    if (var12_11) {
                        throw new PatternSyntaxException("illegal range: [..." + var9_8 + "-\\" + var8_14 + "...]");
                    }
                    var3_3.add(var15_15);
                    break;
                }
                case '{': {
                    if (var12_11) {
                        throw new PatternSyntaxException("illegal range: [..." + var9_8 + "-\\w...]");
                    }
                    if (var14_13 == null) {
                        var14_13 = new StringBuffer();
                    } else {
                        var14_13.setLength(0);
                    }
                    var1_1 = CharacterClass.parseName(var0, var1_1 - 1, var2_2, var14_13, var5_5);
                    var20_22 = CharacterClass.getNamedClass(var14_13.toString());
                    if (var20_22 == null) {
                        throw new PatternSyntaxException("unknown named class: {" + var14_13 + "}");
                    }
                    var3_3.add(var20_22, false);
                    break;
                }
lbl169:
                // 18 sources

                default: {
                    if (var9_8 < '\u0000') {
                        var9_8 = var8_14;
                        var12_11 = false;
                        break;
                    }
                    if (!var12_11) {
                        var21_23 = var9_8;
                        if (var4_4) {
                            var3_3.setChar(Character.toLowerCase(var21_23));
                            var3_3.setChar(Character.toUpperCase(var21_23));
                            var3_3.setChar(Character.toTitleCase(var21_23));
                        } else {
                            var3_3.setChar(var21_23);
                        }
                        var9_8 = var8_14;
                        break;
                    }
                    if (var9_8 > var8_14) {
                        throw new PatternSyntaxException("illegal range: " + var9_8 + ">" + var8_14);
                    }
                    var21_23 = var9_8;
                    var12_11 = false;
                    var9_8 = '\uffffffff';
                    if (var4_4) {
                        var3_3.setRange(Character.toLowerCase(var21_23), Character.toLowerCase(var8_14));
                        var3_3.setRange(Character.toUpperCase(var21_23), Character.toUpperCase(var8_14));
                        var3_3.setRange(Character.toTitleCase(var21_23), Character.toTitleCase(var8_14));
                        break;
                    }
                    var3_3.setRange(var21_23, var8_14);
                }
            }
            var10_9 = var11_10;
            var11_10 = false;
        }
        throw new PatternSyntaxException("unbalanced brackets in a class def");
    }

    static final int parseName(char[] cArray, int n, int n2, StringBuffer stringBuffer, boolean bl) throws PatternSyntaxException {
        int n3 = -1;
        block5: while (n < n2) {
            char c = cArray[n++];
            switch (c) {
                case '{': {
                    n3 = n;
                    break;
                }
                case '}': {
                    return n;
                }
                case '\t': 
                case '\n': 
                case '\f': 
                case '\r': 
                case ' ': {
                    if (bl) continue block5;
                }
                default: {
                    if (n3 < 0) {
                        throw new PatternSyntaxException("named class doesn't start with '{'");
                    }
                    stringBuffer.append(c);
                }
            }
        }
        throw new PatternSyntaxException("wrong class name: " + new String(cArray, n, n2 - n));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static String stringValue0(boolean[] blArray) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (true) {
            int n2;
            if (!blArray[n]) {
                if (++n >= 255) return stringBuffer.toString();
                continue;
            }
            int n3 = n;
            while (blArray[n]) {
                if (++n > 255) break;
            }
            if ((n2 = n - 1) == n3) {
                stringBuffer.append(CharacterClass.stringValue(n2));
            } else {
                stringBuffer.append(CharacterClass.stringValue(n3));
                stringBuffer.append('-');
                stringBuffer.append(CharacterClass.stringValue(n2));
            }
            if (n > 255) return stringBuffer.toString();
        }
    }

    static String stringValue2(boolean[][] blArray) {
        StringBuffer stringBuffer;
        block4: {
            stringBuffer = new StringBuffer();
            int n = 0;
            do {
                int n2;
                boolean[] blArray2;
                boolean bl = false;
                while ((blArray2 = blArray[n >> 8]) == null || !blArray2[n & 0xFF]) {
                    if (++n <= 65535) continue;
                    break block4;
                }
                int n3 = n;
                while (n <= 65535) {
                    boolean[] blArray3 = blArray[n >> 8];
                    if (blArray3 == null || !blArray3[n & 0xFF]) break;
                    ++n;
                }
                if ((n2 = n - 1) == n3) {
                    stringBuffer.append(CharacterClass.stringValue(n2));
                    continue;
                }
                stringBuffer.append(CharacterClass.stringValue(n3));
                stringBuffer.append('-');
                stringBuffer.append(CharacterClass.stringValue(n2));
            } while (n <= 65535);
        }
        return stringBuffer.toString();
    }

    static String stringValue(int n) {
        StringBuffer stringBuffer = new StringBuffer(5);
        if (n < 32) {
            switch (n) {
                case 13: {
                    stringBuffer.append("\\r");
                    break;
                }
                case 10: {
                    stringBuffer.append("\\n");
                    break;
                }
                case 9: {
                    stringBuffer.append("\\t");
                    break;
                }
                case 12: {
                    stringBuffer.append("\\f");
                    break;
                }
                default: {
                    stringBuffer.append('(');
                    stringBuffer.append(n);
                    stringBuffer.append(')');
                    break;
                }
            }
        } else if (n < 256) {
            stringBuffer.append((char)n);
        } else {
            stringBuffer.append('\\');
            stringBuffer.append('x');
            stringBuffer.append(Integer.toHexString(n));
        }
        return stringBuffer.toString();
    }

    static int toHexDigit(char c) throws PatternSyntaxException {
        int n = 0;
        if (c >= '0' && c <= '9') {
            n = c - 48;
        } else if (c >= 'a' && c <= 'f') {
            n = 10 + c - 97;
        } else if (c >= 'A' && c <= 'F') {
            n = 10 + c - 65;
        } else {
            throw new PatternSyntaxException("hexadecimal digit expected: " + c);
        }
        return n;
    }

    public static void main(String[] stringArray) {
        if (!namesInitialized) {
            CharacterClass.initNames();
        }
        if (stringArray.length == 0) {
            System.out.println("Class usage: \\p{Class},\\P{Class}");
            CharacterClass.printRealm(posixClasses, "Posix classes");
            CharacterClass.printRealm(unicodeCategories, "Unicode categories");
            CharacterClass.printRealm(unicodeBlocks, "Unicode blocks");
        } else {
            int n = 0;
            while (n < stringArray.length) {
                System.out.print(stringArray[n]);
                System.out.print(": ");
                System.out.println(namedClasses.containsKey(stringArray[n]) ? "supported" : "not supported");
                ++n;
            }
        }
    }

    private static void printRealm(Vector vector, String string) {
        System.out.println(string + ":");
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            System.out.println("  " + enumeration.nextElement());
        }
    }

    static {
        DIGIT.setDigit(false);
        WORDCHAR.setWordChar(false);
        SPACE.setSpace(false);
        UDIGIT.setDigit(true);
        UWORDCHAR.setWordChar(true);
        USPACE.setSpace(true);
        NONDIGIT.setDigit(false);
        NONDIGIT.setPositive(false);
        NONWORDCHAR.setWordChar(false);
        NONWORDCHAR.setPositive(false);
        NONSPACE.setSpace(false);
        NONSPACE.setPositive(false);
        UNONDIGIT.setDigit(true);
        UNONDIGIT.setPositive(false);
        UNONWORDCHAR.setWordChar(true);
        UNONWORDCHAR.setPositive(false);
        UNONSPACE.setSpace(true);
        UNONSPACE.setPositive(false);
        CharacterClass.initPosixClasses();
    }
}

