/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.spgeed;

import java.io.InputStream;
import java.lang.reflect.Parameter;
import java.lang.reflect.Type;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import javassist.util.proxy.MethodHandler;
import javassist.util.proxy.Proxy;
import javassist.util.proxy.ProxyFactory;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.reflect.ConstructorUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.spgeed.Query;
import org.nuiton.spgeed.SpgeedMapper;
import org.nuiton.spgeed.SqlSession;
import org.nuiton.spgeed.annotations.Script;
import org.nuiton.spgeed.annotations.Select;
import org.nuiton.spgeed.annotations.Update;

public class ClassCreator {
    private static Log log = LogFactory.getLog(ClassCreator.class);
    protected ProxyFactory proxyFactory = new ProxyFactory();

    public <E> E generate(Class<E> c, SqlSession session, Object ... constructorArgs) throws Exception {
        if (c.isInterface()) {
            this.proxyFactory.setInterfaces(new Class[]{c});
        } else {
            this.proxyFactory.setSuperclass(c);
        }
        this.proxyFactory.setFilter(m -> {
            boolean result = m.isAnnotationPresent(Update.class) || m.isAnnotationPresent(Select.class) || m.isAnnotationPresent(Script.class) || m.getName().equals("getSession") && m.getParameterCount() == 0;
            return result;
        });
        Class resultClass = this.proxyFactory.createClass();
        MethodHandler mi = (self, method, proceed, args) -> {
            Class<? extends SpgeedMapper> mapper;
            String sql;
            if (method.getName().equals("getSession")) {
                return session;
            }
            HashMap<String, Object> parameterValues = new HashMap<String, Object>();
            Parameter[] parameters = method.getParameters();
            int index = 0;
            for (Parameter parameter : parameters) {
                String name = parameter.getName();
                parameterValues.put(name, args[index++]);
            }
            Class<?> returnClass = method.getReturnType();
            Type returnType = method.getGenericReturnType();
            if (method.isAnnotationPresent(Update.class)) {
                Update annotation = method.getDeclaredAnnotation(Update.class);
                sql = annotation.sql();
                mapper = annotation.mapper();
                String[] roles = annotation.roles();
                Query query = new Query(session, sql, mapper, type -> method.getDeclaredAnnotation(type), roles, parameterValues, returnClass, returnType);
                return query.executeUpdate();
            }
            if (method.isAnnotationPresent(Select.class)) {
                Select annotation = method.getDeclaredAnnotation(Select.class);
                sql = annotation.sql();
                mapper = annotation.mapper();
                String[] roles = annotation.roles();
                Query query = new Query(session, sql, mapper, type -> method.getDeclaredAnnotation(type), roles, parameterValues, returnClass, returnType);
                return query.executeQuery();
            }
            if (method.isAnnotationPresent(Script.class)) {
                Script annotation = method.getDeclaredAnnotation(Script.class);
                String file = annotation.file();
                ClassLoader classLoader = SqlSession.class.getClassLoader();
                InputStream resource = classLoader.getResourceAsStream(file);
                String content = IOUtils.toString((InputStream)resource, (Charset)StandardCharsets.UTF_8);
                Query query = new Query(session, content, parameterValues, Boolean.class);
                return query.execute();
            }
            return null;
        };
        Object result = ConstructorUtils.invokeConstructor((Class)resultClass, (Object[])constructorArgs);
        ((Proxy)result).setHandler(mi);
        return (E)result;
    }
}

