package org.nuiton.spgeed;

/*-
 * #%L
 * spgeed
 * %%
 * Copyright (C) 2017 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */


import java.io.InputStream;

import org.apache.commons.lang3.reflect.ConstructorUtils;
import org.nuiton.spgeed.annotations.Script;
import org.nuiton.spgeed.annotations.Select;
import org.nuiton.spgeed.annotations.Update;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import javassist.util.proxy.MethodHandler;
import javassist.util.proxy.Proxy;
import javassist.util.proxy.ProxyFactory;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/**
 * Use to generate proxy for handling the SQL statement on each method from the 
 * class contains annotation (select, update or script).
 * 
 * @author poussin
 * @version $Revision$
 *
 * Last update: $Date$
 * by : $Author$
 */
public class ClassCreator {

    /** to use log facility, just put in your code: log.info(\"...\"); */
    static private Log log = LogFactory.getLog(ClassCreator.class);

    protected ProxyFactory proxyFactory = new ProxyFactory();

    public<E> E generate(Class<E> c, SqlSession session, Object... constructorArgs) throws Exception {
        if (c.isInterface()) {
            proxyFactory.setInterfaces(new Class[]{c});
        } else {
            proxyFactory.setSuperclass(c);
        }

        // only filtered (return true) method are send to handler
        proxyFactory.setFilter((Method m) -> {
            // ignore finalize()
            boolean result =
                    m.isAnnotationPresent(Update.class) ||
                    m.isAnnotationPresent(Select.class) ||
                    m.isAnnotationPresent(Script.class) ||
                    (m.getName().equals("getSession") && m.getParameterCount() == 0);
            
            return result;
        });

        Class<E> resultClass = (Class<E>) proxyFactory.createClass();
        MethodHandler mi = (Object self, Method method, Method proceed, Object[] args) -> {
            if (method.getName().equals("getSession")) {
                return session;
            } else {
                // Map the pararemeters by name
                Map<String, Object> parameterValues = new HashMap<>();
                Parameter[] parameters = method.getParameters();
                
                int index = 0;
                for (Parameter parameter : parameters) {
                    String name = parameter.getName();
                    parameterValues.put(name, args[index ++]);
                }

                // Return
                Class<?> returnClass = method.getReturnType();
                Type returnType = method.getGenericReturnType();

                if (method.isAnnotationPresent(Update.class)) {
                    Update annotation = method.getDeclaredAnnotation(Update.class);
                    String sql = annotation.sql();
                    Class mapper = annotation.mapper();
                    String[] roles = annotation.roles();

                    Query query = new Query(session, sql, mapper, type -> method.getDeclaredAnnotation(type) , roles, parameterValues, returnClass, returnType);
                    return query.executeUpdate();
                }

                if (method.isAnnotationPresent(Select.class)) {
                    Select annotation = method.getDeclaredAnnotation(Select.class);
                    String sql = annotation.sql();
                    Class mapper = annotation.mapper();
                    String[] roles = annotation.roles();

                    Query query = new Query(session, sql, mapper, type -> method.getDeclaredAnnotation(type), roles, parameterValues, returnClass, returnType);
                    return query.executeQuery();
                }

                if (method.isAnnotationPresent(Script.class)) {
                    Script annotation = method.getDeclaredAnnotation(Script.class);
                    String file = annotation.file();

                    ClassLoader classLoader = SqlSession.class.getClassLoader();
                    InputStream resource = classLoader.getResourceAsStream(file);
                    String content = IOUtils.toString(resource, StandardCharsets.UTF_8);

                    Query query = new Query(session, content, parameterValues, Boolean.class);
                    return query.execute();
                }

                return null;
            }
        };
        
        E result = ConstructorUtils.invokeConstructor(resultClass, constructorArgs);
//        E result = resultClass.newInstance();
        ((Proxy)result).setHandler(mi);
        return result;
    }
}
