package org.nuiton.spgeed;

/*-
 * #%L
 * spgeed
 * %%
 * Copyright (C) 2017 - 2019 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */

import java.util.ArrayList;

/**
 * Use to paging result.
 *
 * <li>fetch: paging size</li>
 * <li>first: first element position</li>
 * <li>next: use for next call, this is first in next call</li>
 * <li>total: total number of result without paging</li>
 * <li>size: number of result retrieve in this paging (less or equals to fetch)</li>
 *
 * @param <T>
 */
public class ChunkArrayList<T> extends ArrayList<T> implements Chunk<T> {
    protected Class<T> elementType;
    protected long fetch;
    protected long first;
    protected long next;
    protected long total;

    public ChunkArrayList() {}

    public ChunkArrayList(long fetch, long first, long next, long total) {
        this.fetch = fetch;
        this.first = first;
        this.next = next;
        this.total = total;
    }

    @Override
    public Class<T> getElementType() {
        return elementType;
    }

    @Override
    public Chunk<T> setElementType(Class<T> elementType) {
        this.elementType = elementType;
        return this;
    }

    @Override
    public long getFetch() {
        return fetch;
    }

    @Override
    public Chunk<T> setFetch(long fetch) {
        this.fetch = fetch;
        return this;
    }

    @Override
    public long getFirst() {
        return first;
    }

    @Override
    public Chunk<T> setFirst(long first) {
        this.first = first;
        return this;
    }

    @Override
    public long getNext() {
        return next;
    }

    @Override
    public Chunk<T> setNext(long next) {
        this.next = next;
        return this;
    }

    @Override
    public long getTotal() {
        return total;
    }

    @Override
    public Chunk<T> setTotal(long total) {
        this.total = total;
        return this;
    }

}
