/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.scmwebeditor.actions;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.scmwebeditor.ScmWebEditorBaseAction;
import org.nuiton.scmwebeditor.SvnConnection;
import org.tmatesoft.svn.core.SVNAuthenticationException;
import org.tmatesoft.svn.core.SVNException;

public class ResetAction
extends ScmWebEditorBaseAction {
    private static final long serialVersionUID = -1154924826535371319L;
    private static final Log log = LogFactory.getLog(ResetAction.class);
    protected String lastRevision;
    protected String numRevision;
    protected String address;
    protected String username;
    protected String pw;
    protected String error;

    public String getLastRevision() {
        return this.lastRevision;
    }

    public String getNumRevision() {
        return this.numRevision;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public void setPw(String pw) {
        this.pw = pw;
    }

    public String getError() {
        return this.error;
    }

    public String execute() {
        SvnConnection svnConn = new SvnConnection(this.address);
        String repositoryUUID = svnConn.getUUID();
        if (repositoryUUID == null) {
            repositoryUUID = this.address;
        }
        if (this.username == null && this.pw == null) {
            if (this.getScmSession().getUsername(repositoryUUID) != null && this.getScmSession().getPassword(repositoryUUID) != null) {
                this.username = this.getScmSession().getUsername(repositoryUUID);
                this.pw = this.getScmSession().getPassword(repositoryUUID);
            } else {
                this.username = null;
                this.pw = null;
            }
        }
        try {
            this.lastRevision = this.getHeadRevision(this.address, this.username, this.pw);
            this.numRevision = this.getHeadNumberRevision(this.address, this.username, this.pw);
        }
        catch (SVNAuthenticationException authexep) {
            if (log.isErrorEnabled()) {
                log.error((Object)"AUTH FAIL");
            }
            this.error = "authError";
            return "authError";
        }
        catch (SVNException e1) {
            if (log.isErrorEnabled()) {
                log.error((Object)"Can't reach the svn repository");
            }
            this.error = "errorPath";
            this.numRevision = null;
            return "errorPath";
        }
        catch (StringIndexOutOfBoundsException e) {
            if (log.isErrorEnabled()) {
                log.error((Object)"Can't reach the svn repository");
            }
            this.error = "errorPath";
            return "errorPath";
        }
        catch (IllegalArgumentException e) {
            if (log.isErrorEnabled()) {
                log.error((Object)"Problem with file path", (Throwable)e);
            }
            this.error = "errorPath";
            return "errorPath";
        }
        return "success";
    }
}

