/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.scmwebeditor.actions;

import com.jgeppert.struts2.jquery.tree.result.TreeNode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.scmwebeditor.ScmWebEditorBaseAction;
import org.tmatesoft.svn.core.SVNAuthenticationException;
import org.tmatesoft.svn.core.SVNDirEntry;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNNodeKind;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.auth.ISVNAuthenticationManager;
import org.tmatesoft.svn.core.internal.io.dav.DAVRepositoryFactory;
import org.tmatesoft.svn.core.io.SVNRepository;
import org.tmatesoft.svn.core.io.SVNRepositoryFactory;
import org.tmatesoft.svn.core.wc.SVNWCUtil;

public class SearchAction
extends ScmWebEditorBaseAction {
    private static final long serialVersionUID = 4432027215087932750L;
    private static final Log log = LogFactory.getLog(SearchAction.class);
    protected String address;
    protected List<String> files;
    protected Map<String, String> directories;
    protected String username;
    protected String pw;
    protected String error;
    protected int numberOfFile;
    protected String info;
    protected String list;
    protected List<TreeNode> nodes = new ArrayList();
    protected String id = "";

    public String getError() {
        return this.error;
    }

    public String getList() {
        return this.list;
    }

    public void setList(String list) {
        this.list = list;
    }

    public List<String> getFiles() {
        return this.files;
    }

    public Map<String, String> getDirectories() {
        return this.directories;
    }

    public String getInfo() {
        return this.info;
    }

    public String getAddress() {
        return this.address;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPw() {
        return this.pw;
    }

    public void setPw(String pw) {
        this.pw = pw;
    }

    public int getNumberOfFile() {
        return this.numberOfFile;
    }

    public String search() {
        String url;
        if (log.isDebugEnabled()) {
            log.debug((Object)"Enter in search action");
        }
        DAVRepositoryFactory.setup();
        String name = "anonymous";
        String password = "anonymous";
        if (this.username != null && this.pw != null) {
            name = this.username;
            password = this.pw;
        }
        if (this.address.endsWith("/")) {
            this.address = this.address.substring(0, this.address.length() - 1);
        }
        if (this.id.equals("")) {
            try {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Address svn : " + this.address));
                }
                SVNRepository repository = SVNRepositoryFactory.create((SVNURL)SVNURL.parseURIDecoded((String)this.address));
                ISVNAuthenticationManager authManager = SVNWCUtil.createDefaultAuthenticationManager((String)name, (String)password);
                repository.setAuthenticationManager(authManager);
                repository.testConnection();
            }
            catch (SVNAuthenticationException e) {
                if (log.isErrorEnabled()) {
                    log.error((Object)"Can't access to the repository : Auth Problem", (Throwable)e);
                }
                return "authError";
            }
            catch (SVNException e) {
                if (log.isErrorEnabled()) {
                    log.error((Object)"Can't access to the repository", (Throwable)e);
                }
                this.error = "Can't access to the repository";
            }
            return "root";
        }
        if (this.id.equals("0")) {
            url = this.address;
        } else {
            url = this.id;
            this.address = this.id;
        }
        try {
            SVNNodeKind nodeKind;
            SVNRepository repository = SVNRepositoryFactory.create((SVNURL)SVNURL.parseURIDecoded((String)url));
            ISVNAuthenticationManager authManager = SVNWCUtil.createDefaultAuthenticationManager((String)name, (String)password);
            repository.setAuthenticationManager(authManager);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Repository Root: " + repository.getRepositoryRoot(true)));
                log.debug((Object)("Repository UUID: " + repository.getRepositoryUUID(true)));
            }
            if ((nodeKind = repository.checkPath("", -1L)) == SVNNodeKind.NONE) {
                if (log.isWarnEnabled()) {
                    log.warn((Object)("There is no entry at '" + url + "'."));
                }
                this.error = "There is no entry at '" + url + "'.";
                return "success";
            }
            if (nodeKind == SVNNodeKind.FILE) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("The entry at '" + url + "' is a file."));
                }
                TreeNode node = new TreeNode();
                node.setId(url);
                node.setTitle(url.substring(url.lastIndexOf("/") + 1));
                node.setState("leaf");
                node.setIcon("ui-icon-document");
                this.nodes.add(node);
                return "success";
            }
            this.numberOfFile = 0;
            this.listEntries(repository, "");
            if (log.isDebugEnabled()) {
                log.debug((Object)("Number of file : " + this.files.size()));
            }
            for (String file : this.files) {
                TreeNode node = new TreeNode();
                node.setId(file);
                node.setTitle(file.substring(file.lastIndexOf("/") + 1));
                node.setState("leaf");
                node.setIcon("ui-icon-document");
                this.nodes.add(node);
            }
            for (Map.Entry ent : this.directories.entrySet()) {
                String value = (String)ent.getValue();
                TreeNode node = new TreeNode();
                node.setId(value);
                node.setTitle(value.substring(value.lastIndexOf("/")));
                this.nodes.add(node);
            }
        }
        catch (SVNAuthenticationException authexep) {
            if (log.isErrorEnabled()) {
                log.error((Object)"Can't access to the repository : Auth Problem");
            }
            return "authError";
        }
        catch (SVNException svne) {
            if (log.isErrorEnabled()) {
                log.error((Object)"Can't access to the repository");
            }
            this.error = "Can't access to the repository";
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"Search success");
        }
        return "success";
    }

    public void listEntries(SVNRepository repository, String path) {
        Collection entries;
        block5: {
            this.files = new LinkedList();
            this.directories = new HashMap();
            entries = null;
            try {
                entries = repository.getDir(path, -1L, null, (Collection)null);
            }
            catch (SVNException e) {
                if (!log.isErrorEnabled()) break block5;
                log.error((Object)"Can not reach the repository", (Throwable)e);
            }
        }
        for (SVNDirEntry entry : entries) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("/" + (path.equals("") ? "" : path + "/") + entry.getName() + "\n"));
            }
            String fichier = this.address + "/" + (path.equals("") ? "" : path + "/") + entry.getName();
            if (entry.getKind() == SVNNodeKind.DIR) {
                this.directories.put(this.getAddressUnique(fichier), fichier);
                continue;
            }
            this.files.add(fichier);
        }
    }

    public String getJSON() {
        return this.search();
    }

    public List<TreeNode> getNodes() {
        return this.nodes;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getAddressUnique(String leFichier) {
        String result = leFichier.replaceAll("/|:", "");
        if (log.isDebugEnabled()) {
            log.debug((Object)("Result of getAddressUnique : " + result));
        }
        return result;
    }

    public static String replaceLast(String string, String toReplace, String replacement) {
        int pos = string.lastIndexOf(toReplace);
        if (pos > -1) {
            return string.substring(0, pos) + replacement + string.substring(pos + toReplace.length(), string.length());
        }
        return string;
    }
}

