/*
 * #%L
 * ScmWebEditor
 * %%
 * Copyright (C) 2009 - 2014 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as 
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */
package org.nuiton.scmwebeditor.actions;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts2.interceptor.ServletRequestAware;
import org.apache.struts2.interceptor.ServletResponseAware;
import org.nuiton.scmwebeditor.ScmWebEditorBaseAction;
import org.nuiton.scmwebeditor.SvnConnection;

import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class LogoutAction extends ScmWebEditorBaseAction implements ServletRequestAware, ServletResponseAware {

    private static final long serialVersionUID = 6937086747942656369L;

    private static final Log log = LogFactory.getLog(LogoutAction.class);

    protected String address;

    protected String projectUrl;

    protected transient HttpServletRequest request;

    protected transient HttpServletResponse response;


    public void setAddress(String address) {
        this.address = address;
    }

    public String getAddress() {
        return address;
    }

    public String getProjectUrl() {
        return projectUrl;
    }

    public void setProjectUrl(String projectUrl) {
        this.projectUrl = projectUrl;
    }

    public String execute() {

        SvnConnection svnConn = new SvnConnection(address);

        //Si le repo n'est pas protege en ecriture on recupere sont UUID
        String repositoryUUID = svnConn.getUUID();
        if (repositoryUUID == null) {
            repositoryUUID = address;
        }

        //suppression des cookies pour ce dépot
        for (Cookie c : request.getCookies()) {
            if (c.getName().equals(repositoryUUID)) {
                c.setMaxAge(0);//On supprime le cookie
                response.addCookie(c);
                if (log.isDebugEnabled()) {
                    log.debug("Cookie supprimé");
                }
            }
        }

        //Suppression des identifiants stockés en session
        getScmSession().delScmUser(repositoryUUID);

        return SUCCESS;
    }


    @Override
    public void setServletRequest(HttpServletRequest request) {
        this.request = request;
    }

    @Override
    public void setServletResponse(HttpServletResponse response) {
        this.response = response;
    }

}
