/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.scmwebeditor.urlResolver;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import org.apache.commons.lang.StringUtils;
import org.nuiton.scmwebeditor.urlResolver.ScmUrlResolver;

public class ScmUrlResolverEngine {
    public static final String PARAMETER_SCM_LAYOUT = "scmlayout";
    static final ThreadLocal<ScmUrlResolverEngine> engine = new /* Unavailable Anonymous Inner Class!! */;
    protected List<ScmUrlResolver> injectors;

    public static URL resolver(Map<String, String> parameters) throws IOException, IllegalArgumentException {
        String layoutName = parameters.get(PARAMETER_SCM_LAYOUT);
        if (StringUtils.isEmpty((String)layoutName)) {
            layoutName = "default";
        }
        ScmUrlResolver scmURLResolver = ((ScmUrlResolverEngine)engine.get()).getScmURLResolver(layoutName);
        URL resolv = scmURLResolver.resolv(parameters);
        return resolv;
    }

    protected ScmUrlResolver getScmURLResolver(String layoutName) {
        ScmUrlResolver result = null;
        List injectors = this.getInjectors();
        for (ScmUrlResolver injector : injectors) {
            if (!layoutName.equals(injector.getLayoutName())) continue;
            result = injector;
            break;
        }
        return result;
    }

    protected List<ScmUrlResolver> getInjectors() {
        if (this.injectors == null) {
            this.injectors = new ArrayList();
            for (ScmUrlResolver injector : ServiceLoader.load(ScmUrlResolver.class)) {
                this.injectors.add(injector);
            }
        }
        return this.injectors;
    }
}

