/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.scmwebeditor.actions;

import java.io.IOException;
import java.util.LinkedList;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.shiro.codec.Base64;
import org.apache.shiro.crypto.BlowfishCipherService;
import org.apache.struts2.interceptor.ServletRequestAware;
import org.apache.struts2.interceptor.ServletResponseAware;
import org.nuiton.scmwebeditor.ScmWebEditorBaseAction;
import org.nuiton.scmwebeditor.ScmWebEditorConfig;
import org.nuiton.scmwebeditor.SvnConnection;
import org.tmatesoft.svn.core.SVNAuthenticationException;
import org.tmatesoft.svn.core.SVNException;

public class ScmWebEditorMainAction
extends ScmWebEditorBaseAction
implements ServletRequestAware,
ServletResponseAware {
    private static final long serialVersionUID = 8361035067228171624L;
    private static final Log log = LogFactory.getLog(ScmWebEditorMainAction.class);
    public static final String NO_PARAMETER = "noParameter";
    public static final String EDIT_PAGE = "editPage";
    protected String address;
    protected String projectUrl;
    protected String format;
    protected String origText;
    protected String mimeType;
    protected boolean saveCookie = true;
    protected boolean badLogin;
    protected String numRevision;
    protected String addressSvn;
    protected String username;
    protected String pw;
    protected transient HttpServletRequest request;
    protected transient HttpServletResponse response;
    protected String repositoryId;
    protected boolean fromLoginPage;

    public String getAddressSvn() {
        return this.addressSvn;
    }

    public void setAddressSvn(String addressSvn) {
        this.addressSvn = addressSvn;
    }

    public String getMimeType() {
        return this.mimeType;
    }

    public String getRepositoryId() {
        return this.repositoryId;
    }

    public void setRepositoryId(String repositoryId) {
        this.repositoryId = repositoryId;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPw() {
        return this.pw;
    }

    public void setPw(String pw) {
        this.pw = pw;
    }

    public String getAddress() {
        return this.address;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public String getFormat() {
        return this.format;
    }

    public void setFormat(String format) {
        this.format = format;
    }

    public String getOrigText() {
        return this.origText;
    }

    public String getProjectUrl() {
        return this.projectUrl;
    }

    public String getNumRevision() {
        return this.numRevision;
    }

    public void setProjectUrl(String projectUrl) {
        this.projectUrl = projectUrl;
    }

    public void setFromLoginPage(boolean fromLoginPage) {
        this.fromLoginPage = fromLoginPage;
    }

    public boolean isBadLogin() {
        return this.badLogin;
    }

    private boolean testParameters() {
        return this.address == null || this.address.length() == 0;
    }

    public String execute() {
        String originalText;
        block31: {
            String usernameDecode;
            String[] resCookie;
            SvnConnection svnConn;
            if (log.isDebugEnabled()) {
                log.debug((Object)"Connection to SCMWebEditor\n");
            }
            if (!this.fromLoginPage && this.projectUrl == null) {
                this.projectUrl = this.request.getHeader("referer");
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("ProjectUrl= " + this.projectUrl));
            }
            if (this.testParameters()) {
                return NO_PARAMETER;
            }
            try {
                svnConn = new SvnConnection(this.address);
            }
            catch (StringIndexOutOfBoundsException e) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Parameter is not valid ", (Throwable)e);
                }
                return "errorPath";
            }
            this.format = svnConn.getFileName().substring(svnConn.getFileName().lastIndexOf(".") + 1);
            String repositoryUUID = svnConn.getUUID();
            if (repositoryUUID == null) {
                repositoryUUID = this.address;
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("Login : " + this.username));
            }
            String usernamepwCookie = null;
            BlowfishCipherService bf = new BlowfishCipherService();
            byte[] privateKey = Base64.decode((String)ScmWebEditorConfig.getKey());
            for (Cookie c : this.request.getCookies()) {
                if (!c.getName().equals(repositoryUUID)) continue;
                usernamepwCookie = c.getValue();
            }
            if (usernamepwCookie != null && (resCookie = (usernameDecode = new String(bf.decrypt(Base64.decode(usernamepwCookie), privateKey).getBytes())).split(",")).length == 2) {
                this.username = resCookie[0];
                this.pw = resCookie[1];
            }
            if (this.saveCookie && this.username != null && this.pw != null) {
                Cookie authCookie = new Cookie(repositoryUUID, bf.encrypt((this.username + "," + this.pw).getBytes(), privateKey).toBase64());
                authCookie.setMaxAge(31536000);
                this.response.addCookie(authCookie);
            }
            if (this.username == null && this.pw == null) {
                if (this.getScmSession().getUsername(repositoryUUID) != null && this.getScmSession().getPassword(repositoryUUID) != null) {
                    this.username = this.getScmSession().getUsername(repositoryUUID);
                    this.pw = this.getScmSession().getPassword(repositoryUUID);
                } else {
                    this.username = null;
                    this.pw = null;
                }
            } else {
                this.getScmSession().addScmUser(repositoryUUID, this.username, this.pw);
            }
            svnConn.updateAuthentication(this.username, this.pw);
            try {
                originalText = this.getHeadRevision(this.address, this.username, this.pw);
                this.numRevision = this.getHeadNumberRevision(this.address, this.username, this.pw);
            }
            catch (SVNAuthenticationException authexep) {
                this.request.setAttribute("address", (Object)this.address);
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Auth Fail ", (Throwable)authexep);
                }
                for (Cookie c : this.request.getCookies()) {
                    if (!c.getName().equals(repositoryUUID)) continue;
                    c.setMaxAge(0);
                    this.response.addCookie(c);
                    if (!log.isDebugEnabled()) continue;
                    log.debug((Object)"Cookie supprim\u00e9");
                }
                this.getScmSession().delScmUser(repositoryUUID);
                return "login";
            }
            catch (SVNException e) {
                this.request.setAttribute("projectUrl", (Object)this.projectUrl);
                if (log.isErrorEnabled()) {
                    log.error((Object)"SVN error ", (Throwable)e);
                }
                return "errorPath";
            }
            catch (IllegalArgumentException e) {
                this.request.setAttribute("projectUrl", (Object)this.projectUrl);
                if (log.isDebugEnabled()) {
                    log.debug((Object)"SVN error debug", (Throwable)e);
                }
                return "errorPath";
            }
            this.mimeType = null;
            try {
                this.mimeType = this.getMimeType(originalText, svnConn.getFileName());
            }
            catch (IOException e) {
                if (!log.isErrorEnabled()) break block31;
                log.error((Object)"Can't get MimeType, problem when reading file", (Throwable)e);
            }
        }
        LinkedList<String> editableFiles = new LinkedList<String>();
        editableFiles.add("text");
        editableFiles.add("xml");
        editableFiles.add("x-java");
        editableFiles.addAll(ScmWebEditorConfig.getEditableFiles());
        boolean editable = false;
        if (this.mimeType != null) {
            for (String fileType : editableFiles) {
                if (!this.mimeType.matches(".*" + fileType + ".*")) continue;
                editable = true;
            }
        }
        if (this.mimeType == null || !editable) {
            if (log.isErrorEnabled()) {
                log.error((Object)("Can't edit this file, mimetype : " + this.mimeType));
            }
            return "errorPath";
        }
        this.origText = originalText;
        if (log.isInfoEnabled()) {
            log.info((Object)("IP client : " + this.request.getRemoteAddr() + " , get file : " + this.address + ". File's mimetype : " + this.mimeType));
        }
        return EDIT_PAGE;
    }

    public void setServletRequest(HttpServletRequest request) {
        this.request = request;
    }

    public void setServletResponse(HttpServletResponse response) {
        this.response = response;
    }
}

