/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.scmwebeditor.actions;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.FileUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.shiro.codec.Base64;
import org.apache.shiro.crypto.BlowfishCipherService;
import org.apache.struts2.interceptor.ServletRequestAware;
import org.apache.struts2.interceptor.ServletResponseAware;
import org.nuiton.jrst.JRST;
import org.nuiton.scmwebeditor.ScmWebEditorBaseAction;
import org.nuiton.scmwebeditor.ScmWebEditorConfig;
import org.nuiton.scmwebeditor.SvnConnection;
import org.nuiton.util.FileUtil;
import org.tmatesoft.svn.core.SVNAuthenticationException;
import org.tmatesoft.svn.core.SVNDepth;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.wc.ISVNOptions;
import org.tmatesoft.svn.core.wc.ISVNRepositoryPool;
import org.tmatesoft.svn.core.wc.SVNCommitClient;

public class ScmWebEditorCommitAction
extends ScmWebEditorBaseAction
implements ServletRequestAware,
ServletResponseAware {
    private static final long serialVersionUID = 6374273568146287730L;
    private static final Log log = LogFactory.getLog(ScmWebEditorCommitAction.class);
    public static final String FILE_MODIFY = "fileModify";
    protected String newText;
    protected String commitMessage;
    protected String origText;
    protected String username;
    protected String pw;
    protected String address;
    protected String lastText;
    protected String format;
    protected String projectUrl;
    protected String diff;
    protected String headCommiter;
    protected String mimeType;
    protected boolean force;
    protected boolean saveCookie;
    protected boolean badLogin;
    protected String numRevision;
    protected transient HttpServletRequest request;
    protected transient HttpServletResponse response;

    public String getCommitMessage() {
        return this.commitMessage;
    }

    public void setCommitMessage(String commitMessage) {
        this.commitMessage = commitMessage;
    }

    public String getNewText() {
        return this.newText;
    }

    public String getFormat() {
        return this.format;
    }

    public void setFormat(String format) {
        this.format = format;
    }

    public void setNewText(String newText) {
        this.newText = newText;
    }

    public String getOrigText() {
        return this.origText;
    }

    public void setOrigText(String origText) {
        this.origText = origText;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPw() {
        return this.pw;
    }

    public void setPw(String pw) {
        this.pw = pw;
    }

    public String getAddress() {
        return this.address;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public String getLastText() {
        return this.lastText;
    }

    public void setLastText(String lastText) {
        this.lastText = lastText;
    }

    public String getProjectUrl() {
        return this.projectUrl;
    }

    public void setProjectUrl(String projectUrl) {
        this.projectUrl = projectUrl;
    }

    public void setForce(boolean force) {
        this.force = force;
    }

    public String getNumRevision() {
        return this.numRevision;
    }

    public void setNumRevision(String numRevision) {
        this.numRevision = numRevision;
    }

    public String getDiff() {
        return this.diff;
    }

    public String getHeadCommiter() {
        return this.headCommiter;
    }

    public boolean isSaveCookie() {
        return this.saveCookie;
    }

    public void setSaveCookie(boolean saveCookie) {
        this.saveCookie = saveCookie;
    }

    public String getMimeType() {
        return this.mimeType;
    }

    public void setMimeType(String mimeType) {
        this.mimeType = mimeType;
    }

    public boolean isBadLogin() {
        return this.badLogin;
    }

    protected boolean isRstValid(String newText) {
        try {
            JRST.generate((String)"html", (String)newText);
            if (log.isDebugEnabled()) {
                log.debug((Object)"RST generate success");
            }
            return true;
        }
        catch (Exception e) {
            if (log.isErrorEnabled()) {
                log.error((Object)"RST generate fail", (Throwable)e);
            }
            return false;
        }
    }

    public String execute() {
        File checkoutdir;
        String repositoryUUID;
        String password;
        String login;
        SvnConnection svnConn;
        block41: {
            String usernameDecode;
            String[] resCookie;
            System.setProperty("file.encoding", "UTF-8");
            if (!this.force && this.format.equals("rst") && !this.isRstValid(this.newText)) {
                return "errorRst";
            }
            try {
                svnConn = new SvnConnection(this.address);
            }
            catch (StringIndexOutOfBoundsException e) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Parameter is not valid ", (Throwable)e);
                }
                return "error";
            }
            login = this.getUsername();
            password = this.getPw();
            repositoryUUID = svnConn.getUUID();
            if (repositoryUUID == null) {
                repositoryUUID = this.address;
            }
            String usernamepwCookie = null;
            BlowfishCipherService bf = new BlowfishCipherService();
            byte[] privateKey = Base64.decode((String)ScmWebEditorConfig.getKey());
            for (Cookie c : this.request.getCookies()) {
                if (!c.getName().equals(repositoryUUID)) continue;
                usernamepwCookie = c.getValue();
            }
            if (usernamepwCookie != null && (resCookie = (usernameDecode = new String(bf.decrypt(Base64.decode(usernamepwCookie), privateKey).getBytes())).split(",")).length == 2) {
                this.username = resCookie[0];
                this.pw = resCookie[1];
            }
            if (this.saveCookie && this.username != null && this.pw != null) {
                Cookie authCookie = new Cookie(repositoryUUID, bf.encrypt((this.username + "," + this.pw).getBytes(), privateKey).toBase64());
                authCookie.setMaxAge(31536000);
                this.response.addCookie(authCookie);
            }
            if ((login == null || login.equals("")) && (password == null || password.equals(""))) {
                if (this.getScmSession().getUsername(repositoryUUID) != null && this.getScmSession().getPassword(repositoryUUID) != null) {
                    login = this.getScmSession().getUsername(repositoryUUID);
                    password = this.getScmSession().getPassword(repositoryUUID);
                } else {
                    login = null;
                    password = null;
                }
            } else {
                this.getScmSession().addScmUser(repositoryUUID, login, password);
            }
            svnConn.updateAuthentication(login, password);
            try {
                svnConn.createCheckoutdir();
            }
            catch (IOException e1) {
                if (log.isErrorEnabled()) {
                    log.error((Object)"Can't create checkoutDir", (Throwable)e1);
                }
                return "error";
            }
            checkoutdir = svnConn.getCheckoutdir();
            try {
                this.checkout(svnConn, checkoutdir);
            }
            catch (SVNAuthenticationException authexep) {
                this.request.setAttribute("address", (Object)this.address);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Private SCM on reading " + svnConn.getRemoteUrl()));
                }
                this.delTempDirectory(checkoutdir);
                this.username = null;
                this.pw = null;
                this.getScmSession().delScmUser(repositoryUUID);
                return "login";
            }
            catch (SVNException e) {
                if (log.isErrorEnabled()) {
                    log.error((Object)"Can't checkout the file", (Throwable)e);
                }
                this.delTempDirectory(checkoutdir);
                return "errorPath";
            }
            File checkOutFile = new File(checkoutdir, svnConn.getFileName());
            this.lastText = this.newText;
            try {
                String originalText;
                this.origText = originalText = FileUtils.readFileToString((File)checkOutFile);
            }
            catch (FileNotFoundException ee) {
                this.delTempDirectory(checkoutdir);
                return "error";
            }
            catch (IOException e) {
                log.error((Object)"Can't find the checkout file", (Throwable)e);
            }
            if (!this.force) {
                try {
                    ByteArrayOutputStream differents;
                    if (!svnConn.isDifferent(this.origText) || (differents = svnConn.getDiff(this.newText)).size() <= 0) break block41;
                    this.diff = differents.toString();
                    this.diff = this.diff.substring(this.diff.indexOf("@@"));
                    this.delTempDirectory(checkoutdir);
                    try {
                        this.headCommiter = this.getHeadcommiter(this.address, login, password);
                    }
                    catch (SVNException e) {
                        log.error((Object)"Can't get head commiter", (Throwable)e);
                    }
                    return FILE_MODIFY;
                }
                catch (IOException e) {
                    if (!log.isErrorEnabled()) break block41;
                    log.error((Object)"Can't do diff on file, IO error", (Throwable)e);
                }
            }
        }
        SVNCommitClient commitClient = new SVNCommitClient((ISVNRepositoryPool)svnConn.getManager(), (ISVNOptions)svnConn.getSvnOption());
        File pathToFile = new File(checkoutdir, svnConn.getFileName());
        try {
            FileUtil.writeString((File)pathToFile, (String)this.newText, (String)"UTF-8");
        }
        catch (IOException e1) {
            this.delTempDirectory(checkoutdir);
            return "error";
        }
        File[] tabFile = new File[]{pathToFile};
        try {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Try to commit");
            }
            commitClient.doCommit(tabFile, false, "From scmwebeditor -- " + this.commitMessage, null, null, false, false, SVNDepth.FILES);
        }
        catch (SVNAuthenticationException authexep) {
            if (log.isErrorEnabled()) {
                log.error((Object)"AUTH FAIL");
            }
            this.origText = this.newText;
            this.badLogin = true;
            this.delTempDirectory(checkoutdir);
            this.username = null;
            this.pw = null;
            this.getScmSession().delScmUser(repositoryUUID);
            return "login";
        }
        catch (SVNException e) {
            if (log.isErrorEnabled()) {
                log.error((Object)"SVN FAIL", (Throwable)e);
            }
            this.delTempDirectory(checkoutdir);
            return "error";
        }
        if (checkoutdir != null) {
            this.delTempDirectory(checkoutdir);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"End of commit");
        }
        this.delTempDirectory(checkoutdir);
        if (log.isInfoEnabled()) {
            log.info((Object)(login + " with IP " + this.request.getRemoteAddr() + " commit the file " + this.address + " with message : " + this.commitMessage));
        }
        try {
            this.numRevision = this.getHeadNumberRevision(this.address, login, password);
        }
        catch (SVNException e) {
            this.numRevision = null;
        }
        return "success";
    }

    public void setServletRequest(HttpServletRequest request) {
        this.request = request;
    }

    public void setServletResponse(HttpServletResponse response) {
        this.response = response;
    }
}

