/*
 * #%L
 * ScmWebEditor
 * 
 * $Id: ScmUrlResolverMavenDocImpl.java 248 2011-08-26 15:09:03Z tchemit $
 * $HeadURL: http://svn.nuiton.org/svn/scmwebeditor/tags/scmwebeditor-0.2/src/main/java/org/nuiton/scmwebeditor/urlResolver/impl/ScmUrlResolverMavenDocImpl.java $
 * %%
 * Copyright (C) 2009 - 2011 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as 
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */
package org.nuiton.scmwebeditor.urlResolver.impl;

import org.apache.commons.lang.StringUtils;
import org.nuiton.scmwebeditor.urlResolver.ScmUrlResolver;

import java.io.IOException;
import java.net.URL;
import java.util.Map;

public class ScmUrlResolverMavenDocImpl implements ScmUrlResolver {

    public static final String MAVEN_SITE_DOCUMENT_NAME = "maven-site-document";

    public static final String PARAMETER_DEFAULT_LOCALE = "svndefaultLocale";

    public static final String PARAMETER_LOCALE = "svnlocale";

    public static final String PARAMETER_SVN_ROOT = "svnroot";

    public static final String PARAMETER_SVN_FILE = "svnfile";

    public static final String PARAMETER_FILE_FORMAT = "svnformat";


    @Override
    public String getLayoutName() {
        return MAVEN_SITE_DOCUMENT_NAME;
    }

    @Override
    public URL resolv(Map<String, String> parameters) throws IOException, IllegalArgumentException {

        String defaultLocale = parameters.get(PARAMETER_DEFAULT_LOCALE);
        String locale = parameters.get(PARAMETER_LOCALE);
        String svnRoot = parameters.get(PARAMETER_SVN_ROOT);
        String svnFile = parameters.get(PARAMETER_SVN_FILE);
        String svnFormat = parameters.get(PARAMETER_FILE_FORMAT);

        if (StringUtils.isEmpty(defaultLocale) || StringUtils.isEmpty(locale) || StringUtils.isEmpty(svnRoot)
            || StringUtils.isEmpty(svnFile) || StringUtils.isEmpty(svnFormat)) {
            throw new IllegalArgumentException(
                    "Layout " + MAVEN_SITE_DOCUMENT_NAME + " requires five parameters '" +
                    PARAMETER_DEFAULT_LOCALE + "', '" + PARAMETER_LOCALE + "' , '" + PARAMETER_SVN_ROOT + "' , '" + PARAMETER_SVN_FILE + "' , '" + PARAMETER_FILE_FORMAT + "'");
        }

        String result;

        if (locale.equals(defaultLocale)) {
            result = svnRoot + "/src/site/" + svnFormat + "/" + svnFile;
        } else {
            result = svnRoot + "/src/site/" + locale + "/" + svnFormat + "/" + svnFile;
        }


        return new URL(result);

    }

}
