/*
 * #%L
 * ScmWebEditor
 * 
 * $Id: ScmWebEditorMainAction.java 248 2011-08-26 15:09:03Z tchemit $
 * $HeadURL: http://svn.nuiton.org/svn/scmwebeditor/tags/scmwebeditor-0.2/src/main/java/org/nuiton/scmwebeditor/actions/ScmWebEditorMainAction.java $
 * %%
 * Copyright (C) 2009 - 2011 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as 
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */
package org.nuiton.scmwebeditor.actions;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.shiro.codec.Base64;
import org.apache.shiro.crypto.BlowfishCipherService;
import org.apache.struts2.interceptor.ServletRequestAware;
import org.apache.struts2.interceptor.ServletResponseAware;
import org.nuiton.scmwebeditor.ScmWebEditorBaseAction;
import org.nuiton.scmwebeditor.ScmWebEditorConfig;
import org.nuiton.scmwebeditor.SvnConnection;
import org.tmatesoft.svn.core.SVNAuthenticationException;
import org.tmatesoft.svn.core.SVNException;

import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.LinkedList;


public class ScmWebEditorMainAction extends ScmWebEditorBaseAction implements ServletRequestAware, ServletResponseAware {


    private static final long serialVersionUID = 8361035067228171624L;

    private static final Log log = LogFactory.getLog(ScmWebEditorMainAction.class);

    public static final String NO_PARAMETER = "noParameter";

    public static final String EDIT_PAGE = "editPage";

    protected String address;

    protected String projectUrl;

    protected String format;

    protected String origText;

    protected String mimeType;

    protected boolean saveCookie = true;

    protected boolean badLogin;

    protected String numRevision;

    protected String addressSvn;

    protected String username;

    protected String pw;

    protected transient HttpServletRequest request;

    protected transient HttpServletResponse response;

    protected String repositoryId;

    protected boolean fromLoginPage;

    public String getAddressSvn() {
        return addressSvn;
    }

    public void setAddressSvn(String addressSvn) {
        this.addressSvn = addressSvn;
    }

    public String getMimeType() {
        return mimeType;
    }

    public String getRepositoryId() {
        return repositoryId;
    }

    public void setRepositoryId(String repositoryId) {
        this.repositoryId = repositoryId;
    }

    public String getUsername() {
        return username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPw() {
        return pw;
    }

    public void setPw(String pw) {
        this.pw = pw;
    }

    public String getAddress() {
        return address;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public String getFormat() {
        return format;
    }

    public void setFormat(String format) {
        this.format = format;
    }

    public String getOrigText() {
        return origText;
    }

    public String getProjectUrl() {
        return projectUrl;
    }

    public String getNumRevision() {
        return numRevision;
    }

    public void setProjectUrl(String projectUrl) {
        this.projectUrl = projectUrl;
    }

    public void setFromLoginPage(boolean fromLoginPage) {
        this.fromLoginPage = fromLoginPage;
    }

    public boolean isBadLogin() {
        return badLogin;
    }

    /**
     * On test si les parametres ne sont pas vide
     *
     * @return
     */
    private boolean testParameters() {
        if (address == null || address.length() == 0) {
            return true;
        } else {
            return false;
        }
    }

    /**
     * Methode principale de la classe
     *
     * @return
     */
    @Override
    public String execute() {

        if (log.isDebugEnabled()) {
            log.debug("Connection to SCMWebEditor\n");
        }


        /* Si il n'y a pas de parametre, l'utilisateur est renvoyé
        * vers la page de configuration (OutConnection)
        */
//        if(testParameters()) {
//            return "noParameter";
//        }


        if (!fromLoginPage && projectUrl == null) {
            projectUrl = request.getHeader("referer");
        }


        if (log.isDebugEnabled()) {
            log.debug("ProjectUrl= " + projectUrl);
        }


//        Map<?,?> map =(Map<?,?>) request.getParameterMap();

        if (testParameters()) {
            return NO_PARAMETER;
        }


//        if(testParameters()) {
//        
//            Map<String,String> parameters = new HashMap<String,String>();
//            
//            Iterator<?> iter = map.entrySet().iterator();
//            while (iter.hasNext()) {
//                Entry<?,?> n = (Entry<?,?>)iter.next();
//                String key = n.getKey().toString();
//                String values[] = (String[]) n.getValue();
//                parameters.put(key,values[0].toString()); 
//            }
//    
//            
//            URL urlSvn = null;
//            try {
//                urlSvn = ScmUrlResolverEngine.resolver(parameters);
//            } catch (IOException e1) {
//                if(log.isErrorEnabled()) {
//                    log.error("erreur", e1);
//                }
//                return "errorPath";
//            } catch (IllegalArgumentException e1) {
//                if(log.isErrorEnabled()) {
//                    log.error(e1.getMessage());
//                }
//                return "errorPath";
//            }
//
//            address=urlSvn.toString();
//        
//        }


        SvnConnection svnConn;


        try {
            svnConn = new SvnConnection(address);
        } catch (StringIndexOutOfBoundsException e) {
            if (log.isDebugEnabled()) {
                log.debug("Parameter is not valid ", e);
            }
            return ERROR_PATH;
        }


        format = svnConn.getFileName().substring(svnConn.getFileName().lastIndexOf(".") + 1);

        String originalText;

        //Si le repo n'est pas protege en ecriture on recupere sont UUID
        String repositoryUUID = svnConn.getUUID();
        if (repositoryUUID == null) {
            repositoryUUID = address;
        }

        if (log.isDebugEnabled()) {
            log.debug("Login : " + username);
        }


        /*
        * Lecture du cookie
        */


        String usernamepwCookie = null;
        // lire cookies

        BlowfishCipherService bf = new BlowfishCipherService();

        byte[] privateKey = Base64.decode(ScmWebEditorConfig.getKey());

        for (Cookie c : request.getCookies()) {
            if (c.getName().equals(repositoryUUID))
                usernamepwCookie = c.getValue();
        }

        if (usernamepwCookie != null) {

            String usernameDecode = new String(bf.decrypt(Base64.decode(usernamepwCookie), privateKey).getBytes());

            String[] resCookie = usernameDecode.split(",");
            if (resCookie.length == 2) {
                username = resCookie[0];
                pw = resCookie[1];
            }
        }

        if (saveCookie) {
            if (username != null && pw != null) {

                Cookie authCookie = new Cookie(repositoryUUID, bf.encrypt((username + "," + pw).getBytes(), privateKey).toBase64());
                authCookie.setMaxAge(60 * 60 * 24 * 365);
                response.addCookie(authCookie);
            }

        }


        /*
        * Récuperation des informations en session
        */
        if (username == null && pw == null) {
            if (getScmSession().getUsername(repositoryUUID) != null && getScmSession().getPassword(repositoryUUID) != null) {
                //On recupère les identifiants en session
                username = getScmSession().getUsername(repositoryUUID);
                pw = getScmSession().getPassword(repositoryUUID);
            } else {
                username = null;
                pw = null;
            }
        } else {
            getScmSession().addScmUser(repositoryUUID, username, pw);
        }


        svnConn.updateAuthentication(username, pw);


        /*
        * Recuperation du fichier et de sa revision
        */
        try {
            originalText = getHeadRevision(address, username, pw);
            numRevision = getHeadNumberRevision(address, username, pw);

        } catch (SVNAuthenticationException authexep) {

            request.setAttribute(PARAMETER_ADDRESS, address);

            // if svn authentication failed user is redirected on login page
            if (log.isDebugEnabled()) {
                log.debug("Auth Fail ", authexep);
            }

            //suppression des cookies pour ce dépot
            for (Cookie c : request.getCookies()) {
                if (c.getName().equals(repositoryUUID)) {
                    c.setMaxAge(0);//On supprime le cookie
                    response.addCookie(c);
                    if (log.isDebugEnabled()) {
                        log.debug("Cookie supprimé");
                    }
                }
            }

            getScmSession().delScmUser(repositoryUUID);
            //redirect to a login page
            return LOGIN;

        } catch (SVNException e) {
            request.setAttribute("projectUrl", projectUrl);

            if (log.isErrorEnabled()) {
                log.error("SVN error ", e);
            }
            return ERROR_PATH;
        } catch (IllegalArgumentException e) {
            request.setAttribute("projectUrl", projectUrl);

            if (log.isDebugEnabled()) {
                log.debug("SVN error debug", e);
            }
            return ERROR_PATH;
        }

        mimeType = null;

        try {
            mimeType = getMimeType(originalText, svnConn.getFileName());
        } catch (IOException e) {
            if (log.isErrorEnabled()) {
                log.error("Can't get MimeType, problem when reading file", e);
            }
        }


        LinkedList<String> editableFiles = new LinkedList<String>();

        editableFiles.add("text");
        editableFiles.add("xml");
        editableFiles.add("x-java");

        editableFiles.addAll(ScmWebEditorConfig.getEditableFiles());


        boolean editable = false;
        if (mimeType != null) {
            for (String fileType : editableFiles) {
                if (mimeType.matches(".*" + fileType + ".*")) {
                    editable = true;
                }
            }
        }


        // Si le fichier n'est pas de type texte, on ne peut pas l'éditer
        if (mimeType == null || !editable) {

            if (log.isErrorEnabled()) {
                log.error("Can't edit this file, mimetype : " + mimeType);
            }
            return ERROR_PATH;
        }

        origText = originalText;


        if (log.isInfoEnabled()) {
            log.info("IP client : " + request.getRemoteAddr() + " , get file : " + address + ". File's mimetype : " + mimeType);
        }

        return EDIT_PAGE;

    }

    @Override
    public void setServletRequest(HttpServletRequest request) {
        this.request = request;
    }


    @Override
    public void setServletResponse(HttpServletResponse response) {
        this.response = response;
    }


}
