/*
 * #%L
 * ScmWebEditor
 * 
 * $Id$
 * $HeadURL$
 * %%
 * Copyright (C) 2009 - 2011 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as 
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */
package org.nuiton.scmwebeditor.actions;

import java.io.IOException;
import java.net.URL;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Map.Entry;
import java.util.Properties;

import javax.servlet.http.HttpServletRequest;

import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts2.interceptor.ServletRequestAware;
import org.nuiton.scmwebeditor.ScmWebEditorBaseAction;
import org.nuiton.scmwebeditor.SvnConnection;
import org.nuiton.scmwebeditor.urlResolver.ScmUrlResolverEngine;
import org.tmatesoft.svn.core.SVNAuthenticationException;
import org.tmatesoft.svn.core.SVNException;


import com.opensymphony.xwork2.Action;


public class ScmWebEditorMainAction extends ScmWebEditorBaseAction implements  ServletRequestAware  {


    private static final long serialVersionUID = 8361035067228171624L;

    private static final Log log = LogFactory.getLog(ScmWebEditorMainAction.class);
    
    protected String address;
    protected String projectUrl;
    protected String format;
    protected String origText;
    
    
    protected String numRevision;
    

    protected String addressSvn;
    
    public String getAddressSvn() {
        return addressSvn;
    }


    public void setAddressSvn(String addressSvn) {
        this.addressSvn = addressSvn;
    }


    protected String username;
    protected String pw;
 
    protected HttpServletRequest request;
    
    protected String repositoryId;

    protected boolean fromLoginPage;
   


    public String getRepositoryId() {
        return repositoryId;
    }


    public void setRepositoryId(String repositoryId) {
        this.repositoryId = repositoryId;
    }


    public String getUsername() {
        return username;
    }


    public void setUsername(String username) {
        this.username = username;
    }


    public String getPw() {
        return pw;
    }


    public void setPw(String pw) {
        this.pw = pw;
    }
    
    public String getAddress() {
        return address;
    }


    public void setAddress(String address) {
        this.address = address;
    }
    
    public String getFormat() {
        return format;
    }


    public void setFormat(String format) {
        this.format = format;
    }


    public String getOrigText() {
        return origText;
    }


    public String getProjectUrl() {
        return projectUrl;
    }

    public String getNumRevision() {
        return numRevision;
    }

    public void setProjectUrl(String projectUrl) {
        this.projectUrl = projectUrl;
    }   
    

    public void setFromLoginPage(boolean fromLoginPage) {
        this.fromLoginPage = fromLoginPage;
    }

    
    

    /**
     * On test si les parametres ne sont pas vide
     * @return
     */
    private boolean testParameters() {
        if (address == null || address.length() == 0) {
            return true;
        }
        else {
            return false;
        }
    }
    
//    public void prepare() {
//        
//    }
    
    /**
     * Methode principale de la classe
     * @return
     */
    public String execute() {
        
        
         if(log.isDebugEnabled()) {
            log.debug("Connection to SCMWebEditor\n");
         }
       
        
        
        /* Si il n'y a pas de parametre, l'utilisateur est renvoyé
         * vers la page de configuration (OutConnection)
         */
//        if(testParameters()) {
//            return "noParameter";
//        }
        
        
        if(!this.fromLoginPage) {
            projectUrl=request.getHeader("referer");
        }
        
        
        if(log.isDebugEnabled()) {
            log.debug("ProjectUrl= "+projectUrl);
        }
        
        
        
        Map<?,?> map =(Map<?,?>) request.getParameterMap();
        
        if(map.size()==0 && testParameters()) {
            return "noParameter";
        }
        
        
        if(testParameters()) {
        
            Map<String,String> parameters = new HashMap<String,String>();
            
            Iterator<?> iter = map.entrySet().iterator();
            while (iter.hasNext()) {
                Entry<?,?> n = (Entry<?,?>)iter.next();
                String key = n.getKey().toString();
                String values[] = (String[]) n.getValue();
                parameters.put(key,values[0].toString()); 
            }
    
            
            URL urlSvn = null;
            try {
                urlSvn = ScmUrlResolverEngine.resolver(parameters);
            } catch (IOException e1) {
                if(log.isErrorEnabled()) {
                    log.error("erreur", e1);
                }
                return "errorPath";
            } catch (IllegalArgumentException e1) {
                if(log.isErrorEnabled()) {
                    log.error(e1.getMessage());
                }
                return "errorPath";
            }

            address=urlSvn.toString();
        
        }
        
                
        SvnConnection svnConn = null;
        

        try {
            svnConn = new SvnConnection(address);
        }
        catch (StringIndexOutOfBoundsException e) {
            if(log.isDebugEnabled()) {
                log.debug("Parameter is not valid ",e);
            }
            return "errorPath";  
        }
        
        
        format = svnConn.getFileName().substring(svnConn.getFileName().lastIndexOf(".")+1);
        
        String originalText = "";
        
        //Si le repo n'est pas protege en ecriture on recupere sont UUID
        String repositoryUUID = svnConn.getUUID();
        if (repositoryUUID==null) {
            repositoryUUID=address;
        }
        
        if(log.isDebugEnabled()) {
            log.debug("Login : "+username);
        }
            
        if(username==null && pw==null) {
            if(getScmSession().getUsername(repositoryUUID)!=null && getScmSession().getPassword(repositoryUUID)!=null) {
                //On recupère les identifiants en session
                username = getScmSession().getUsername(repositoryUUID);
                pw = getScmSession().getPassword(repositoryUUID);
            }
            else {
                username = null;
                pw = null;
            }
        }
        else {
            getScmSession().addScmUser(repositoryUUID, username , pw);
        }
        
        svnConn.updateAuthentication(username, pw);


        try {
            originalText = getHeadRevision(address, username, pw);
            numRevision = getHeadNumberRevision(address, username, pw);
        
        } catch (SVNAuthenticationException authexep) {
            
            request.setAttribute(PARAMETER_ADDRESS, address);
              
            // if svn authentication failed user is redirected on login page
            if(log.isDebugEnabled()) {
                  log.debug("Auth Fail " ,authexep);
            }
            
            getScmSession().delScmUser(repositoryUUID);
            //redirect to a login page
            return Action.LOGIN;
          
      } catch (SVNException e) {
            request.setAttribute("projectUrl", projectUrl);
            
            if(log.isErrorEnabled()) {
                log.error("SVN error ",e);
            }
            return "errorPath";
      } catch (IllegalArgumentException e) {
          request.setAttribute("projectUrl", projectUrl);
          
          if(log.isDebugEnabled()) {
              log.debug("SVN error debug",e);
          }
          return "errorPath";
      } 
        
  
        
        
        
        String mimeType =null;
       
        try {
            mimeType = getMimeType(originalText, svnConn.getFileName());
        } catch (IOException e) {
            if(log.isErrorEnabled()) {
                log.error("Can't get MimeType, problem when reading file",e);
            }
        } 


        Properties properties=null;
        String[] editableFiles=null;
        
          
            try {
                properties = loadProperties("src/main/resources/scm.properties");
                
                if(log.isDebugEnabled()) {
                    log.debug("editableFiles: "+ properties.getProperty("editableFiles", "text"));
                }
                editableFiles=properties.getProperty("editableFiles", "text").split(",");
                
            } catch (IOException e) {
                if(log.isErrorEnabled()) {
                    log.error("Can't read properties file", e );
                }
                editableFiles = new String[1];
                editableFiles[0] = "text"; 
            }

        
        boolean editable =false;
        if(mimeType!=null ) {
            for (String fileType : editableFiles){
                if (mimeType.matches(".*"+fileType+".*")) {
                    editable=true;
                }
            }
        }
        
        
        
        // Si le fichier n'est pas de type texte, on ne peut pas l'éditer
        if(mimeType==null || editable==false ) {
            request.setAttribute("projectUrl", projectUrl);
            
            if(log.isErrorEnabled()) {
                log.error("Can't edit this file, mimetype : "+mimeType);
            }
            return "errorPath";
        }
        else {
            request.setAttribute("minetype", mimeType);
        }
        
        
      
            
        origText=StringEscapeUtils.escapeHtml(originalText);
        request.setAttribute(ATTRIBUTE_PROJECT_URL, projectUrl);
        
        if(log.isInfoEnabled()) {
            log.info("IP client : "+request.getRemoteAddr() + " , get file : "+address+ ". File's mimetype : "+mimeType);
        }
        
       
       
        return "editPage";

        
    }


    @Override
    public void setServletRequest(HttpServletRequest request) {
        this.request = request;
    }


    
}
