/*
 * #%L
 * Nuiton-ScmWebEditor
 * 
 * $Id: SvnSession.java 199 2011-08-03 15:54:19Z kcardineaud $
 * $HeadURL: http://svn.nuiton.org/svn/scmwebeditor/trunk/src/main/java/org/nuiton/scmwebeditor/SvnSession.java $
 * %%
 * Copyright (C) 2009 - 2010 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as 
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */
package org.nuiton.scmwebeditor;

import org.apache.commons.io.FileUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.util.FileUtil;
import org.tmatesoft.svn.core.SVNDepth;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNProperty;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.auth.ISVNAuthenticationManager;
import org.tmatesoft.svn.core.internal.wc.DefaultSVNOptions;
import org.tmatesoft.svn.core.io.SVNRepository;
import org.tmatesoft.svn.core.io.SVNRepositoryFactory;
import org.tmatesoft.svn.core.wc.SVNClientManager;
import org.tmatesoft.svn.core.wc.SVNDiffClient;
import org.tmatesoft.svn.core.wc.SVNRevision;
import org.tmatesoft.svn.core.wc.SVNWCUtil;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;

public class SvnConnection {

    
    private static final Log log = LogFactory.getLog(SvnConnection.class);
    /**
     * full svn path 
     */
    protected String addressSvn;
    /**
     * svn path without fileName
     */
    protected String svnPath;
    /**
     * fileName of modif file
     */
    protected String fileName;
    /**
     * Temp directory for checkout
     */
    protected File checkoutdir;
    /**
     * url of svn path
     */
    protected SVNURL remoteUrl;
    /**
     * AuthenticationManager with login and password
     */
    protected ISVNAuthenticationManager authManager;
    /**
     * svn default option
     */
    protected DefaultSVNOptions svnOption;
    /**
     *
     */
    protected SVNClientManager manager;

    
    protected String repositoryId;
    


    public SvnConnection (
            String address) throws StringIndexOutOfBoundsException {
        
        this.addressSvn = address;
        
        this.svnPath = address.substring(0,address.lastIndexOf("/"));
        
        this.fileName = address.substring(address.lastIndexOf("/")+1);
        
        try {
            this.remoteUrl = SVNURL.parseURIEncoded(svnPath);
        } catch (SVNException e) {
            if(log.isErrorEnabled()) {
                log.error("Can't parse svnPath", e);
            }
        }

        this.authManager = SVNWCUtil.createDefaultAuthenticationManager();
        this.svnOption = SVNWCUtil.createDefaultOptions(false);
        this.svnOption.setPropertyValue(SVNProperty.EOL_STYLE, SVNProperty.EOL_STYLE_LF);
        this.manager = SVNClientManager.newInstance(this.svnOption, this.authManager);
    }

    public void updateAuthentication(String login, String password) {
        setAuthManager(SVNWCUtil.createDefaultAuthenticationManager(login, password));
        setManager(SVNClientManager.newInstance(getSvnOption(), getAuthManager()));
    }
    
    /**
     * 
     * @return
     */
    public String getUUID() {
        String repositoryUUID = null;
        try {
            SVNRepository repository = SVNRepositoryFactory.create(SVNURL.parseURIDecoded(addressSvn));
            ISVNAuthenticationManager authManager = SVNWCUtil.createDefaultAuthenticationManager();
            repository.setAuthenticationManager(authManager);
    
            repositoryUUID = repository.getRepositoryUUID(true);
        }
        catch (SVNException e) {
            if(log.isDebugEnabled()) {
                log.debug("Can't get UUID");
            }
            return null;
        }
        
        return repositoryUUID;
    }
    
    /**
     * 
     * @return
     */
    public String getSvnRoot() {
        String repositoryRoot = null;
        try {
            SVNRepository repository = SVNRepositoryFactory.create(SVNURL.parseURIDecoded(addressSvn));
            ISVNAuthenticationManager authManager = SVNWCUtil.createDefaultAuthenticationManager();
            repository.setAuthenticationManager(authManager);
    
            repositoryRoot = repository.getRepositoryRoot(true).toString();
        }
        catch (SVNException e) {
            if(log.isDebugEnabled()) {
                log.debug("Can't get SvnRoot");
            }
            return null;
        }
        
        return repositoryRoot;
    }
    
    
    public void testConnection() throws SVNException {
        SVNRepository repository = SVNRepositoryFactory.create(SVNURL.parseURIDecoded(addressSvn));
        repository.setAuthenticationManager(this.authManager);
        
        
        repository.testConnection();
        
        
    }
    
    
    public boolean isDifferent(String text) throws IOException {
        File pathToFile = new File(checkoutdir, getFileName());
        
        SVNDiffClient diffClient = new SVNDiffClient(getManager(), getSvnOption());
        
        FileUtils.writeStringToFile(pathToFile, text);
          
        ByteArrayOutputStream diff = new ByteArrayOutputStream();
        
        try {
            diffClient.doDiff(pathToFile, SVNRevision.UNDEFINED, SVNRevision.WORKING, SVNRevision.HEAD, SVNDepth.INFINITY, true, diff, null);
        } catch (SVNException e) {
            log.error("Diff fail",e);
            return false;
        }

        if(diff.size()>0) {
            return true;
        }
        else {
            return false;
        }
        
        
    }
    
    public ByteArrayOutputStream getDiff(String text) throws IOException {
        File pathToFile = new File(checkoutdir, getFileName());

        SVNDiffClient diffClient = new SVNDiffClient(getManager(), getSvnOption());
        
        FileUtils.writeStringToFile(pathToFile, text);
       
        ByteArrayOutputStream diff = new ByteArrayOutputStream();
        
        try {
            diffClient.doDiff(pathToFile, SVNRevision.UNDEFINED, SVNRevision.WORKING, SVNRevision.HEAD, SVNDepth.INFINITY, true, diff, null);
        } catch (SVNException e) {
            log.error("Diff fail",e);
        }
        
        
        return diff;
        
        
        
    }
    
        

    public ISVNAuthenticationManager getAuthManager() {
        return authManager;
    }

    public void setAuthManager(ISVNAuthenticationManager authManager) {
        this.authManager = authManager;
    }

    public File getCheckoutdir() {
        return checkoutdir;
    }

    public void createCheckoutdir() throws IOException {
        this.checkoutdir = FileUtil.createTempDirectory("scm_", "");
    }
    
    public void setCheckoutdir(File checkoutdir) {
        this.checkoutdir = checkoutdir;
    }

    public String getFileName() {
        return fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public SVNClientManager getManager() {
        return manager;
    }

    public void setManager(SVNClientManager manager) {
        this.manager = manager;
    }

    public SVNURL getRemoteUrl() {
        return remoteUrl;
    }

    public void setRemoteUrl(SVNURL remoteUrl) {
        this.remoteUrl = remoteUrl;
    }

    public DefaultSVNOptions getSvnOption() {
        return svnOption;
    }

    public void setSvnOption(DefaultSVNOptions svnOption) {
        this.svnOption = svnOption;
    }

    public String getSvnPath() {
        return svnPath;
    }

    public void setSvnPath(String svnPath) {
        this.svnPath = svnPath;
    }
    
    public String getRepositoryId() {
        return repositoryId;
    }

    public void setRepositoryId(String repositoryId) {
        this.repositoryId = repositoryId;
    }



}
