/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.scmwebeditor.uiweb.actions;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import javax.imageio.ImageIO;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.scmwebeditor.uiweb.ScmWebEditorConfig;
import org.nuiton.scmwebeditor.uiweb.actions.ScmWebEditorMainAction;

public class GetImageAction
extends ScmWebEditorMainAction {
    private static final Log log = LogFactory.getLog(GetImageAction.class);
    protected byte[] imageInByte = null;
    protected String imagePath;
    protected HttpServletRequest servletRequest;

    public byte[] getImageInByte() {
        return this.imageInByte;
    }

    public void setImageInByte(byte[] imageInByte) {
        this.imageInByte = new byte[0];
        if (imageInByte != null) {
            this.imageInByte = Arrays.copyOf(imageInByte, imageInByte.length);
        }
    }

    public String getImagePath() {
        return this.imagePath;
    }

    public void setImagePath(String imagePath) {
        this.imagePath = imagePath;
    }

    public String execute() {
        return "success";
    }

    public byte[] getCustomImageInBytes() {
        block6: {
            HttpSession session = this.servletRequest.getSession();
            String sessionId = session.getId();
            String pathToLocalRepos = ScmWebEditorConfig.getLocalRepositoriesPath() + File.separator + sessionId;
            if (this.imagePath.startsWith(pathToLocalRepos)) {
                try {
                    File fileImage = new File(this.imagePath);
                    String fileFormat = this.imagePath.substring(this.imagePath.lastIndexOf(46) + 1);
                    if (fileFormat.toLowerCase().equals("svg")) {
                        Path path = Paths.get(this.imagePath, new String[0]);
                        this.imageInByte = Files.readAllBytes(path);
                    } else {
                        BufferedImage originalImage = ImageIO.read(fileImage);
                        ByteArrayOutputStream baos = new ByteArrayOutputStream();
                        ImageIO.write((RenderedImage)originalImage, fileFormat, baos);
                        baos.flush();
                        this.imageInByte = baos.toByteArray();
                        baos.close();
                    }
                }
                catch (IOException e) {
                    if (!log.isErrorEnabled()) break block6;
                    log.error((Object)("Can not get image file at " + this.imagePath), (Throwable)e);
                }
            }
        }
        byte[] imageInByteCopy = new byte[]{};
        if (this.imageInByte != null) {
            imageInByteCopy = Arrays.copyOf(this.imageInByte, this.imageInByte.length);
        }
        return imageInByteCopy;
    }

    public String getCustomContentType() {
        String type = "image/jpeg";
        String path = this.imagePath.toLowerCase();
        if (path.endsWith(".png")) {
            type = "image/png";
        } else if (path.endsWith(".gif")) {
            type = "image/gif";
        } else if (path.endsWith(".svg")) {
            type = "image/svg+xml";
        }
        return type;
    }

    public void setServletRequest(HttpServletRequest request) {
        this.servletRequest = request;
    }
}

