/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.scmwebeditor.uiweb.actions;

import com.jgeppert.struts2.jquery.tree.result.TreeNode;
import java.io.File;
import java.io.UnsupportedEncodingException;
import java.text.Normalizer;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.shiro.codec.Base64;
import org.apache.shiro.crypto.BlowfishCipherService;
import org.apache.struts2.interceptor.ServletResponseAware;
import org.nuiton.scmwebeditor.api.ScmConnection;
import org.nuiton.scmwebeditor.api.ScmProvider;
import org.nuiton.scmwebeditor.api.dto.BrowseDto;
import org.nuiton.scmwebeditor.api.dto.result.BrowseResultDto;
import org.nuiton.scmwebeditor.uiweb.ScmWebEditorConfig;
import org.nuiton.scmwebeditor.uiweb.actions.AbstractScmWebEditorAction;

public class BrowseAction
extends AbstractScmWebEditorAction
implements ServletResponseAware {
    private static final long serialVersionUID = 4432027215087932750L;
    private static final Log log = LogFactory.getLog(BrowseAction.class);
    public static final String ROOT = "root";
    protected String address;
    protected String username;
    protected String pw;
    protected boolean error;
    protected List<TreeNode> nodes = new ArrayList();
    protected String id = "";
    protected String selectedBranch;
    protected String headBranchName;
    protected boolean scmSupportsBranches;
    protected transient HttpServletResponse response;

    public boolean getError() {
        return this.error;
    }

    public void setError(boolean error) {
        this.error = error;
    }

    public String getAddress() {
        return this.address;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPw() {
        return this.pw;
    }

    public void setPw(String pw) {
        this.pw = pw;
    }

    public String getId() {
        return this.id;
    }

    public String getHeadBranchName() {
        return this.headBranchName;
    }

    public String getSelectedBranch() {
        return this.selectedBranch;
    }

    public void setSelectedBranch(String selectedBranch) {
        this.selectedBranch = selectedBranch;
    }

    public void setHeadBranchName(String headBranchName) {
        this.headBranchName = headBranchName;
    }

    public boolean isScmSupportsBranches() {
        return this.scmSupportsBranches;
    }

    public void setScmSupportsBranches(boolean scmSupportsBranches) {
        this.scmSupportsBranches = scmSupportsBranches;
    }

    public List<TreeNode> getNodes() {
        return this.nodes;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String execute() {
        String repositoryUUID;
        String dtoError;
        if (log.isDebugEnabled()) {
            log.debug((Object)"Enter in browse action");
        }
        if (this.address.endsWith("/")) {
            this.address = this.address.substring(0, this.address.length() - 1);
        }
        if (this.username == null) {
            this.username = "anonymous";
        }
        if (this.pw == null) {
            this.pw = "anonymous";
        }
        HttpSession session = this.request.getSession();
        String sessionId = session.getId();
        String pathToLocalRepos = ScmWebEditorConfig.getLocalRepositoriesPath() + File.separator + sessionId;
        ScmProvider provider = ScmWebEditorConfig.getProvider((String)this.scmType);
        ScmConnection scmConn = provider.getConnection(this.address, pathToLocalRepos);
        this.scmSupportsBranches = provider.supportsBranches();
        if (scmConn == null) {
            this.error = true;
            return ROOT;
        }
        BrowseDto dto = new BrowseDto();
        dto.setUsername(this.username);
        dto.setPassword(this.pw);
        dto.setId(this.id);
        dto.setAddress(this.address);
        dto.setSelectedBranch(this.selectedBranch);
        BrowseResultDto resultDto = scmConn.browse(dto);
        if (resultDto.getHeadBranchName() != null) {
            this.headBranchName = resultDto.getHeadBranchName();
        }
        if (resultDto.getSelectedBranch() != null) {
            this.selectedBranch = resultDto.getSelectedBranch();
        }
        if ((dtoError = resultDto.getError()) != null) {
            if (!dtoError.equals(ROOT)) {
                this.error = true;
            }
            if (dtoError.equals("auth error")) {
                return "authError";
            }
            if (dtoError.equals(ROOT) || dtoError.equals("error")) {
                return ROOT;
            }
        }
        if (resultDto.getFiles() != null) {
            for (String string : resultDto.getFiles()) {
                TreeNode node = new TreeNode();
                node.setId(string);
                node.setTitle(string.substring(string.lastIndexOf("/") + 1));
                node.setState("leaf");
                String fileName = string.toLowerCase();
                if (fileName.endsWith(".js")) {
                    node.setIcon("ui-icon-js");
                } else if (fileName.endsWith(".html") || string.toLowerCase().endsWith(".htm")) {
                    node.setIcon("ui-icon-html");
                } else if (fileName.endsWith(".xml")) {
                    node.setIcon("ui-icon-xml");
                } else if (fileName.endsWith(".java")) {
                    node.setIcon("ui-icon-java");
                } else if (fileName.endsWith(".css")) {
                    node.setIcon("ui-icon-css");
                } else if (fileName.endsWith(".rst") || fileName.endsWith(".md")) {
                    node.setIcon("ui-icon-preview");
                } else if (fileName.endsWith(".tex")) {
                    node.setIcon("ui-icon-tex");
                } else if (fileName.endsWith(".txt")) {
                    node.setIcon("ui-icon-txt");
                } else if (fileName.endsWith(".jpg") || fileName.endsWith(".jpeg") || fileName.endsWith(".png") || fileName.endsWith(".gif") || fileName.endsWith(".svg")) {
                    node.setIcon("ui-icon-image");
                } else {
                    node.setIcon("ui-icon-document");
                }
                this.nodes.add(node);
            }
        }
        if (resultDto.getDirectories() != null) {
            for (Map.Entry entry : resultDto.getDirectories().entrySet()) {
                String value = (String)entry.getValue();
                TreeNode node = new TreeNode();
                node.setId(value);
                node.setTitle(value.substring(value.lastIndexOf("/") + 1));
                this.nodes.add(node);
            }
        }
        if ((repositoryUUID = scmConn.getRepositoryId()) == null) {
            repositoryUUID = this.address.replace(' ', '_');
            repositoryUUID = Normalizer.normalize(repositoryUUID, Normalizer.Form.NFD).replaceAll("[\u0300-\u036f]", "");
        }
        if (!(this.username == null || this.pw == null || this.username.equals("anonymous") || this.username.equals("") || this.pw.equals("anonymous") || this.pw.equals(""))) {
            Cookie authCookie;
            block39: {
                BlowfishCipherService blowfishCipherService = new BlowfishCipherService();
                byte[] privateKey = Base64.decode((String)ScmWebEditorConfig.getKey());
                authCookie = null;
                try {
                    authCookie = new Cookie(repositoryUUID, blowfishCipherService.encrypt((this.username + "," + this.pw).getBytes("UTF-8"), privateKey).toBase64());
                }
                catch (UnsupportedEncodingException e) {
                    if (!log.isErrorEnabled()) break block39;
                    log.error((Object)"Can not get bytes from UTF-8 encoding");
                }
            }
            if (authCookie != null) {
                authCookie.setMaxAge(31536000);
                this.response.addCookie(authCookie);
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("addscmuser uuid == " + repositoryUUID));
            }
            this.getScmSession().addScmUser(repositoryUUID, this.username, this.pw);
        }
        return "success";
    }

    public void setServletResponse(HttpServletResponse response) {
        this.response = response;
    }
}

