/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.scmwebeditor.uiweb.actions;

import java.io.File;
import java.io.UnsupportedEncodingException;
import java.text.Normalizer;
import java.util.Arrays;
import java.util.List;
import javax.naming.AuthenticationException;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpSession;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.shiro.codec.Base64;
import org.apache.shiro.crypto.BlowfishCipherService;
import org.nuiton.scmwebeditor.api.OperationNotSupportedException;
import org.nuiton.scmwebeditor.api.ScmConnection;
import org.nuiton.scmwebeditor.api.ScmProvider;
import org.nuiton.scmwebeditor.uiweb.ScmWebEditorConfig;
import org.nuiton.scmwebeditor.uiweb.actions.ScmWebEditorMainAction;

public class ViewImageAction
extends ScmWebEditorMainAction {
    private static final Log log = LogFactory.getLog(ViewImageAction.class);
    protected static final String VIEW_IMAGE = "viewImage";
    protected static final List<String> SUPPORTED_IMAGE_FORMATS = Arrays.asList("jpg", "jpeg", "png", "gif", "svg");
    protected String selectedBranch;
    protected boolean scmSupportsBranches;
    protected String repositoryRoot;
    protected String imagePath;
    protected boolean filesDirectlyAccessible;

    public String getSelectedBranch() {
        return this.selectedBranch;
    }

    public void setSelectedBranch(String selectedBranch) {
        this.selectedBranch = selectedBranch;
    }

    public boolean isScmSupportsBranches() {
        return this.scmSupportsBranches;
    }

    public void setScmSupportsBranches(boolean scmSupportsBranches) {
        this.scmSupportsBranches = scmSupportsBranches;
    }

    public String getRepositoryRoot() {
        return this.repositoryRoot;
    }

    public void setRepositoryRoot(String repositoryRoot) {
        this.repositoryRoot = repositoryRoot;
    }

    public String getImagePath() {
        return this.imagePath;
    }

    public void setImagePath(String imagePath) {
        this.imagePath = imagePath;
    }

    public boolean isFilesDirectlyAccessible() {
        return this.filesDirectlyAccessible;
    }

    public void setFilesDirectlyAccessible(boolean filesDirectlyAccessible) {
        this.filesDirectlyAccessible = filesDirectlyAccessible;
    }

    public String execute() {
        String changeBranchError;
        String password;
        String name;
        String repositoryUUID;
        ScmConnection scmConn;
        block32: {
            this.format = this.address.substring(this.address.lastIndexOf(46) + 1).toLowerCase();
            if (!SUPPORTED_IMAGE_FORMATS.contains(this.format)) {
                return "errorPath";
            }
            HttpSession session = this.request.getSession();
            String sessionId = session.getId();
            String pathToLocalRepos = ScmWebEditorConfig.getLocalRepositoriesPath() + File.separator + sessionId;
            ScmProvider provider = ScmWebEditorConfig.getProvider((String)this.scmType);
            scmConn = provider.getConnection(this.address, pathToLocalRepos);
            this.scmSupportsBranches = provider.supportsBranches();
            this.filesDirectlyAccessible = provider.filesDirectlyAccessible();
            repositoryUUID = scmConn.getRepositoryId();
            if (repositoryUUID == null) {
                repositoryUUID = this.address.replace(' ', '_');
                repositoryUUID = Normalizer.normalize(repositoryUUID, Normalizer.Form.NFD).replaceAll("[\u0300-\u036f]", "");
            }
            if (this.repositoryRoot == null) {
                this.repositoryRoot = this.address.substring(0, this.address.lastIndexOf(47));
            } else if (this.repositoryRoot.equals("")) {
                this.repositoryRoot = this.address.substring(0, this.address.lastIndexOf(47));
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("Login : " + this.username));
            }
            String usernamepwCookie = null;
            BlowfishCipherService bf = new BlowfishCipherService();
            byte[] privateKey = Base64.decode((String)ScmWebEditorConfig.getKey());
            if (this.request.getCookies() != null) {
                for (Cookie c : this.request.getCookies()) {
                    if (!c.getName().equals(repositoryUUID)) continue;
                    usernamepwCookie = c.getValue();
                }
            }
            if (usernamepwCookie != null) {
                String[] resCookie;
                String usernameDecode;
                block30: {
                    usernameDecode = null;
                    try {
                        usernameDecode = new String(bf.decrypt(Base64.decode(usernamepwCookie), privateKey).getBytes(), "UTF-8");
                    }
                    catch (UnsupportedEncodingException e) {
                        if (!log.isErrorEnabled()) break block30;
                        log.error((Object)"Can not create a String with UTF-8 encoding");
                    }
                }
                if (usernameDecode != null && (resCookie = usernameDecode.split(",")).length == 2) {
                    this.username = resCookie[0];
                    this.pw = resCookie[1];
                }
            }
            if (this.saveCookie && this.username != null && this.pw != null && !this.username.equals("") && !this.pw.equals("")) {
                Cookie authCookie;
                block31: {
                    authCookie = null;
                    try {
                        authCookie = new Cookie(repositoryUUID, bf.encrypt((this.username + "," + this.pw).getBytes("UTF-8"), privateKey).toBase64());
                    }
                    catch (UnsupportedEncodingException e) {
                        if (!log.isErrorEnabled()) break block31;
                        log.error((Object)"Can not get a String from UTF-8 encoding");
                    }
                }
                if (authCookie != null) {
                    authCookie.setMaxAge(31536000);
                    this.response.addCookie(authCookie);
                }
            }
            String[] usernamePw = this.getUsernamePwFromSession(repositoryUUID, this.username, this.pw);
            this.username = usernamePw[0];
            this.pw = usernamePw[1];
            name = this.username;
            password = this.pw;
            if (name == null) {
                name = "anonymous";
            }
            if (password == null) {
                password = "anonymous";
            }
            changeBranchError = null;
            if (this.scmSupportsBranches) {
                try {
                    changeBranchError = provider.changeBranch(this.selectedBranch, pathToLocalRepos, this.username, this.pw);
                }
                catch (OperationNotSupportedException e) {
                    if (!log.isErrorEnabled()) break block32;
                    log.error((Object)("Can not change branch with SCM '" + this.scmType + "'"));
                }
            }
        }
        if (changeBranchError != null) {
            if (changeBranchError.equals("auth error")) {
                return "login";
            }
            return "errorPath";
        }
        try {
            this.numRevision = scmConn.getHeadRevisionNumber(this.address, name, password);
        }
        catch (AuthenticationException e) {
            this.request.setAttribute("address", (Object)this.address);
            if (log.isDebugEnabled()) {
                log.debug((Object)"Auth Fail ", (Throwable)e);
            }
            for (Cookie c : this.request.getCookies()) {
                if (!c.getName().equals(repositoryUUID)) continue;
                c.setMaxAge(0);
                this.response.addCookie(c);
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)"Cookie supprim\u00e9");
            }
            this.getScmSession().delScmUser(repositoryUUID);
            return "login";
        }
        catch (IllegalArgumentException e) {
            if (log.isErrorEnabled()) {
                log.error((Object)"The file does not exist", (Throwable)e);
            }
            return "errorPath";
        }
        this.imagePath = scmConn.getFilePath(this.address, this.repositoryRoot, this.username, this.pw);
        if (log.isInfoEnabled()) {
            log.info((Object)("IP client : " + this.request.getRemoteAddr() + " , get file : " + this.address + ". File's mimetype : " + this.mimeType));
        }
        return VIEW_IMAGE;
    }
}

