/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.processor.plugin;

import java.io.File;
import java.util.Arrays;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.nuiton.io.MirroredFileUpdater;
import org.nuiton.plugin.AbstractPlugin;
import org.nuiton.plugin.PluginHelper;
import org.nuiton.plugin.PluginWithEncoding;
import org.nuiton.processor.Processor;
import org.nuiton.processor.ProcessorUtil;

@Mojo(name="process", requiresProject=true)
public class ProcessorPlugin
extends AbstractPlugin
implements PluginWithEncoding {
    @Component
    protected MavenProject project;
    @Parameter(property="processor.srcDir", defaultValue="${basedir}/src/main/java")
    protected File srcDir;
    @Parameter(property="processor.destDir", defaultValue="${basedir}/target/processed-sources/java")
    protected File destDir;
    @Parameter(property="processor.includes")
    protected String includes;
    @Parameter(property="processor.excludes")
    protected String excludes;
    @Parameter(property="processor.fileInPattern", defaultValue="")
    protected String fileInPattern = "";
    @Parameter(property="processor.fileOutPattern", defaultValue="")
    protected String fileOutPattern = "";
    @Parameter(property="processor.filters", defaultValue="org.nuiton.processor.filters.NoActionFilter")
    protected String filters;
    @Parameter(property="processor.encoding", defaultValue="${project.build.sourceEncoding}", required=true)
    private String encoding;
    @Parameter(property="processor.overwrite", defaultValue="false")
    protected boolean overwrite;
    @Parameter(property="processor.verbose", defaultValue="${maven.verbose}")
    protected boolean verbose;
    @Parameter(property="processor.testPhase", defaultValue="false")
    protected boolean testPhase;
    protected Map<String, String> filesToTreate;

    public boolean isVerbose() {
        return this.verbose;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    public MavenProject getProject() {
        return this.project;
    }

    public void setProject(MavenProject project) {
        this.project = project;
    }

    public final String getEncoding() {
        return this.encoding;
    }

    public final void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    protected void init() throws Exception {
        MirroredFileUpdater updater;
        if (StringUtils.isEmpty((String)this.filters)) {
            return;
        }
        MirroredFileUpdater mirroredFileUpdater = updater = this.overwrite ? null : new MirroredFileUpdater(this.fileInPattern, this.fileOutPattern, this.srcDir, this.destDir);
        if (updater != null) {
            updater.setDestinationDirectory(this.destDir);
        }
        String[] aIncludes = this.includes.split(",");
        String[] aExcludes = this.excludes == null ? null : this.excludes.split(",");
        this.filesToTreate = this.getFilesToTreate(aIncludes, aExcludes, this.srcDir, updater);
    }

    protected boolean checkSkip() {
        if (StringUtils.isEmpty((String)this.filters)) {
            this.getLog().warn((CharSequence)"No filters to use, skip execution.");
            return false;
        }
        if (this.filesToTreate == null || this.filesToTreate.isEmpty()) {
            this.getLog().info((CharSequence)"No file to process.");
            return false;
        }
        return true;
    }

    protected void doAction() throws Exception {
        if (this.isVerbose()) {
            this.printConfig();
        }
        long t0 = System.nanoTime();
        Processor processor = ProcessorUtil.newProcessor((String)this.filters, (String)",");
        this.getLog().info((CharSequence)("Processing " + this.filesToTreate.size() + " files(s)."));
        for (Map.Entry<String, String> entry : this.filesToTreate.entrySet()) {
            File srcFile = new File(this.srcDir, entry.getKey());
            File dstFile = new File(entry.getValue());
            if (this.isVerbose()) {
                this.getLog().info((CharSequence)("Process " + srcFile));
            }
            this.createDirectoryIfNecessary(dstFile.getParentFile());
            ProcessorUtil.doProcess((Processor)processor, (File)srcFile, (File)dstFile, (String)this.getEncoding());
        }
        if (this.isVerbose()) {
            long time = System.nanoTime() - t0;
            this.getLog().info((CharSequence)("done in " + PluginHelper.convertTime((long)time)));
        }
        if (this.testPhase) {
            this.removeTestCompileSourceRoots(this.srcDir);
        } else {
            this.removeCompileSourceRoots(this.srcDir);
        }
        if (this.testPhase) {
            this.addTestCompileSourceRoots(this.destDir);
        } else {
            this.addCompileSourceRoots(this.destDir);
        }
    }

    protected void printConfig() {
        this.getLog().info((CharSequence)("config - srcDir         " + this.srcDir));
        this.getLog().info((CharSequence)("config - destDir        " + this.destDir));
        this.getLog().info((CharSequence)("config - includes       " + this.includes));
        this.getLog().info((CharSequence)("config - filters        " + Arrays.asList(PluginHelper.splitAndTrim((String)this.filters, (String)","))));
        if (this.excludes != null) {
            this.getLog().info((CharSequence)("config - excludes       " + this.excludes));
        }
        if (!StringUtils.isEmpty((String)this.fileInPattern)) {
            this.getLog().info((CharSequence)("config - fileInPattern  " + this.fileInPattern));
        }
        if (!StringUtils.isEmpty((String)this.fileOutPattern)) {
            this.getLog().info((CharSequence)("config - fileOutPattern " + this.fileOutPattern));
        }
        if (this.overwrite) {
            this.getLog().info((CharSequence)("config - overwrite      " + this.overwrite));
        }
    }
}

