/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.processor.filters;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.processor.filters.DefaultFilter;
import org.nuiton.processor.filters.GeneratorTemplatesFilterIn;

public class GeneratorTemplatesFilter
extends DefaultFilter {
    private static final Log log = LogFactory.getLog(GeneratorTemplatesFilter.class);
    protected boolean passEmptyLine = false;
    protected boolean writeParentheses = true;
    protected String writeString = "output.write";
    protected GeneratorTemplatesFilterIn inFilter = new GeneratorTemplatesFilterIn(this);

    public String getWriteString() {
        return this.writeString;
    }

    public void setWriteString(String writeString) {
        this.writeString = writeString;
    }

    public boolean isPassEmptyLine() {
        return this.passEmptyLine;
    }

    public void setPassEmptyLine(boolean passEmptyLine) {
        this.passEmptyLine = passEmptyLine;
    }

    public boolean isWriteParentheses() {
        return this.writeParentheses;
    }

    public void setWriteParentheses(boolean writeParentheses) {
        this.writeParentheses = writeParentheses;
    }

    public GeneratorTemplatesFilterIn getInFilter() {
        return this.inFilter;
    }

    public void setInFilter(GeneratorTemplatesFilterIn inFilter) {
        this.inFilter = inFilter;
    }

    protected String performInFilter(String ch) {
        String[] all;
        if (ch.matches("generator option: *passEmptyLine *= *(true|false)")) {
            this.passEmptyLine = "true".equalsIgnoreCase(ch.substring(ch.length() - 4));
            return "";
        }
        if (ch.matches("generator option: *writeString *= *.*")) {
            this.writeString = ch.replaceAll("generator option: *writeString *= *(.*)", "$1");
            return "";
        }
        if (ch.matches("generator option: *parentheses *= *(true|false)")) {
            this.writeParentheses = "true".equalsIgnoreCase(ch.substring(ch.length() - 4));
            return "";
        }
        if (this.passEmptyLine && ch.length() > 0 && (all = ch.split("\n")).length > 0) {
            int len;
            if (all[all.length - 1].matches("\\s*")) {
                len = ch.length() - all[all.length - 1].length() - 1;
                ch = ch.substring(0, Math.max(len, 0));
            }
            if (all[0].matches("\\s*")) {
                len = all[0].length() + 1;
                ch = ch.substring(Math.min(ch.length(), len));
            }
        }
        String resultInFilter = this.inFilter.parse(ch) + this.inFilter.flush();
        String result = this.getWriteString();
        if (this.writeParentheses) {
            result = result + "(";
        }
        result = result + "\"" + resultInFilter + "\"";
        if (this.writeParentheses) {
            result = result + ");";
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("writeParentheses = " + this.writeParentheses));
        }
        return result;
    }

    protected String performOutFilter(String ch) {
        return ch;
    }

    protected String getHeader() {
        return "/*{";
    }

    protected String getFooter() {
        return "}*/";
    }

    public static void main(String[] args) {
        GeneratorTemplatesFilter filter = new GeneratorTemplatesFilter();
        String res = filter.parse("   public void generatePackageStatement(Writer output, ObjectModelClassifier clazz) throws IOException {\n/*{\n package <%=clazz.getPackageName()%>.persistence.jdo; \n}*/ }");
        System.out.println(res);
        res = filter.flush();
        System.out.println(res);
    }
}

