/* *##% Graphical Widget
 * Copyright (C) 2004 - 2009 CodeLutin
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 *
 * You should have received a copy of the GNU General Lesser Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>. ##%*/

package org.nuiton.widget.editor;

import static org.nuiton.i18n.I18n._;

import java.awt.BorderLayout;
import java.awt.Font;
import java.io.File;

import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.CaretListener;
import javax.swing.event.DocumentListener;

/**
 * Editor used when the have no file to edit
 * 
 * @author poussin
 * @version $Revision: 254 $
 *
 * Last update: $Date: 2010-04-10 01:13:11 +0200 (sam., 10 avril 2010) $
 * by : $Author: tchemit $
 */
public class NullEditor extends JPanel implements EditorInterface {

    /** serialVersionUID. */
    private static final long serialVersionUID = -3451624841247752762L;

    public NullEditor() {
        setLayout(new BorderLayout());
        JLabel noFileLabel = new JLabel(_("nuitonwidgets.message.nofile"), JLabel.CENTER);
        noFileLabel.setFont(noFileLabel.getFont().deriveFont(Font.ITALIC));
        add(noFileLabel, BorderLayout.CENTER);
    }

    /*
     * @see org.nuiton.widget.editor.EditorInterface#addDocumentListener(javax.swing.event.DocumentListener)
     */
    @Override
    public void addDocumentListener(DocumentListener listener) {
    }

    /*
     * @see org.nuiton.widget.editor.EditorInterface#removeDocumentListener(javax.swing.event.DocumentListener)
     */
    @Override
    public void removeDocumentListener(DocumentListener listener) {
    }

    /*
     * @see org.nuiton.widget.editor.EditorInterface#addCaretListener(javax.swing.event.CaretListener)
     */
    @Override
    public void addCaretListener(CaretListener listener) {
        
    }

    /*
     * @see org.nuiton.widget.editor.EditorInterface#removeCaretListener(javax.swing.event.CaretListener)
     */
    @Override
    public void removeCaretListener(CaretListener listener) {
        
    }

    /*
     * @see org.nuiton.widget.editor.EditorInterface#accept(java.io.File)
     */
    @Override
    public boolean accept(File file) {
        return false;
    }

    /**
     * when there is no file opened, the file is not modified.
     * 
     * @return return false
     */
    @Override
    public boolean isModified() {
        return false;
    }

    /**
     * Do nothing, can't open file, on Null editor.
     * 
     * @param file the file to open
     * @return this
     */
    @Override
    public boolean open(File file) {
        // nothing to do
        return true;
    }

    /**
     * Do nothing, can't save file, on Null editor
     * 
     * @param file the file to open
     * @return this
     */
    @Override
    public boolean saveAs(File file) {
        // nothing to do
        return true;
    }

    /*
     * @see org.nuiton.widget.editor.EditorInterface#getText()
     */
    @Override
    public String getText() {
        String result = "";
        return result;
    }

    /*
     * @see org.nuiton.widget.editor.EditorInterface#setText(java.lang.String)
     */
    @Override
    public void setText(String text) {
    }

    /*
     * @see org.nuiton.widget.editor.EditorInterface#copy()
     */
    @Override
    public void copy() {
        
    }

    /*
     * @see org.nuiton.widget.editor.EditorInterface#cut()
     */
    @Override
    public void cut() {
        
    }

    /*
     * @see org.nuiton.widget.editor.EditorInterface#paste()
     */
    @Override
    public void paste() {
        
    }
}
