/* *##% Graphical Widget
 * Copyright (C) 2004 - 2008 CodeLutin
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 *
 * You should have received a copy of the GNU General Lesser Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>. ##%*/

/* *
 * ApplicationAction.java
 *
 * Created: Nov 22, 2004
 *
 * @author C�dric Pineau <pineau@codelutin.com>
 * @version $Revision: 254 $
 *
 * Last update : $Date: 2010-04-10 01:13:11 +0200 (sam., 10 avril 2010) $
 * by : $Author: tchemit $
 */

package org.nuiton.widget;

import java.util.List;

import javax.swing.AbstractAction;

/**
 * 
 */
public abstract class ApplicationAction extends AbstractAction {

    private String _shortText = null;

    public ApplicationAction(String shortText, String description,
            String iconId, char mnemonic, String accelerator) {
        super(description, IconFactory.getIcon(iconId));
        setShortText(shortText);
    }

    protected String getShortText() {
        return this._shortText;
    }

    protected void setShortText(String shortText) {
        this._shortText = shortText;
    }

    protected List<?> arguments = null;

    public List<?> getArguments() {
        return arguments;
    }

    public void setArguments(List<?> arguments) {
        this.arguments = arguments;
    }
}
