/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.validator.bean.simple;

import com.google.common.collect.Lists;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.nuiton.validator.NuitonValidatorScope;
import org.nuiton.validator.bean.SimpleBean;
import org.nuiton.validator.bean.simple.SimpleBeanValidator;
import org.nuiton.validator.bean.simple.SimpleBeanValidatorEvent;
import org.nuiton.validator.bean.simple.SimpleBeanValidatorListener;

@Deprecated
public class SimpleBeanValidatorTest {
    private static final Log log = LogFactory.getLog(SimpleBeanValidatorTest.class);
    protected SimpleBeanValidator<SimpleBean> validator;
    protected SimpleBean bean;
    ValidatorListenerImpl fatalListener;
    ValidatorListenerImpl errorListener;
    ValidatorListenerImpl warningListener;
    ValidatorListenerImpl infoListener;
    private static final String STRING_VALUE_FATAL = "stringValue.fatal";
    private static final String STRING_VALUE_ERROR = "stringValue.error";
    private static final String STRING_VALUE_WARNING = "stringValue.warning";
    private static final String INT_VALUE_FATAL = "intValue.fatal";
    private static final String INT_VALUE_ERROR = "intValue.error";
    private static final String INT_VALUE_INFO = "intValue.info";

    @Before
    public void setUp() {
        this.bean = new SimpleBean();
    }

    protected void prepareValidator(String context) {
        this.validator = SimpleBeanValidator.newValidator(SimpleBean.class, (String)context, (NuitonValidatorScope[])new NuitonValidatorScope[0]);
        this.fatalListener = new ValidatorListenerImpl(NuitonValidatorScope.FATAL);
        this.validator.addSimpleBeanValidatorListener((SimpleBeanValidatorListener)this.fatalListener);
        this.errorListener = new ValidatorListenerImpl(NuitonValidatorScope.ERROR);
        this.validator.addSimpleBeanValidatorListener((SimpleBeanValidatorListener)this.errorListener);
        this.warningListener = new ValidatorListenerImpl(NuitonValidatorScope.WARNING);
        this.validator.addSimpleBeanValidatorListener((SimpleBeanValidatorListener)this.warningListener);
        this.infoListener = new ValidatorListenerImpl(NuitonValidatorScope.INFO);
        this.validator.addSimpleBeanValidatorListener((SimpleBeanValidatorListener)this.infoListener);
    }

    @After
    public void tearDown() {
        this.bean = null;
        if (this.validator != null) {
            this.validator.setBean(null);
            this.validator = null;
        }
    }

    @Test(expected=IllegalStateException.class)
    public void testValidateWithBad() {
        this.prepareValidator("marchepo");
    }

    @Test
    public void validate() {
        this.prepareValidator(null);
        this.assertMessages(this.fatalListener, new String[0]);
        this.assertMessages(this.errorListener, new String[0]);
        this.assertMessages(this.warningListener, new String[0]);
        this.assertMessages(this.infoListener, new String[0]);
        if (log.isDebugEnabled()) {
            log.debug((Object)"-----------------------------------------------");
        }
        this.validator.setBean((Object)this.bean);
        this.assertMessages(this.fatalListener, STRING_VALUE_FATAL, INT_VALUE_FATAL);
        this.assertMessages(this.errorListener, STRING_VALUE_ERROR, INT_VALUE_ERROR);
        this.assertMessages(this.warningListener, STRING_VALUE_WARNING);
        this.assertMessages(this.infoListener, INT_VALUE_INFO);
        if (log.isDebugEnabled()) {
            log.debug((Object)"-----------------------------------------------");
        }
        this.bean.setStringValue("one");
        this.assertMessages(this.fatalListener, STRING_VALUE_FATAL, INT_VALUE_FATAL);
        this.assertMessages(this.errorListener, INT_VALUE_ERROR);
        this.assertMessages(this.warningListener, STRING_VALUE_WARNING);
        this.assertMessages(this.infoListener, INT_VALUE_INFO);
        if (log.isDebugEnabled()) {
            log.debug((Object)"-----------------------------------------------");
        }
        this.bean.setStringValue("oneone");
        this.assertMessages(this.fatalListener, STRING_VALUE_FATAL, INT_VALUE_FATAL);
        this.assertMessages(this.errorListener, INT_VALUE_ERROR);
        this.assertMessages(this.warningListener, new String[0]);
        this.assertMessages(this.infoListener, INT_VALUE_INFO);
        if (log.isDebugEnabled()) {
            log.debug((Object)"-----------------------------------------------");
        }
        this.bean.setIntValue(1);
        this.assertMessages(this.fatalListener, STRING_VALUE_FATAL, INT_VALUE_FATAL);
        this.assertMessages(this.errorListener, new String[0]);
        this.assertMessages(this.warningListener, new String[0]);
        this.assertMessages(this.infoListener, INT_VALUE_INFO);
        if (log.isDebugEnabled()) {
            log.debug((Object)"-----------------------------------------------");
        }
        this.bean.setIntValue(10);
        this.assertMessages(this.fatalListener, STRING_VALUE_FATAL, INT_VALUE_FATAL);
        this.assertMessages(this.errorListener, new String[0]);
        this.assertMessages(this.warningListener, new String[0]);
        this.assertMessages(this.infoListener, new String[0]);
        if (log.isDebugEnabled()) {
            log.debug((Object)"-----------------------------------------------");
        }
        this.bean.setStringValue(null);
        this.bean.setIntValue(0);
        this.assertMessages(this.fatalListener, STRING_VALUE_FATAL, INT_VALUE_FATAL);
        this.assertMessages(this.errorListener, STRING_VALUE_ERROR, INT_VALUE_ERROR);
        this.assertMessages(this.warningListener, STRING_VALUE_WARNING);
        this.assertMessages(this.infoListener, INT_VALUE_INFO);
        if (log.isDebugEnabled()) {
            log.debug((Object)"-----------------------------------------------");
        }
        this.bean.setStringValue("5");
        this.bean.setIntValue(5);
        this.assertMessages(this.fatalListener, new String[0]);
        this.assertMessages(this.errorListener, new String[0]);
        this.assertMessages(this.warningListener, STRING_VALUE_WARNING);
        this.assertMessages(this.infoListener, INT_VALUE_INFO);
    }

    @Test
    public void convert() {
        this.prepareValidator(null);
        this.assertMessages(this.errorListener, new String[0]);
        this.assertMessages(this.warningListener, new String[0]);
        this.assertMessages(this.infoListener, new String[0]);
        if (log.isDebugEnabled()) {
            log.debug((Object)"-----------------------------------------------");
        }
        this.validator.setBean((Object)this.bean);
        this.assertMessages(this.fatalListener, STRING_VALUE_FATAL, INT_VALUE_FATAL);
        this.assertMessages(this.errorListener, STRING_VALUE_ERROR, INT_VALUE_ERROR);
        this.assertMessages(this.warningListener, STRING_VALUE_WARNING);
        this.assertMessages(this.infoListener, INT_VALUE_INFO);
        if (log.isDebugEnabled()) {
            log.debug((Object)"-----------------------------------------------");
        }
        Object value = this.validator.convert("intValue", "abc", Class.class);
        Assert.assertNull((Object)value);
        this.assertMessages(this.fatalListener, STRING_VALUE_FATAL, INT_VALUE_FATAL);
        this.assertMessages(this.errorListener, STRING_VALUE_ERROR, "error.convertor.class");
        this.assertMessages(this.warningListener, STRING_VALUE_WARNING);
        this.assertMessages(this.infoListener, INT_VALUE_INFO);
        if (log.isDebugEnabled()) {
            log.debug((Object)"-----------------------------------------------");
        }
        this.bean.setStringValue("one");
        this.assertMessages(this.fatalListener, STRING_VALUE_FATAL, INT_VALUE_FATAL);
        this.assertMessages(this.errorListener, "error.convertor.class");
        this.assertMessages(this.warningListener, STRING_VALUE_WARNING);
        this.assertMessages(this.infoListener, INT_VALUE_INFO);
        if (log.isDebugEnabled()) {
            log.debug((Object)"-----------------------------------------------");
        }
        value = this.validator.convert("intValue", "3", Integer.class);
        this.bean.setIntValue((Integer)value);
        this.assertMessages(this.fatalListener, STRING_VALUE_FATAL, INT_VALUE_FATAL);
        this.assertMessages(this.errorListener, new String[0]);
        this.assertMessages(this.warningListener, STRING_VALUE_WARNING);
        this.assertMessages(this.infoListener, INT_VALUE_INFO);
        if (log.isDebugEnabled()) {
            log.debug((Object)"-----------------------------------------------");
        }
        this.bean.setIntValue(-1);
        this.assertMessages(this.fatalListener, STRING_VALUE_FATAL, INT_VALUE_FATAL);
        this.assertMessages(this.errorListener, INT_VALUE_ERROR);
        this.assertMessages(this.warningListener, STRING_VALUE_WARNING);
        this.assertMessages(this.infoListener, INT_VALUE_INFO);
        if (log.isDebugEnabled()) {
            log.debug((Object)"-----------------------------------------------");
        }
    }

    void assertMessages(ValidatorListenerImpl listener, String ... expected) {
        List<String> actual = listener.getMessages();
        Assert.assertEquals((String)(" shoudl have " + Arrays.toString(expected) + " but had " + actual), (long)expected.length, (long)actual.size());
        for (String m : expected) {
            Assert.assertEquals((String)("could not find " + m + " in " + actual), (Object)true, (Object)actual.contains(m));
        }
    }

    static class ValidatorListenerImpl
    implements SimpleBeanValidatorListener {
        final NuitonValidatorScope scope;
        List<String> messages = Lists.newArrayList();

        public ValidatorListenerImpl(NuitonValidatorScope scope) {
            this.scope = scope;
        }

        public List<String> getMessages() {
            return this.messages;
        }

        public void onFieldChanged(SimpleBeanValidatorEvent event) {
            if (this.scope == event.getScope()) {
                Object[] messagesToAdd;
                Object[] messagesToDelete = event.getMessagesToDelete();
                if (messagesToDelete != null && messagesToDelete.length > 0) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)(event.getScope() + " messages to delete : " + Arrays.toString(messagesToDelete)));
                    }
                    for (Object m : messagesToDelete) {
                        this.messages.remove(m);
                    }
                }
                if ((messagesToAdd = event.getMessagesToAdd()) != null && messagesToAdd.length > 0) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)(event.getScope() + " messages to add : " + Arrays.toString(messagesToAdd)));
                    }
                    this.messages.addAll(Arrays.asList(messagesToAdd));
                }
            }
        }
    }
}

