/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.validator.xwork2.field;

import com.opensymphony.xwork2.validator.ValidationException;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.nuiton.validator.xwork2.field.NuitonFieldValidatorSupport;

public class FrenchSiretFieldValidator
extends NuitonFieldValidatorSupport {
    protected static final String SIRET_REGEXP = "[0-9]{14}";
    protected static final Pattern p = Pattern.compile("[0-9]{14}");

    @Override
    public void validateWhenNotSkip(Object object) throws ValidationException {
        String siret;
        String fieldName = this.getFieldName();
        Object value = this.getFieldValue(fieldName, object);
        if (value == null) {
            return;
        }
        if (value.getClass().isArray()) {
            siret = "";
            for (int i = 0; i < Array.getLength(value); ++i) {
                siret = siret + String.valueOf(Array.get(value, i));
            }
        } else if (value instanceof Collection) {
            siret = "";
            for (Object o : (Collection)value) {
                siret = siret + String.valueOf(o);
            }
        } else {
            siret = String.valueOf(value);
        }
        if (StringUtils.isEmpty((CharSequence)siret)) {
            return;
        }
        Matcher m = p.matcher(siret = siret.replaceAll(" ", ""));
        if (!m.matches() || !FrenchSiretFieldValidator.luhnChecksum(siret)) {
            this.addFieldError(fieldName, object);
        }
    }

    public String getValidatorType() {
        return "frenchSiret";
    }

    public static boolean luhnChecksum(String siret) {
        char[] tab = siret.toCharArray();
        int sum = 0;
        for (int i = tab.length - 1; i >= 0; --i) {
            int n = FrenchSiretFieldValidator.getDigit(tab[i]);
            if ((n *= (i + 1) % 2 + 1) > 9) {
                n -= 9;
            }
            sum += n;
        }
        boolean result = sum % 10 == 0;
        return result;
    }

    public static int getDigit(char c) {
        int result = 0;
        result = c >= '0' && c <= '9' ? c - 48 : (c >= 'A' && c <= 'Z' ? c - 65 + 10 : c - 97 + 10);
        return result;
    }
}

