/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.i18n.init;

import java.net.URL;
import java.nio.charset.Charset;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18nUtil;
import org.nuiton.i18n.bundle.I18nBundle;
import org.nuiton.i18n.bundle.I18nBundleEntry;
import org.nuiton.i18n.bundle.I18nBundleUtil;
import org.nuiton.i18n.format.I18nMessageFormatter;

public abstract class I18nInitializer {
    private static final Log log = LogFactory.getLog(I18nInitializer.class);
    protected Charset encoding = I18nUtil.DEFAULT_CHARSET;
    protected I18nMessageFormatter messageFormatter = I18nUtil.DEFAULT_MESSAGE_FORMATTER;
    protected boolean missingKeyReturnNull = false;

    protected I18nInitializer() {
    }

    public abstract I18nBundle[] resolvBundles() throws Exception;

    public I18nBundle[] resolvBundles(URL ... urls) throws Exception {
        List<I18nBundle> bundles = I18nBundleUtil.detectBundles(urls);
        I18nBundle[] result = bundles.toArray(new I18nBundle[bundles.size()]);
        if (log.isInfoEnabled()) {
            I18nBundleEntry[] entries = I18nBundleUtil.getBundleEntries(result);
            log.info(bundles.size() + " bundle(s) found, in " + entries.length + " file(s).");
        }
        return result;
    }

    public Charset getEncoding() {
        return this.encoding;
    }

    public void setEncoding(Charset encoding) throws NullPointerException {
        if (encoding == null) {
            throw new NullPointerException("Can not set a null encoding");
        }
        this.encoding = encoding;
    }

    public I18nMessageFormatter getMessageFormatter() {
        return this.messageFormatter;
    }

    public void setMessageFormatter(I18nMessageFormatter messageFormatter) throws NullPointerException {
        if (messageFormatter == null) {
            throw new NullPointerException("Can not set a null message formatter");
        }
        this.messageFormatter = messageFormatter;
    }

    public boolean isMissingKeyReturnNull() {
        return this.missingKeyReturnNull;
    }

    public void setMissingKeyReturnNull(boolean missingKeyReturnNull) {
        this.missingKeyReturnNull = missingKeyReturnNull;
    }
}

