/*
 * #%L
 * Nuiton Utils :: Nuiton Utils
 * 
 * $Id: Decorator.java 2162 2011-08-04 12:48:03Z tchemit $
 * $HeadURL: http://svn.nuiton.org/svn/nuiton-utils/tags/nuiton-utils-2.6.9/nuiton-utils/src/main/java/org/nuiton/util/decorator/Decorator.java $
 * %%
 * Copyright (C) 2004 - 2011 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as 
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */
package org.nuiton.util.decorator;

import java.io.Serializable;

/**
 * A simple contract to define a String decorator on any java object.
 *
 * @param <O> the type of data to decorate
 * @author tchemit <chemit@codelutin.com>
 * @since 2.3
 */
public abstract class Decorator<O> implements Serializable {

    private static final long serialVersionUID = -1L;

    /** Type of the data to decorate */
    protected final Class<O> type;

    public Decorator(Class<O> type) throws NullPointerException {
        if (type == null) {
            throw new NullPointerException("type can not be null.");
        }
        this.type = type;
    }

    /**
     * @param bean the bean to decorate
     * @return the string value of the given bean
     */
    public abstract String toString(Object bean);

    public Class<O> getType() {
        return type;
    }

    /**
     * @return the internal type of object that can be decorated by this decorator.
     * @deprecated is remplaced by {@link #getType()} and will be removed soon
     */
    @Deprecated
    public Class<O> getInternalClass() {
        return getType();
    }
}
