/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.util;

import java.awt.Desktop;
import java.io.IOException;
import java.net.URI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DesktopUtil {
    private static Log log = LogFactory.getLog(DesktopUtil.class);

    public static void browse(URI uri) {
        block11: {
            try {
                if (Desktop.isDesktopSupported()) {
                    Desktop desktop = Desktop.getDesktop();
                    if (desktop.isSupported(Desktop.Action.BROWSE)) {
                        desktop.browse(uri);
                    } else if (log.isDebugEnabled()) {
                        log.debug((Object)"Browse operation not supported");
                    }
                } else if (log.isDebugEnabled()) {
                    log.debug((Object)"Desktop not supported");
                }
            }
            catch (IOException ioe) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Desktop API not supported, launching xdg-open");
                }
                ProcessBuilder pb = new ProcessBuilder("xdg-open", uri.toString());
                try {
                    pb.start();
                }
                catch (IOException e) {
                    if (!log.isDebugEnabled()) break block11;
                    log.debug((Object)"Could not launch browser, there is maybe no default browser configured on the system");
                }
            }
        }
    }
}

