/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.util;

import java.io.Serializable;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.RandomAccess;
import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.util.ArrayUtil;

public interface MatrixMap<E>
extends Iterable<E> {
    @Override
    public MatrixMapIterator<E> iterator();

    public MatrixMap<E> copy();

    public SemanticList[] getSemantics();

    public SemanticList getSemantic(int var1);

    public void setSemantic(int var1, List var2);

    public void setName(String var1);

    public String getName();

    public String[] getDimensionNames();

    public void setDimensionNames(String[] var1);

    public void setDimensionName(int var1, String var2);

    public String getDimensionName(int var1);

    public int getDimCount();

    public int[] getDim();

    public int getDim(int var1);

    public MatrixMap<E> map(MapFunction<E> var1);

    public E getValueIndex(int ... var1);

    public void setValueIndex(E var1, int ... var2);

    public E getValue(Object ... var1);

    public void setValue(E var1, Object ... var2);

    public boolean equals(MatrixMap var1);

    public boolean equalsValues(MatrixMap<E> var1);

    public String toStringGeneric();

    public boolean isValidCoordinates(Object[] var1);

    public MatrixMap paste(MatrixMap<E> var1);

    public MatrixMap<E> getSubMatrix(int var1, Object var2, int var3);

    public MatrixMap<E> getSubMatrix(int var1, Object ... var2);

    public MatrixMap<E> getSubMatrix(Object[] ... var1);

    public MatrixMap<E> reduce();

    public MatrixMap<E> reduceDims(int ... var1);

    public MatrixMap<E> reduce(int var1);

    public MatrixMap<E> extend(Object ... var1);

    public static interface MapFunction<E> {
        public E apply(E var1);
    }

    public static class Vector<E> {
        protected int capacity = 0;
        protected E defaultValue = null;
        protected int[] position;
        protected int positionSize = 0;
        protected ArrayList<E> data = new ArrayList();

        public Vector(int capacity) {
            this.capacity = capacity;
            this.position = new int[8];
            Arrays.fill(this.position, Integer.MAX_VALUE);
        }

        public Vector(int capacity, E defaultValue) {
            this(capacity);
            this.defaultValue = defaultValue;
        }

        public int size() {
            return this.capacity;
        }

        public E getMaxOccurrence() {
            Object result = this.defaultValue;
            Object[] tmp = this.data.toArray();
            if (this.capacity < 2 * tmp.length) {
                Arrays.sort(tmp);
                int max = 1;
                int count = 1;
                result = tmp[0];
                Object old = tmp[0];
                Object current = tmp[0];
                for (int i = 1; max < tmp.length - i + count && i < tmp.length; ++i) {
                    current = tmp[i];
                    if (current == old) {
                        ++count;
                        continue;
                    }
                    if (count > max) {
                        max = count;
                        result = old;
                    }
                    count = 1;
                    old = current;
                }
                if (count > max) {
                    max = count;
                    result = current;
                }
                if (max <= this.capacity - tmp.length) {
                    result = this.defaultValue;
                }
            }
            return result;
        }

        protected void checkPos(int pos) {
            if (pos < 0 || pos >= this.capacity) {
                throw new IllegalArgumentException("pos " + pos + " is not in [0, " + this.capacity + "]");
            }
        }

        public E getValue(int pos) {
            this.checkPos(pos);
            E result = this.defaultValue;
            int index = this.findIndex(pos);
            if (index >= 0) {
                result = this.data.get(index);
            }
            return result;
        }

        public void setValue(int pos, E value) {
            this.checkPos(pos);
            int index = this.findIndex(pos);
            if (index >= 0) {
                if (value == this.defaultValue) {
                    this.removeElementAt(index);
                    this.data.remove(index);
                } else {
                    this.data.set(index, value);
                }
            } else if (value != this.defaultValue) {
                index = -index - 1;
                this.addElementAt(index, pos);
                this.data.add(index, value);
            }
        }

        public boolean equals(Object o) {
            boolean result = false;
            if (o instanceof Vector) {
                Vector other = (Vector)o;
                result = Arrays.equals(this.position, other.position) && this.data.equals(other.data);
            }
            return result;
        }

        protected int findIndex(int pos) {
            return Arrays.binarySearch(this.position, pos);
        }

        protected void ensureCapacity(int mincap) {
            if (mincap > this.position.length) {
                int newcap = this.position.length * 3 / 2 + 1;
                int[] olddata = this.position;
                this.position = new int[newcap >= mincap ? newcap : mincap];
                System.arraycopy(olddata, 0, this.position, 0, this.positionSize);
                for (int i = this.positionSize; i < this.position.length; ++i) {
                    this.position[i] = Integer.MAX_VALUE;
                }
            }
        }

        protected void addElementAt(int index, int element) {
            this.ensureCapacity(this.positionSize + 1);
            int numtomove = this.positionSize - index;
            System.arraycopy(this.position, index, this.position, index + 1, numtomove);
            this.position[index] = element;
            ++this.positionSize;
        }

        protected int removeElementAt(int index) {
            int oldval = this.position[index];
            int numtomove = this.positionSize - index - 1;
            if (numtomove > 0) {
                System.arraycopy(this.position, index + 1, this.position, index, numtomove);
            }
            --this.positionSize;
            this.position[this.positionSize] = Integer.MAX_VALUE;
            return oldval;
        }

        public void paste(Vector<E> v) {
            this.capacity = v.capacity;
            this.defaultValue = v.defaultValue;
            this.positionSize = v.positionSize;
            this.position = new int[v.position.length];
            System.arraycopy(v.position, 0, this.position, 0, this.position.length);
            this.data.clear();
            this.data.addAll(v.data);
        }

        public void map(MapFunction<E> f) {
            this.defaultValue = f.apply(this.defaultValue);
            for (int i = this.data.size() - 1; i >= 0; --i) {
                E value = f.apply(this.data.get(i));
                if (value == this.defaultValue) {
                    this.removeElementAt(i);
                    this.data.remove(i);
                    continue;
                }
                this.data.set(i, value);
            }
        }
    }

    public static class MatrixIterator<E>
    implements Iterator<E> {
        protected Matrix<E> matrix = null;
        protected int pos = -1;

        public MatrixIterator(Matrix<E> matrix) {
            this.matrix = matrix;
            this.pos = -1;
        }

        @Override
        public boolean hasNext() {
            return this.pos + 1 < this.matrix.data.size();
        }

        @Override
        public E next() {
            if (this.hasNext()) {
                ++this.pos;
            } else {
                throw new NoSuchElementException();
            }
            E result = this.getValue();
            return result;
        }

        @Override
        public void remove() {
            this.setValue(null);
        }

        public E getValue() {
            return this.matrix.data.getValue(this.pos);
        }

        public void setValue(E value) {
            this.matrix.data.setValue(this.pos, value);
        }

        public int[] getCoordinates() {
            return this.matrix.linearToCoordinates(this.pos);
        }
    }

    public static class Matrix<E>
    implements Iterable<E> {
        protected int[] dimensions = null;
        protected Vector<E> data = null;
        protected int[] linearFactor = null;

        public Matrix(int[] dimensions) {
            this.checkDim(dimensions);
            this.dimensions = new int[dimensions.length];
            System.arraycopy(dimensions, 0, this.dimensions, 0, dimensions.length);
            this.linearFactor = new int[dimensions.length];
            this.linearFactor[this.linearFactor.length - 1] = 1;
            for (int i = this.linearFactor.length - 2; i >= 0; --i) {
                this.linearFactor[i] = this.linearFactor[i + 1] * dimensions[i + 1];
            }
            this.data = new Vector(this.linearFactor[0] * dimensions[0]);
        }

        public int getNbDim() {
            return this.dimensions.length;
        }

        public int getDim(int dim) {
            this.checkDim(dim);
            return this.dimensions[dim];
        }

        public int[] getDim() {
            return this.dimensions;
        }

        public E getValue(int[] pos) {
            int indice = this.coordonatesToLinear(pos);
            return this.data.getValue(indice);
        }

        public void setValue(int[] pos, E value) {
            int indice = this.coordonatesToLinear(pos);
            this.data.setValue(indice, value);
        }

        @Override
        public MatrixIterator<E> iterator() {
            return new MatrixIterator(this);
        }

        public void map(MapFunction f) {
            this.data.map(f);
        }

        protected int coordonatesToLinear(int[] coordonates) {
            this.checkPos(coordonates);
            int result = 0;
            for (int i = 0; i < this.linearFactor.length; ++i) {
                result += coordonates[i] * this.linearFactor[i];
            }
            return result;
        }

        protected int[] linearToCoordinates(int pos) {
            int[] result = new int[this.linearFactor.length];
            for (int i = 0; i < result.length; ++i) {
                result[i] = pos / this.linearFactor[i];
                pos -= result[i] * this.linearFactor[i];
            }
            return result;
        }

        protected void checkDim(int[] dim) {
            for (int i = 0; i < dim.length; ++i) {
                if (dim[i] > 0) continue;
                throw new IllegalArgumentException(String.format("Dimension %s is invalid %s", i, dim[i]));
            }
        }

        protected void checkDim(int dim) {
            if (dim < 0 || dim >= this.getNbDim()) {
                throw new IndexOutOfBoundsException(String.format("Invalid dimension %s max dimension is %s", dim, this.getNbDim()));
            }
        }

        protected void checkPos(int[] pos) {
            int[] dim = this.getDim();
            boolean result = dim.length == pos.length;
            for (int i = 0; result && i < dim.length; ++i) {
                result = 0 <= pos[i] && pos[i] < dim[i];
            }
            if (!result) {
                throw new NoSuchElementException(String.format("Invalid element asked %s for real dimension %s", Arrays.toString(pos), Arrays.toString(dim)));
            }
        }

        public String toString() {
            StringBuffer result = new StringBuffer();
            if (this.getNbDim() == 1) {
                result.append("matrix1D [");
                for (int i = 0; i < this.data.size(); ++i) {
                    result.append(this.data.getValue(i) + ",");
                }
                result.append("]");
            } else if (this.getNbDim() == 2) {
                int[] pos = new int[2];
                result.append("matrix2D [");
                for (int y = 0; y < this.getDim(1); ++y) {
                    result.append("\n");
                    int x = 0;
                    while (x < this.getDim(0)) {
                        pos[0] = x++;
                        pos[1] = y;
                        result.append(this.getValue(pos) + ",");
                    }
                }
                result.append("]");
            } else {
                int i;
                result.append("dimensions = [\n");
                for (i = 0; i < this.dimensions.length; ++i) {
                    result.append(this.dimensions[i] + ",");
                }
                result.append("\n]\nmatrice = [\n");
                for (i = 0; i < this.data.size(); ++i) {
                    result.append(this.data.getValue(i) + ",");
                }
                result.append("\n]\nlinearFactor = [\n");
                for (i = 0; i < this.linearFactor.length; ++i) {
                    result.append(this.linearFactor[i] + ",");
                }
                result.append("\n]\n");
            }
            return result.toString();
        }

        public boolean equals(Object o) {
            if (o instanceof Matrix) {
                Matrix other = (Matrix)o;
                return this == o || Arrays.equals(this.dimensions, other.dimensions) && this.data.equals(other.data);
            }
            return false;
        }
    }

    public static class SubMatrix<E>
    extends AbstractMatrixMap<E> {
        protected MatrixMap<E> matrix = null;
        protected DimensionConverter converter = null;

        public SubMatrix(MatrixMap<E> matrix, int dim, int start, int nb) {
            super(matrix.getName(), matrix.getDimensionNames(), (List[])matrix.getSemantics());
            this.matrix = matrix;
            this.converter = new ShiftConverter(dim, start, nb);
            this.setSemantic(dim, this.getSemantic(dim).subList(start, start + nb));
            this.getDim()[dim] = nb;
        }

        public SubMatrix(MatrixMap<E> matrix, int dim, int[] elem) {
            super(matrix.getName(), matrix.getDimensionNames(), (List[])matrix.getSemantics());
            this.matrix = matrix;
            this.converter = new MappingConverter(dim, elem);
            SemanticList oldSemantic = this.getSemantic(dim);
            LinkedList newSemantic = new LinkedList();
            for (int i = 0; i < elem.length; ++i) {
                newSemantic.add(oldSemantic.get(elem[i]));
            }
            this.setSemantic(dim, newSemantic);
            this.getDim()[dim] = elem.length;
        }

        @Override
        public MatrixMapIterator<E> iterator() {
            return new SubMatrixIterator(this);
        }

        @Override
        public E getValueIndex(int ... coordinates) {
            return this.matrix.getValueIndex(this.converter.convertCoordinates(coordinates));
        }

        @Override
        public void setValueIndex(E value, int ... coordinates) {
            this.matrix.setValueIndex(value, this.converter.convertCoordinates(coordinates));
        }

        protected static class MappingConverter
        implements DimensionConverter {
            private static final long serialVersionUID = -6367416559713556559L;
            protected int dim;
            protected int[] elem = null;

            public MappingConverter(int dim, int[] elem) {
                this.dim = dim;
                this.elem = new int[elem.length];
                System.arraycopy(elem, 0, this.elem, 0, elem.length);
            }

            @Override
            public int[] convertCoordinates(int[] coordinates) {
                int[] result = null;
                if (coordinates[this.dim] >= this.elem.length) {
                    throw new NoSuchElementException("L'indice est sup\u00e9rieur au nombre d'\u00e9lements de la sous matrice pour cette dimension.");
                }
                result = new int[coordinates.length];
                System.arraycopy(coordinates, 0, result, 0, result.length);
                result[this.dim] = this.elem[coordinates[this.dim]];
                return result;
            }
        }

        protected static class ShiftConverter
        implements DimensionConverter {
            private static final long serialVersionUID = 1L;
            protected int dim;
            protected int start;
            protected int nb;

            public ShiftConverter(int dim, int start, int nb) {
                this.dim = dim;
                this.start = start;
                this.nb = nb;
            }

            @Override
            public int[] convertCoordinates(int[] coordinates) {
                int[] result = null;
                if (coordinates[this.dim] >= this.nb) {
                    throw new NoSuchElementException("L'indice est sup\u00e9rieur au nombre d'\u00e9lement de la sous matrice pour cette dimension.");
                }
                result = new int[coordinates.length];
                System.arraycopy(coordinates, 0, result, 0, result.length);
                result[this.dim] = result[this.dim] + this.start;
                return result;
            }
        }

        protected static interface DimensionConverter
        extends Serializable {
            public int[] convertCoordinates(int[] var1);
        }

        protected class SubMatrixIterator<E>
        implements MatrixMapIterator<E> {
            protected SubMatrix<E> subMatrix = null;
            protected int[] cpt = null;
            protected int[] last = null;

            public SubMatrixIterator(SubMatrix<E> subMatrix2) {
                this.subMatrix = subMatrix2;
                this.cpt = new int[subMatrix2.getDimCount()];
                this.cpt[this.cpt.length - 1] = -1;
                this.last = new int[subMatrix2.getDimCount()];
                for (int i = 0; i < this.last.length; ++i) {
                    this.last[i] = subMatrix2.getDim(i) - 1;
                }
            }

            @Override
            public boolean hasNext() {
                return !Arrays.equals(this.cpt, this.last);
            }

            @Override
            public E next() {
                int ret = 1;
                int[] dim = SubMatrix.this.getDim();
                for (int i = this.cpt.length - 1; i >= 0; --i) {
                    this.cpt[i] = this.cpt[i] + ret;
                    ret = this.cpt[i] / dim[i];
                    this.cpt[i] = this.cpt[i] % dim[i];
                }
                E result = this.getValue();
                return result;
            }

            @Override
            public void remove() {
                this.setValue(null);
            }

            @Override
            public int[] getCoordinates() {
                return this.cpt;
            }

            @Override
            public Object[] getSemanticsCoordinates() {
                int[] coordinates = this.getCoordinates();
                Object[] result = MatrixHelper.dimensionToSemantics(this.subMatrix.getSemantics(), coordinates);
                return result;
            }

            @Override
            public E getValue() {
                return this.subMatrix.getValueIndex(this.getCoordinates());
            }

            @Override
            public void setValue(E value) {
                this.subMatrix.setValue(value, new Object[]{this.getCoordinates()});
            }
        }
    }

    public static abstract class AbstractMatrixMap<E>
    implements MatrixMap<E> {
        private static Log log = LogFactory.getLog(AbstractMatrixMap.class);
        protected String name = null;
        protected String[] dimNames = null;
        protected int[] dim = null;
        protected SemanticList[] semantics = null;

        protected void init(int[] dim) {
            this.dim = new int[dim.length];
            System.arraycopy(dim, 0, this.dim, 0, dim.length);
            this.semantics = new SemanticList[dim.length];
            this.dimNames = new String[dim.length];
        }

        protected AbstractMatrixMap(int[] dim) {
            this.init(dim);
            for (int i = 0; i < this.getDimCount(); ++i) {
                this.setSemantic(i, Collections.nCopies(dim[i], null));
            }
        }

        public AbstractMatrixMap(List ... semantics) {
            int i;
            int[] dim = new int[semantics.length];
            for (i = 0; i < dim.length; ++i) {
                dim[i] = semantics[i] == null ? 0 : semantics[i].size();
            }
            this.init(dim);
            for (i = 0; i < this.getDimCount(); ++i) {
                this.setSemantic(i, semantics[i]);
            }
        }

        protected AbstractMatrixMap(String name, int[] dim) {
            this(dim);
            this.setName(name);
        }

        protected AbstractMatrixMap(String name, int[] dim, String[] dimNames) {
            this(dim);
            this.setName(name);
            for (int i = 0; dimNames != null && i < dimNames.length; ++i) {
                this.setDimensionName(i, dimNames[i]);
            }
        }

        public AbstractMatrixMap(String name, List ... semantics) {
            this(semantics);
            this.setName(name);
        }

        public AbstractMatrixMap(String name, String[] dimNames, List ... semantics) {
            this(name, semantics);
            for (int i = 0; dimNames != null && i < dimNames.length; ++i) {
                this.setDimensionName(i, dimNames[i]);
            }
        }

        public AbstractMatrixMap(MatrixMap<E> matrix) {
            this(matrix.getName(), matrix.getDimensionNames(), (List[])matrix.getSemantics());
            this.pasteIndex(matrix);
        }

        @Override
        public MatrixMap<E> copy() {
            MatrixMapFixed result = new MatrixMapFixed(this);
            return result;
        }

        public MatrixMap clone() {
            return this.copy();
        }

        @Override
        public SemanticList[] getSemantics() {
            return this.semantics;
        }

        @Override
        public SemanticList getSemantic(int dim) {
            return this.semantics[dim];
        }

        @Override
        public void setSemantic(int dim, List sem) {
            SemanticList l;
            this.semantics[dim] = l = new SemanticList(sem);
        }

        @Override
        public void setName(String name) {
            this.name = name;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public String[] getDimensionNames() {
            return this.dimNames;
        }

        @Override
        public void setDimensionNames(String[] names) {
            for (int i = 0; names != null && i < names.length; ++i) {
                this.setDimensionName(i, names[i]);
            }
        }

        @Override
        public void setDimensionName(int dim, String name) {
            this.dimNames[dim] = name;
        }

        @Override
        public String getDimensionName(int dim) {
            return this.dimNames[dim];
        }

        @Override
        public int getDimCount() {
            return this.dim.length;
        }

        @Override
        public int[] getDim() {
            return this.dim;
        }

        @Override
        public int getDim(int d) {
            return this.dim[d];
        }

        @Override
        public MatrixMap<E> map(MapFunction<E> f) {
            MatrixMapIterator<E> i = this.iterator();
            while (i.hasNext()) {
                i.setValue(f.apply(i.next()));
            }
            return this;
        }

        @Override
        public E getValue(Object ... coordinates) {
            if (coordinates.length == 0) {
                throw new IllegalArgumentException("Coordinates must not be empty");
            }
            int[] intCoordinates = MatrixHelper.semanticsToDimension(this.getSemantics(), coordinates);
            Object result = this.getValueIndex(intCoordinates);
            return result;
        }

        @Override
        public void setValue(E value, Object ... coordinates) {
            if (coordinates.length == 0) {
                throw new IllegalArgumentException("Coordinates must not be empty");
            }
            int[] intCoordinates = MatrixHelper.semanticsToDimension(this.getSemantics(), coordinates);
            this.setValueIndex(value, intCoordinates);
        }

        public boolean equals(Object o) {
            return o instanceof MatrixMap && this.equals((MatrixMap)o);
        }

        @Override
        public boolean equals(MatrixMap mat) {
            boolean result = true;
            result = result && this.getName().equals(mat.getName());
            result = result && this.equalsValues(mat);
            for (int i = 0; result && i < this.getDimCount(); ++i) {
                String dimName1 = this.getDimensionName(i);
                String dimName2 = mat.getDimensionName(i);
                result = ObjectUtils.equals((Object)dimName1, (Object)dimName2);
                if (log.isTraceEnabled()) {
                    log.trace((Object)("dimName1(" + dimName1 + ")==dimName2(" + dimName2 + ")=" + result));
                }
                SemanticList sem1 = this.getSemantic(i);
                SemanticList sem2 = mat.getSemantic(i);
                boolean bl = result = result && ObjectUtils.equals((Object)sem1, (Object)sem2);
                if (!log.isTraceEnabled()) continue;
                log.trace((Object)("sem1(" + sem1 + ")==sem2(" + sem2 + ")=" + result));
            }
            if (log.isTraceEnabled()) {
                log.trace((Object)("result=" + result));
            }
            return result;
        }

        @Override
        public boolean equalsValues(MatrixMap mat) {
            boolean result = true;
            result = result && MatrixHelper.sameDimension(this.getDim(), mat.getDim());
            MatrixMapIterator i = mat.iterator();
            while (result && i.hasNext()) {
                Object v2;
                Object v1 = i.next();
                boolean bl = result = v1 == (v2 = this.getValueIndex(i.getCoordinates()));
                if (!log.isTraceEnabled()) continue;
                log.trace((Object)("v1(" + v1 + ")==v2(" + v2 + ")=" + result));
            }
            return result;
        }

        public String toString() {
            int LENGTH = 10;
            StringBuilder result = new StringBuilder();
            if (this.getDimCount() == 1) {
                result.append(MatrixHelper.format(this.getName(), -LENGTH, "#NoNameMat"));
                result.append("(matrix1D)[\n");
                String dimName = this.getDimensionName(0);
                result.append(MatrixHelper.format(dimName, LENGTH, "#NoNameDim"));
                for (Object sem : this.getSemantic(0)) {
                    result.append(",");
                    result.append(MatrixHelper.format(sem, -LENGTH, null));
                }
                result.append(StringUtils.repeat((String)" ", (int)(LENGTH + 1)));
                int i = 0;
                while (i < this.getDim(0)) {
                    Object v = this.getValueIndex(i++);
                    result.append(MatrixHelper.format(v, -LENGTH, null) + ",");
                }
                result.append("\n]");
            } else if (this.getDimCount() == 2) {
                int[] pos = new int[2];
                result.append(MatrixHelper.format(this.getName(), -LENGTH, "#NoNameMat"));
                result.append("(matrix2D) [\n");
                result.append(StringUtils.repeat((String)" ", (int)(LENGTH + 1)));
                String dimNameX = this.getDimensionName(0);
                result.append(MatrixHelper.format(dimNameX, LENGTH, "#DimX"));
                result.append("\n");
                String dimNameY = this.getDimensionName(1);
                result.append(MatrixHelper.format(dimNameY, LENGTH, "#DimY"));
                result.append(" ");
                for (Object sem : this.getSemantic(0)) {
                    result.append(MatrixHelper.format(sem, -LENGTH, null));
                    result.append(",");
                }
                for (int y = 0; y < this.getDim(1); ++y) {
                    Object sem;
                    result.append("\n");
                    sem = this.getSemantic(1).get(y);
                    result.append(MatrixHelper.format(sem, LENGTH, null));
                    result.append(" ");
                    int x = 0;
                    while (x < this.getDim(0)) {
                        pos[0] = x++;
                        pos[1] = y;
                        Object v = this.getValueIndex(pos);
                        result.append(MatrixHelper.format(v, -LENGTH, null) + ",");
                    }
                }
                result.append("\n]");
            } else {
                result.append(this.toStringGeneric());
            }
            return result.toString();
        }

        @Override
        public String toStringGeneric() {
            StringBuilder result = new StringBuilder();
            result.append(MatrixHelper.format(this.getName(), 0, "#NoNameMat"));
            result.append("(matrix" + this.getDimCount() + "D)[\n");
            result.append("dimensions = [");
            for (int i = 0; i < this.getDim().length; ++i) {
                result.append(this.getDim()[i] + ",");
            }
            result.append("]\ndata = [");
            MatrixMapIterator i = this.iterator();
            while (i.hasNext()) {
                result.append(i.next() + ",");
            }
            result.append("]\n");
            return result.toString();
        }

        public boolean isValidCoordinates(int[] dim) {
            boolean result = this.getDimCount() == dim.length;
            for (int i = 0; result && i < dim.length; ++i) {
                result = 0 <= dim[i] && dim[i] < this.getDim(i);
            }
            return result;
        }

        @Override
        public boolean isValidCoordinates(Object[] semantics) {
            boolean result = this.getDimCount() == semantics.length;
            for (int i = 0; result && i < semantics.length; ++i) {
                SemanticList semantic = this.getSemantic(i);
                result = semantic.contains(semantics[i]);
            }
            return result;
        }

        public MatrixMap pasteIndex(MatrixMap<E> mat) {
            return this.paste(new int[this.getDimCount()], mat);
        }

        protected MatrixMap<E> paste(int[] origin, MatrixMap<E> mat) {
            if (mat != null) {
                MatrixMapIterator<E> mi = mat.iterator();
                while (mi.hasNext()) {
                    Object value = mi.next();
                    int[] coordinates = ArrayUtil.sum(origin, mi.getCoordinates());
                    if (!this.isValidCoordinates(coordinates)) continue;
                    this.setValueIndex(value, coordinates);
                }
            }
            return this;
        }

        @Override
        public MatrixMap<E> paste(MatrixMap<E> mat) {
            if (mat != null) {
                MatrixMapIterator<E> mi = mat.iterator();
                while (mi.hasNext()) {
                    Object value = mi.next();
                    Object[] sems = mi.getSemanticsCoordinates();
                    if (!this.isValidCoordinates(sems)) continue;
                    this.setValue(value, sems);
                }
            }
            return this;
        }

        public MatrixMap<E> getSubMatrix(int dim, int start, int nb) {
            if (dim < 0) {
                dim = this.getDimCount() + dim;
            }
            if (start < 0) {
                start = this.getDim(dim) + start;
            }
            if (nb <= 0) {
                nb = this.getDim(dim) - start;
            }
            return new SubMatrix(this, dim, start, nb);
        }

        @Override
        public MatrixMap<E> getSubMatrix(int dim, Object start, int nb) {
            int begin = MatrixHelper.indexOf(this.getSemantics(), dim, start);
            return this.getSubMatrix(dim, begin, nb);
        }

        public MatrixMap<E> getSubMatrixOnSemantic(int dim, Object ... elem) {
            MatrixMap<E> result = this.getSubMatrix(dim, elem);
            return result;
        }

        @Override
        public MatrixMap<E> getSubMatrix(int dim, Object ... elem) {
            int[] ielem = new int[elem.length];
            for (int i = 0; i < ielem.length; ++i) {
                ielem[i] = MatrixHelper.indexOf(this.getSemantics(), dim, elem[i]);
            }
            return this.getSubMatrix(dim, ielem);
        }

        @Override
        public MatrixMap<E> getSubMatrix(Object[] ... elems) {
            if (elems.length != this.dim.length) {
                throw new IllegalArgumentException(String.format("Can't get sub matrix with different dimension count (expected: %d, got %d)", this.dim.length, elems.length));
            }
            MatrixMap<E> result = this;
            for (int i = 0; i < elems.length; ++i) {
                if (elems[i] == null) continue;
                result = result.getSubMatrix(i, elems[i]);
            }
            return result;
        }

        public MatrixMap<E> getSubMatrix(int dim, int[] elem) {
            return new SubMatrix(this, dim, elem);
        }

        public MatrixMap<E> getSubMatrix(int[] ... elems) {
            if (elems.length != this.dim.length) {
                throw new IllegalArgumentException(String.format("Can't get sub matrix with different dimension count (expected: %d, got %d)", this.dim.length, elems.length));
            }
            SubMatrix result = this;
            for (int i = 0; i < elems.length; ++i) {
                if (elems[i] == null) continue;
                result = new SubMatrix(result, i, elems[i]);
            }
            return result;
        }

        @Override
        public MatrixMap<E> reduce() {
            return this.reduce(1);
        }

        @Override
        public MatrixMap<E> reduceDims(int ... dims) {
            Arrays.sort(dims);
            int[] correspondance = new int[this.getDimCount()];
            ArrayList<List> sem = new ArrayList<List>();
            ArrayList<String> dimName = new ArrayList<String>();
            int minNbDim = 1;
            for (int j = this.getDimCount() - 1; j >= 0; --j) {
                if (this.getDim(j) <= 1 && Arrays.binarySearch(dims, j) >= 0 && j >= minNbDim) continue;
                correspondance[sem.size()] = j;
                sem.add(this.getSemantic(j));
                dimName.add(this.getDimensionName(j));
                --minNbDim;
            }
            MatrixMap<E> result = this.reduce(dimName, sem, correspondance);
            return result;
        }

        @Override
        public MatrixMap<E> reduce(int minNbDim) {
            int[] correspondance = new int[this.getDimCount()];
            ArrayList<List> sem = new ArrayList<List>();
            ArrayList<String> dimName = new ArrayList<String>();
            for (int j = this.getDimCount() - 1; j >= 0; --j) {
                if (this.getDim(j) <= 1 && j >= minNbDim) continue;
                correspondance[sem.size()] = j;
                sem.add(this.getSemantic(j));
                dimName.add(this.getDimensionName(j));
                --minNbDim;
            }
            MatrixMap<E> result = this.reduce(dimName, sem, correspondance);
            return result;
        }

        protected MatrixMap<E> reduce(List<String> dimName, List<List> sem, int[] correspondance) {
            int nbDim = sem.size();
            List[] newSemantics = new List[nbDim];
            String[] newDimNames = new String[nbDim];
            int[] tmpcorrespondance = new int[nbDim];
            for (int i = 0; i < nbDim; ++i) {
                newSemantics[i] = sem.get(nbDim - 1 - i);
                newDimNames[i] = dimName.get(nbDim - 1 - i);
                tmpcorrespondance[i] = correspondance[nbDim - 1 - i];
            }
            correspondance = tmpcorrespondance;
            MatrixMapFixed result = new MatrixMapFixed(this.getName(), newDimNames, newSemantics);
            int[] newCoordinates = new int[result.getDimCount()];
            MatrixMapIterator mi = this.iterator();
            while (mi.hasNext()) {
                Object value = mi.next();
                int[] oldCoordinates = mi.getCoordinates();
                for (int i = 0; i < newCoordinates.length; ++i) {
                    newCoordinates[i] = oldCoordinates[correspondance[i]];
                }
                result.setValueIndex(value, newCoordinates);
            }
            return result;
        }

        @Override
        public MatrixMap<E> extend(Object ... sems) {
            String name = this.getName();
            String[] dimNames = this.getDimensionNames();
            List[] semantics = this.getSemantics();
            if (sems.length > semantics.length) {
                String[] newDimNames = new String[sems.length];
                System.arraycopy(dimNames, 0, newDimNames, 0, dimNames.length);
                dimNames = newDimNames;
                SemanticList[] newSems = new SemanticList[sems.length];
                System.arraycopy(semantics, 0, newSems, 0, semantics.length);
                semantics = newSems;
                for (int i = semantics.length; i < newSems.length; ++i) {
                    newSems[i] = new SemanticList();
                }
            }
            for (int i = 0; i < sems.length; ++i) {
                if (semantics[i].indexOf(sems[i]) != -1) continue;
                ((AbstractList)semantics[i]).add(sems[i]);
            }
            MatrixMap result = Factory.create(name, dimNames, semantics);
            result.paste(this);
            return result;
        }
    }

    public static class MatrixMapFixed<E>
    extends AbstractMatrixMap<E> {
        private static Log log = LogFactory.getLog(MatrixMapFixed.class);
        protected Matrix<E> matrix = null;

        public MatrixMapFixed(List ... semantics) {
            super(semantics);
        }

        public MatrixMapFixed(String name, List ... semantics) {
            this(semantics);
            this.setName(name);
        }

        public MatrixMapFixed(String name, String[] dimNames, List ... semantics) {
            this(name, semantics);
            for (int i = 0; dimNames != null && i < dimNames.length; ++i) {
                this.setDimensionName(i, dimNames[i]);
            }
        }

        public MatrixMapFixed(MatrixMap<E> matrix) {
            this(matrix.getName(), matrix.getDimensionNames(), (List[])matrix.getSemantics());
            this.pasteIndex(matrix);
        }

        protected Matrix<E> getMatrix() {
            if (this.matrix == null) {
                this.matrix = new Matrix(this.getDim());
            }
            return this.matrix;
        }

        @Override
        public MatrixMapIterator<E> iterator() {
            return new MatrixMapIteratorImpl(this.getMatrix().iterator(), this.getSemantics());
        }

        @Override
        public MatrixMap<E> map(MapFunction<E> f) {
            this.getMatrix().data.map(f);
            return this;
        }

        @Override
        public E getValueIndex(int ... coordinates) {
            if (coordinates.length == 0) {
                throw new IllegalArgumentException("Coordinates must not be empty");
            }
            return this.getMatrix().getValue(coordinates);
        }

        @Override
        public void setValueIndex(E value, int ... coordinates) {
            if (coordinates.length == 0) {
                throw new IllegalArgumentException("Coordinates must not be empty");
            }
            this.getMatrix().setValue(coordinates, value);
        }

        @Override
        public MatrixMap<E> paste(int[] origin, MatrixMap<E> mat) {
            if (mat != null) {
                boolean origin0 = true;
                for (int i = 0; i < origin.length && origin0; ++i) {
                    origin0 = origin0 && origin[i] == 0;
                }
                if (origin0 && mat instanceof MatrixMapFixed && Arrays.equals(mat.getDim(), this.getDim())) {
                    this.getMatrix().data.paste(((MatrixMapFixed)mat).getMatrix().data);
                } else {
                    super.paste(origin, mat);
                }
            }
            return this;
        }
    }

    public static class MatrixMapElastic<E>
    implements MatrixMap<E> {
        protected MatrixMap<E> internalMatrixMap;

        public MatrixMapElastic() {
            this.internalMatrixMap = Factory.create(new List[0]);
        }

        public MatrixMapElastic(MatrixMap<E> m) {
            this.setInternalMatrixMap(m);
        }

        public MatrixMap<E> getInternalMatrixMap() {
            return this.internalMatrixMap;
        }

        public void setInternalMatrixMap(MatrixMap<E> internalMatrixMap) {
            this.internalMatrixMap = internalMatrixMap;
        }

        @Override
        public MatrixMapIterator<E> iterator() {
            return this.getInternalMatrixMap().iterator();
        }

        @Override
        public MatrixMap<E> copy() {
            return this.getInternalMatrixMap().copy();
        }

        @Override
        public SemanticList[] getSemantics() {
            return this.getInternalMatrixMap().getSemantics();
        }

        @Override
        public SemanticList getSemantic(int dim) {
            return this.getInternalMatrixMap().getSemantic(dim);
        }

        @Override
        public void setSemantic(int dim, List sem) {
            this.getInternalMatrixMap().setSemantic(dim, sem);
        }

        @Override
        public void setName(String name) {
            this.getInternalMatrixMap().setName(name);
        }

        @Override
        public String getName() {
            return this.getInternalMatrixMap().getName();
        }

        @Override
        public String[] getDimensionNames() {
            return this.getInternalMatrixMap().getDimensionNames();
        }

        @Override
        public void setDimensionNames(String[] names) {
            this.getInternalMatrixMap().setDimensionNames(names);
        }

        @Override
        public void setDimensionName(int dim, String name) {
            this.getInternalMatrixMap().setDimensionName(dim, name);
        }

        @Override
        public String getDimensionName(int dim) {
            return this.getInternalMatrixMap().getDimensionName(dim);
        }

        @Override
        public int getDimCount() {
            return this.getInternalMatrixMap().getDimCount();
        }

        @Override
        public int[] getDim() {
            return this.getInternalMatrixMap().getDim();
        }

        @Override
        public int getDim(int d) {
            return this.getInternalMatrixMap().getDim(d);
        }

        @Override
        public MatrixMap<E> map(MapFunction<E> f) {
            return this.getInternalMatrixMap().map(f);
        }

        @Override
        public E getValueIndex(int ... coordinates) {
            return this.getInternalMatrixMap().getValueIndex(coordinates);
        }

        @Override
        public void setValueIndex(E value, int ... coordinates) {
            this.getInternalMatrixMap().setValueIndex(value, coordinates);
        }

        @Override
        public E getValue(Object ... coordinates) {
            return this.getInternalMatrixMap().getValue(coordinates);
        }

        @Override
        public void setValue(E value, Object ... coordinates) {
            if (!this.isValidCoordinates(coordinates)) {
                MatrixMap<E> newMatrixMap = this.getInternalMatrixMap().extend(coordinates);
                this.setInternalMatrixMap(newMatrixMap);
            }
            this.getInternalMatrixMap().setValue(value, coordinates);
        }

        public boolean equals(Object obj) {
            return this.getInternalMatrixMap().equals(obj);
        }

        @Override
        public boolean equals(MatrixMap mat) {
            return this.getInternalMatrixMap().equals(mat);
        }

        @Override
        public boolean equalsValues(MatrixMap<E> mat) {
            return this.getInternalMatrixMap().equalsValues(mat);
        }

        public String toString() {
            return this.getInternalMatrixMap().toString();
        }

        @Override
        public String toStringGeneric() {
            return this.getInternalMatrixMap().toStringGeneric();
        }

        @Override
        public boolean isValidCoordinates(Object[] semantics) {
            return this.getInternalMatrixMap().isValidCoordinates(semantics);
        }

        @Override
        public MatrixMap paste(MatrixMap<E> mat) {
            return this.getInternalMatrixMap().paste(mat);
        }

        @Override
        public MatrixMap<E> getSubMatrix(int dim, Object start, int nb) {
            return this.getInternalMatrixMap().getSubMatrix(dim, start, nb);
        }

        @Override
        public MatrixMap<E> getSubMatrix(int dim, Object ... elem) {
            return this.getInternalMatrixMap().getSubMatrix(dim, elem);
        }

        @Override
        public MatrixMap<E> getSubMatrix(Object[] ... elems) {
            return this.getInternalMatrixMap().getSubMatrix(elems);
        }

        @Override
        public MatrixMap<E> reduce() {
            return this.getInternalMatrixMap().reduce();
        }

        @Override
        public MatrixMap<E> reduceDims(int ... dims) {
            return this.getInternalMatrixMap().reduceDims(dims);
        }

        @Override
        public MatrixMap<E> reduce(int minNbDim) {
            return this.getInternalMatrixMap().reduce(minNbDim);
        }

        @Override
        public MatrixMap<E> extend(Object ... sems) {
            return this.getInternalMatrixMap().extend(sems);
        }
    }

    public static class SemanticList<T>
    extends AbstractList<T>
    implements RandomAccess {
        protected ArrayList<T> datas = null;
        protected Map<T, Integer> index = new HashMap<T, Integer>();

        public SemanticList() {
            this(new ArrayList());
        }

        public SemanticList(Collection<T> c) {
            this.datas = new ArrayList<T>(c);
        }

        @Override
        public T get(int index) {
            T result = this.datas.get(index);
            return result;
        }

        @Override
        public void add(int index, T element) {
            this.datas.add(index, element);
            this.index.clear();
        }

        @Override
        public T set(int index, T element) {
            T result = this.datas.set(index, element);
            this.index.clear();
            return result;
        }

        @Override
        public T remove(int index) {
            Object result = super.remove(index);
            this.index.clear();
            return (T)result;
        }

        @Override
        public int size() {
            int result = this.datas.size();
            return result;
        }

        @Override
        public int indexOf(Object o) {
            Map<T, Integer> index = this.getIndex();
            Integer result = index.get(o);
            int resultIndex = -1;
            if (result != null) {
                resultIndex = result;
            }
            return resultIndex;
        }

        protected Map<T, Integer> getIndex() {
            if (this.index.isEmpty()) {
                for (int i = 0; i < this.datas.size(); ++i) {
                    this.index.put(this.datas.get(i), i);
                }
            }
            return this.index;
        }
    }

    public static class MatrixMapIteratorImpl<E>
    implements MatrixMapIterator<E> {
        protected MatrixIterator<E> iterator = null;
        protected List[] semantics = null;
        protected int pos = 0;

        public MatrixMapIteratorImpl(MatrixIterator<E> iterator, List[] semantics) {
            this.iterator = iterator;
            this.semantics = semantics;
            this.pos = 0;
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        @Override
        public E next() {
            return this.iterator.next();
        }

        @Override
        public void remove() {
            this.iterator.remove();
        }

        @Override
        public int[] getCoordinates() {
            return this.iterator.getCoordinates();
        }

        @Override
        public E getValue() {
            return this.iterator.getValue();
        }

        @Override
        public void setValue(E value) {
            this.iterator.setValue(value);
        }

        @Override
        public Object[] getSemanticsCoordinates() {
            Object[] result = null;
            if (this.semantics != null) {
                int[] coordinates = this.getCoordinates();
                result = MatrixHelper.dimensionToSemantics(this.semantics, coordinates);
            }
            return result;
        }
    }

    public static interface MatrixMapIterator<E>
    extends Iterator<E> {
        public int[] getCoordinates();

        public E getValue();

        public void setValue(E var1);

        public Object[] getSemanticsCoordinates();
    }

    public static class MatrixHelper {
        public static String format(Object o, int length, String valueIfNull) {
            if (o == null) {
                o = valueIfNull;
            }
            int absLength = Math.abs(length);
            String result = String.valueOf(o);
            if (absLength > 3) {
                result = StringUtils.abbreviate((String)result, (int)absLength);
            }
            if (length < 0) {
                result = StringUtils.leftPad((String)result, (int)absLength);
            } else if (length > 0) {
                result = StringUtils.rightPad((String)result, (int)absLength);
            }
            return result;
        }

        public static Object[] dimensionToSemantics(List[] semantics, int[] coordinates) {
            Object[] result = new Object[coordinates.length];
            for (int i = 0; i < result.length; ++i) {
                result[i] = semantics[i].get(coordinates[i]);
            }
            return result;
        }

        public static int[] semanticsToDimension(List[] semantics, Object[] coordinates) {
            int[] result = new int[coordinates.length];
            for (int i = 0; i < coordinates.length; ++i) {
                result[i] = MatrixHelper.indexOf(semantics, i, coordinates[i]);
            }
            return result;
        }

        public static int indexOf(List[] semantics, int dim, Object o) throws NoSuchElementException {
            int result = -1;
            if (0 <= dim && dim < semantics.length) {
                result = semantics[dim].indexOf(o);
            }
            if (result == -1) {
                throw new NoSuchElementException("L'objet pass\u00e9 en argument n'a pas \u00e9t\u00e9 retrouv\u00e9 ou la dimension donn\u00e9e ne convient pas:" + o + " in " + semantics[dim]);
            }
            return result;
        }

        public static boolean sameDimension(int[] dim1, int[] dim2) {
            return Arrays.equals(dim1, dim2);
        }
    }

    public static class Factory {
        public static <T> MatrixMap<T> create(List ... semantics) {
            MatrixMapFixed result = new MatrixMapFixed(semantics);
            return result;
        }

        public static <T> MatrixMap<T> create(String name, List ... semantics) {
            MatrixMapFixed result = new MatrixMapFixed(name, semantics);
            return result;
        }

        public static <T> MatrixMap<T> create(String name, String[] dimNames, List ... semantics) {
            MatrixMapFixed result = new MatrixMapFixed(name, dimNames, semantics);
            return result;
        }

        public static <T> MatrixMap<T> create(MatrixMap<T> matrix) {
            MatrixMapFixed<T> result = new MatrixMapFixed<T>(matrix);
            return result;
        }

        public static <T> MatrixMap<T> createElastic(List ... semantics) {
            MatrixMap<T> result = Factory.create(semantics);
            result = Factory.createElastic(result);
            return result;
        }

        public static <T> MatrixMap<T> createElastic(String name, List ... semantics) {
            MatrixMap<T> result = Factory.create(name, semantics);
            result = Factory.createElastic(result);
            return result;
        }

        public static <T> MatrixMap<T> createElastic(String name, String[] dimNames, List ... semantics) {
            MatrixMap<T> result = Factory.create(name, dimNames, semantics);
            result = Factory.createElastic(result);
            return result;
        }

        public static <T> MatrixMap<T> createElastic(MatrixMap<T> matrix) {
            MatrixMapElastic<T> result = new MatrixMapElastic<T>(matrix);
            return result;
        }
    }
}

