/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.util;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.tuple.Pair;

public class PagerUtil {
    public static int getTotalPage(int totalCount, int pageSize) {
        int result = (int)Math.ceil((double)totalCount / (double)pageSize);
        return result;
    }

    public static Pair<Integer, Integer> getPageBound(int totalCount, int page, int pageSize) {
        page = Math.max(page, 1);
        pageSize = Math.max(pageSize, 1);
        int start = (page - 1) * pageSize;
        int end = page * pageSize;
        end = Math.min(end, totalCount);
        Pair result = Pair.of((Object)start, (Object)end);
        return result;
    }

    public static <E> List<E> getPage(List<E> elements, int page, int pageSize) {
        Pair<Integer, Integer> bound = PagerUtil.getPageBound(elements.size(), page, pageSize);
        int start = (Integer)bound.getLeft();
        int end = (Integer)bound.getRight();
        List<E> subList = elements.subList(start, end);
        ArrayList<E> result = new ArrayList<E>(subList);
        return result;
    }
}

