/*
 * #%L
 * Nuiton Utils
 * 
 * $Id: MD5OutputStream.java 2141 2011-05-15 10:35:56Z tchemit $
 * $HeadURL: http://svn.nuiton.org/svn/nuiton-utils/tags/nuiton-utils-parent-2.3.1/nuiton-utils/src/main/java/org/nuiton/util/MD5OutputStream.java $
 * %%
 * Copyright (C) 2004 - 2010 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as 
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */

package org.nuiton.util;

import java.io.OutputStream;
import java.security.DigestOutputStream;
import java.security.MessageDigest;

/**
 *
 *
 */

public class MD5OutputStream extends DigestOutputStream {

    /**
     * Creates MD5OutputStream
     *
     * @param out The output stream
     */

    public MD5OutputStream(OutputStream out) {
        super(out, MD5InputStream.getMD5Digest());
    }

    /**
     * @return array of bytes representing hash of the stream as finalized for
     *         the current state.
     * @see MessageDigest#digest()
     */

    public byte[] hash() {
        return getMessageDigest().digest();
    }

}

