/*
 * #%L
 * Nuiton Utils
 * 
 * $Id: FileCompletion.java 2056 2011-01-25 16:55:41Z tchemit $
 * $HeadURL: http://svn.nuiton.org/svn/nuiton-utils/tags/nuiton-utils-parent-2.3.1/nuiton-utils/src/main/java/org/nuiton/util/FileCompletion.java $
 * %%
 * Copyright (C) 2004 - 2010 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as 
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */

package org.nuiton.util;

import org.nuiton.i18n.I18n;
import static org.nuiton.i18n.I18n._;

import java.io.Console;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.Locale;

/**
 * <p>
 * Class d'aide a la saisie de chemin de fichier
 * </p>
 * <p>
 * Integration :
 * </p>
 * <pre>
 * (le 1er argument definit si l'on peut creer un fichier (ex : pour enregistrer))
 * (le 2eme definit si la sorti est possible sans saisir un fichier)
 * FileCompletion fc = new FileCompletion(true,true);
 * if (fc.consoleAvailable())
 *   System.out.print(fc.read());
 * </pre>
 * <p>
 * Utilisation :
 * </p>
 * <p>
 * ".." pour annuler ou pour revenir au repertoire précédent
 * </p>
 * <p>
 * Entrer pour afficher la liste des fichiers, ou pour compléter le chemin
 * </p>
 * <p>
 * Entrer pour afficher la liste des fichiers, ou pour compléter le chemin
 * </p>
 * Saisir "!s" a la fin du nom de fichier pour l'enregistrer (si l'option est active)
 * <p>
 * </p>
 * Saisir "!q" pour quitter et renvoyer null (si l'option est active)
 * <p>
 * Limitation :
 * </p>
 * <p>
 * FIXME: Si l'enregistrement est active, enregistrer un fichier finissant par "!s" est impossible
 * </p>
 * <p>
 * FIXME: Ouvrir un fichier finissant par ".." l'est égualement
 * </p>
 * <p>
 * FIXME: Si la sortie est ecive, un fichier "!q" ne peut pas etre utilise
 * </p>
 * 
 * @author Letellier Sylvain
 */
public class FileCompletion {
    private boolean exit;
    private boolean creation;
    private boolean consoleAvailable;

    private Console console;

    /**
     * Constructeur
     *
     * @param creation TODO
     * @param exit     TODO
     */
    public FileCompletion(boolean creation, boolean exit) {
        this.exit = exit;
        this.creation = creation;

        I18n.setDefaultLocale(Locale.getDefault());

        // TODO does this util class init i18n ?
//        if (Locale.getDefault().getLanguage().equals("fr")) {
//            I18n.init("fr", "FR");
//        }
//        else {
//            I18n.init("en", "US");
//        }

        console = System.console();
        consoleAvailable = (console != null);
    }

    /**
     * demande a l'utilisateur de saisir un chemin
     *
     * @return TODO
     * @throws IOException TODO
     */
    public String read() throws IOException {
        if (creation) {
            System.out.println(_("nuitonutil.fileCompletion.save"));
        }
        if (exit) {
            System.out.println(_("nuitonutil.fileCompletion.exit"));
        }
        System.out.println(_("nuitonutil.fileCompletion.cancel"));
        System.out.println(_("nuitonutil.fileCompletion.enter"));
        String line = System.getProperty("user.dir");
        File f;
        line = line + readLine("> " + line + File.separator);
        f = new File(line);
        String moreLastLine = line;
        boolean isDirectory = true;
        do {
            if (f.isDirectory() || !f.exists()) {
                String lastLine = line;
                if (!f.exists() && !f.isDirectory()) {
                    File fTmp = f.getParentFile();
                    String file = f.getName();
                    if (file.matches("^.*\\!s$") && creation)
                        return f.getCanonicalPath().substring(0,
                                f.getCanonicalPath().length() - 2);
                    if (file.matches("^.*\\!q$") && exit)
                        return null;
                    if (file.matches("^.*\\.\\.$"))
                        line = fTmp.getCanonicalPath();
                    else {
                        Filter filtre = new Filter();
                        filtre.setFilter(file);
                        String[] listFichier = fTmp.list(filtre);
                        if (listFichier.length == 1) {
                            if (!(fTmp.getParentFile() == null)) {
                                line = fTmp.getCanonicalPath() + File.separator
                                        + listFichier[0];
                            }
                            else {
                                line = fTmp.getCanonicalPath() + listFichier[0];
                            }
                        } else if (listFichier.length > 1) {
                            afficherListe(listFichier);
                        } else {
                            line = moreLastLine;
                        }

                    }
                } else if (f.exists() && f.isDirectory()
                        && !(f.getParentFile() == null)) {
                    Filter filtre = new Filter();
                    filtre.setFilter(f.getName());
                    String[] listFichier = f.getParentFile().list(filtre);
                    if (listFichier.length <= 1
                            || line.charAt(line.length() - 1) == File.separatorChar) {

                        line = f.getCanonicalPath();
                        isDirectory = true;
                    } else if (listFichier.length > 1) {
                        isDirectory = false;
                        afficherListe(listFichier);
                    }

                }
                moreLastLine = line;
                f = new File(line);
                if (f.isDirectory() && isDirectory
                        && !(line.charAt(line.length() - 1) == File.separatorChar))
                    line = line + File.separator;
                String read = readLine("> " + line);
                line = line + read;
                f = new File(line);
                if (read.equals("") || read.equals(File.separator))
                    afficherListe(f.list());

                if (line.matches(".* " + File.separator + ".*")
                        || line.matches(".*" + File.separator + " .*"))
                    line = lastLine;
                f = new File(line);
            }
        } while (!f.exists() || f.isDirectory());
        return line;
    }

    /** Filtre les fichiers a afficher */
    class Filter implements FilenameFilter {
        private String filtre;

        /**
         * @param dir  TODO
         * @param name TODO
         * @return boolean
         */
        public boolean accept(File dir, String name) {
            return name.startsWith(filtre);
        }

        /**
         * le parametre est le debut des noms de fichiers a afficher
         *
         * @param s TODO
         */
        public void setFilter(String s) {
            filtre = s;
        }
    }

    /**
     * @param path TODO
     * @return String
     */
    private String readLine(String path) {
        String lineNonNull = null;
        while (lineNonNull == null)
            lineNonNull = console.readLine(path);
        return lineNonNull;
    }

    /** @return boolean */
    public boolean consoleAvailable() {
        return consoleAvailable;
    }

    /** @param listefichiers TODO */
    private void afficherListe(String[] listefichiers) {
        if (listefichiers != null) {
            int i = 0;
            int nomMax = 0;
            for (String l : listefichiers)
                nomMax = Math.max(nomMax, l.length());
            // System.out.println();
            for (String l : listefichiers) {
                String space = "";
                int nbSpace = (nomMax + 1) - l.length();
                for (int j = 0; j < nbSpace; j++) {
                    space += " ";
                }
                if (i++ < 2)
                    System.out.print(l + space);
                else {
                    i = 0;
                    System.out.println(l);
                }
            }
            System.out.println();
        }
    }
}

