/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.util.beans;

import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.util.ObjectUtil;
import org.nuiton.util.beans.BinderModel;

public class Binder<I, O>
implements Serializable {
    private static final Log log = LogFactory.getLog(Binder.class);
    private static final long serialVersionUID = 1L;
    protected BinderModel<I, O> model;

    public Class<I> getSourceType() {
        return this.getModel().getSourceType();
    }

    public Class<O> getTargetType() {
        return this.getModel().getTargetType();
    }

    public Map<String, Object> obtainProperties(I source, String ... propertyNames) {
        if (source == null) {
            return Collections.emptyMap();
        }
        propertyNames = this.getProperties(propertyNames);
        TreeMap<String, Object> result = new TreeMap<String, Object>();
        for (String sourceProperty : propertyNames) {
            try {
                Method readMethod = this.model.getSourceReadMethod(sourceProperty);
                Object read = readMethod.invoke(source, new Object[0]);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("property " + sourceProperty + ", type : " + readMethod.getReturnType() + ", value = " + read));
                }
                if (readMethod.getReturnType().isPrimitive() && ObjectUtil.getNullValue(readMethod.getReturnType()).equals(read)) {
                    read = null;
                }
                if (read == null) continue;
                if (this.model.containsBinderProperty(sourceProperty)) {
                    read = this.model.containsCollectionProperty(sourceProperty) ? this.bindCollection(sourceProperty, read) : this.bindProperty(sourceProperty, read);
                } else if (this.model.containsCollectionProperty(sourceProperty)) {
                    read = this.getCollectionValue(sourceProperty, read);
                }
                result.put(sourceProperty, read);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
            catch (InvocationTargetException e) {
                throw new RuntimeException(e);
            }
            catch (InstantiationException e) {
                throw new RuntimeException(e);
            }
        }
        return result;
    }

    public void copy(I source, O target, String ... propertyNames) throws NullPointerException {
        if (target == null) {
            throw new NullPointerException("parameter 'target' can no be null");
        }
        for (String sourceProperty : propertyNames = this.getProperties(propertyNames)) {
            String targetProperty = this.model.getTargetProperty(sourceProperty);
            try {
                Object read = null;
                Method readMethod = this.model.getSourceReadMethod(sourceProperty);
                if (source != null) {
                    read = readMethod.invoke(source, new Object[0]);
                }
                if (read == null) {
                    read = ObjectUtil.getNullValue(readMethod.getReturnType());
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)("property " + sourceProperty + ", type : " + readMethod.getReturnType() + ", value = " + read));
                }
                if (this.model.containsBinderProperty(sourceProperty)) {
                    read = this.model.containsCollectionProperty(sourceProperty) ? this.bindCollection(sourceProperty, read) : this.bindProperty(sourceProperty, read);
                } else if (this.model.containsCollectionProperty(sourceProperty)) {
                    read = this.getCollectionValue(sourceProperty, read);
                }
                if (this.model.containsCollectionProperty(sourceProperty)) {
                    read = this.getCollectionValue(sourceProperty, read);
                }
                this.model.getTargetWriteMethod(targetProperty).invoke(target, read);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
            catch (InvocationTargetException e) {
                throw new RuntimeException(e);
            }
            catch (InstantiationException e) {
                throw new RuntimeException(e);
            }
        }
    }

    protected BinderModel<I, O> getModel() {
        return this.model;
    }

    protected void setModel(BinderModel<?, ?> model) {
        this.model = model;
    }

    protected String[] getProperties(String ... propertyNames) {
        if (propertyNames.length == 0) {
            propertyNames = this.model.getSourceDescriptors();
        } else {
            for (String propertyName : propertyNames) {
                if (this.model.containsSourceProperty(propertyName)) continue;
                throw new IllegalArgumentException("property '" + propertyName + "' is not known by binder");
            }
        }
        return propertyNames;
    }

    protected Object getCollectionValue(String sourceProperty, Object readValue) {
        CollectionStrategy strategy = this.model.getCollectionStrategy(sourceProperty);
        Object result = strategy.copy(readValue);
        return result;
    }

    protected Object bindProperty(String sourceProperty, Object read) throws IllegalAccessException, InstantiationException {
        Binder<?, ?> binder = this.model.getBinder(sourceProperty);
        Object result = this.bind(binder, read);
        return result;
    }

    protected Object bindCollection(String sourceProperty, Object read) throws IllegalAccessException, InstantiationException {
        if (read == null) {
            return null;
        }
        Binder<?, ?> binder = this.model.getBinder(sourceProperty);
        AbstractCollection result = null;
        if (read instanceof Set) {
            result = new HashSet();
        }
        if (read instanceof Collection) {
            result = new ArrayList();
        }
        for (Object o : (Collection)read) {
            Object r = this.bind(binder, o);
            result.add(r);
        }
        return result;
    }

    protected Object bind(Binder binder, Object read) throws IllegalAccessException, InstantiationException {
        Object result = read.getClass().newInstance();
        binder.copy(read, result, new String[0]);
        return result;
    }

    public static enum CollectionStrategy {
        copy{

            @Override
            public Object copy(Object readValue) {
                return readValue;
            }
        }
        ,
        duplicate{

            @Override
            public Object copy(Object readValue) {
                if (readValue instanceof Set) {
                    return new HashSet((Set)readValue);
                }
                if (readValue instanceof Collection) {
                    return new ArrayList((Collection)readValue);
                }
                return readValue;
            }
        };


        public abstract Object copy(Object var1);
    }
}

