/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.util;

import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.beanutils.ConvertUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;
import org.nuiton.util.StringUtil;

public class ObjectUtil {
    private static Log log = LogFactory.getLog(ObjectUtil.class);

    private ObjectUtil() {
    }

    public static Object create(String classnameAndProperties) throws ClassNotFoundException, InstantiationException, IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        int p = classnameAndProperties.indexOf(40);
        int l = classnameAndProperties.lastIndexOf(41);
        String[] properties = null;
        String classname = null;
        if (p != -1) {
            String tmp = classnameAndProperties.substring(p + 1, l);
            properties = StringUtil.split(tmp, ",");
            classname = classnameAndProperties.substring(0, p);
        } else {
            classname = classnameAndProperties;
        }
        Class<?> clazz = Thread.currentThread().getContextClassLoader().loadClass(classname);
        Object o = clazz.newInstance();
        if (properties != null) {
            for (String prop : properties) {
                int e = prop.indexOf(61);
                String propName = prop.substring(0, e).trim();
                String propValue = prop.substring(e + 1).trim();
                if (propValue.charAt(0) == '\"' && propValue.charAt(propValue.length() - 1) == '\"') {
                    propValue = propValue.substring(1, propValue.length() - 1);
                } else if (propValue.charAt(0) == '\'' && propValue.charAt(propValue.length() - 1) == '\'') {
                    propValue = propValue.substring(1, propValue.length() - 1);
                }
                BeanUtils.setProperty(o, (String)propName, (Object)propValue);
            }
        }
        return o;
    }

    protected static Object convert(String v, Class<?> clazz) {
        Object t = ConvertUtils.convert((String)v, clazz);
        if (t != null && !String.class.getName().equals(clazz.getName()) && String.class.getName().equals(t.getClass().getName())) {
            throw new IllegalArgumentException(String.format("Can convert argument to correct type. %s can't be converted from String to %s conversion is done to %s", v, clazz.getName(), t.getClass().getName()));
        }
        return t;
    }

    public static Object call(Object o, Method m, String ... params) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException, InstantiationException {
        Class<?>[] types = m.getParameterTypes();
        if (!m.isVarArgs() && params.length != types.length) {
            throw new IllegalArgumentException(String.format("Bad number params we have %1$s parameters and waiting %2$s.", params.length, types.length));
        }
        int last = types.length;
        if (m.isVarArgs()) {
            --last;
        }
        Object[] parameters = new Object[types.length];
        for (int i = 0; i < last; ++i) {
            Object t;
            String v = params[i];
            Class<?> clazz = types[i];
            parameters[i] = t = ObjectUtil.convert(v, clazz);
        }
        if (m.isVarArgs()) {
            Class<?> clazz = types[last];
            clazz = clazz.getComponentType();
            ArrayList<Object> tmp = new ArrayList<Object>();
            for (int i = last; i < params.length; ++i) {
                String v = params[i];
                Object t = ObjectUtil.convert(v, clazz);
                tmp.add(t);
            }
            parameters[last] = tmp.toArray((Object[])Array.newInstance(clazz, tmp.size()));
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)I18n._("nuitonutil.debug.objectutil.invoke", m, Arrays.toString(parameters)));
        }
        Object result = m.invoke(o, parameters);
        return result;
    }

    public static List<Method> getMethod(Class<?> clazz, String methodName, boolean ignoreCase) {
        Method[] methods;
        ArrayList<Method> result = new ArrayList<Method>();
        for (Method m : methods = clazz.getMethods()) {
            if ((!ignoreCase || !methodName.equalsIgnoreCase(m.getName())) && !methodName.equals(m.getName())) continue;
            result.add(m);
        }
        return result;
    }

    public static Object newInstance(String constructorWithParams) throws ClassNotFoundException {
        int p = constructorWithParams.indexOf(40);
        int l = constructorWithParams.lastIndexOf(41);
        String[] params = null;
        String classname = null;
        if (p != -1) {
            String tmp = constructorWithParams.substring(p + 1, l);
            params = StringUtil.split(tmp, ",");
            classname = constructorWithParams.substring(0, p);
        } else {
            classname = constructorWithParams;
        }
        Class<?> clazz = Thread.currentThread().getContextClassLoader().loadClass(classname);
        Object result = ObjectUtil.newInstance(clazz, params);
        return result;
    }

    public static <T> T newInstance(Class<T> clazz, String ... params) throws IllegalArgumentException {
        if (params == null) {
            params = new String[]{};
        }
        List<Constructor<T>> constructors = ObjectUtil.getConstructor(clazz, params.length);
        for (Constructor<T> c : constructors) {
            try {
                Class<?>[] types = c.getParameterTypes();
                int last = types.length;
                if (c.isVarArgs()) {
                    --last;
                }
                Object[] parameters = new Object[types.length];
                for (int i = 0; i < last; ++i) {
                    Object t;
                    String v = params[i];
                    Class<?> argClazz = types[i];
                    parameters[i] = t = ObjectUtil.convert(v, argClazz);
                }
                if (c.isVarArgs()) {
                    Class<?> argClazz = types[last];
                    argClazz = argClazz.getComponentType();
                    ArrayList<Object> tmp = new ArrayList<Object>();
                    for (int i = last; i < params.length; ++i) {
                        String v = params[i];
                        Object t = ObjectUtil.convert(v, argClazz);
                        tmp.add(t);
                    }
                    parameters[last] = tmp.toArray((Object[])Array.newInstance(argClazz, tmp.size()));
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)I18n._("nuitonutil.debug.objectutil.create", clazz, Arrays.toString(parameters)));
                }
                T result = c.newInstance(parameters);
                return result;
            }
            catch (Exception eee) {
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)"Creation failed try with next constructor");
            }
        }
        throw new IllegalArgumentException(I18n._("nuitonutil.debug.objectutil.instantiate", clazz, Arrays.toString(params)));
    }

    public static <T> List<Constructor<T>> getConstructor(Class<T> clazz, int paramNumber) {
        Constructor<?>[] constructors;
        ArrayList<Constructor<T>> result = new ArrayList<Constructor<T>>();
        for (Constructor<?> c : constructors = clazz.getConstructors()) {
            if (paramNumber >= 0 && (!c.isVarArgs() || c.getParameterTypes().length > paramNumber - 1) && c.getParameterTypes().length != paramNumber) continue;
            result.add(c);
        }
        return result;
    }

    public static Object toObject(Object o) {
        return o;
    }

    public static Object toObject(char c) {
        return new Character(c);
    }

    public static Object toObject(byte b) {
        return new Byte(b);
    }

    public static Object toObject(short s) {
        return new Short(s);
    }

    public static Object toObject(int i) {
        return new Integer(i);
    }

    public static Object toObject(long l) {
        return new Long(l);
    }

    public static Object toObject(float f) {
        return new Float(f);
    }

    public static Object toObject(double d) {
        return new Double(d);
    }

    public static Object toObject(boolean b) {
        return b ? Boolean.TRUE : Boolean.FALSE;
    }
}

