/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.log;

import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.Statement;
import javax.swing.JProgressBar;
import javax.swing.SwingUtilities;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.log.LutinLog;
import org.nuiton.log.LutinLogEvent;
import org.nuiton.log.LutinLogListener;
import org.nuiton.log.LutinProgressEvent;

public class MonitorMapper
implements LutinLogListener,
ActionListener {
    private static Log log = LogFactory.getLog(MonitorMapper.class);
    protected LutinLog lutinLog;
    protected Container parentContainer;
    protected Component label;
    protected JProgressBar progress;
    protected Component cancel;
    protected boolean changeCancelText;

    public MonitorMapper(LutinLog lutinLog, Container parentContainer, Component label, JProgressBar progress, Component cancel, boolean changeCancelText) {
        this.lutinLog = lutinLog;
        this.parentContainer = parentContainer;
        this.label = label;
        this.progress = progress;
        this.cancel = cancel;
        this.changeCancelText = changeCancelText;
        lutinLog.addLutinLogListener(this);
        this.addActionListener(cancel, this);
    }

    protected void addActionListener(Component c, ActionListener action) {
        block3: {
            try {
                if (c != null) {
                    Statement statement = new Statement(c, "addActionListener", new Object[]{action});
                    statement.execute();
                }
            }
            catch (Exception eee) {
                if (!log.isTraceEnabled()) break block3;
                log.trace((Object)("Can't modify call addActionListener on: " + c), (Throwable)eee);
            }
        }
    }

    protected void setText(Component c, String text) {
        block3: {
            try {
                if (c != null) {
                    Statement statement = new Statement(c, "setText", new Object[]{text});
                    statement.execute();
                }
            }
            catch (Exception eee) {
                if (!log.isTraceEnabled()) break block3;
                log.trace((Object)("Can't modify call setText on: " + c), (Throwable)eee);
            }
        }
    }

    @Override
    public void logEvent(LutinLogEvent e) {
        if (e.getLogType() == LutinLogEvent.LogType.user) {
            SwingUtilities.invokeLater(new HandleLogEvent(e));
        }
    }

    @Override
    public void progressEvent(LutinProgressEvent e) {
        SwingUtilities.invokeLater(new HandleProgressEvent(e));
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        boolean oldValue = this.lutinLog.isAskStopTask();
        this.lutinLog.setAskStopTask(!oldValue);
    }

    class HandleProgressEvent
    implements Runnable {
        protected LutinProgressEvent e;

        public HandleProgressEvent(LutinProgressEvent e) {
            this.e = e;
        }

        @Override
        public void run() {
            if (this.e.getType() == LutinProgressEvent.ProgressType.start) {
                int min = this.e.getLutinLog().getMin();
                int max = this.e.getLutinLog().getMax();
                int value = this.e.getLutinLog().getValue();
                MonitorMapper.this.progress.setMinimum(min);
                MonitorMapper.this.progress.setMaximum(max);
                MonitorMapper.this.progress.setValue(value);
                String text = value + " of " + max;
                MonitorMapper.this.progress.setString(text);
                if (MonitorMapper.this.parentContainer != null) {
                    MonitorMapper.this.parentContainer.setVisible(true);
                }
            } else if (this.e.getType() == LutinProgressEvent.ProgressType.min) {
                int min = this.e.getLutinLog().getMin();
                MonitorMapper.this.progress.setMinimum(min);
            } else if (this.e.getType() == LutinProgressEvent.ProgressType.max) {
                int max = this.e.getLutinLog().getMax();
                MonitorMapper.this.progress.setMaximum(max);
                int value = this.e.getLutinLog().getValue();
                String text = value + " of " + max;
                MonitorMapper.this.progress.setString(text);
            } else if (this.e.getType() == LutinProgressEvent.ProgressType.value) {
                int max = this.e.getLutinLog().getMax();
                int value = this.e.getLutinLog().getValue();
                MonitorMapper.this.progress.setValue(value);
                String text = value + " of " + max;
                MonitorMapper.this.progress.setString(text);
            } else if (this.e.getType() == LutinProgressEvent.ProgressType.askStop) {
                if (MonitorMapper.this.changeCancelText) {
                    MonitorMapper.this.setText(MonitorMapper.this.cancel, "Don't cancel");
                }
            } else if (this.e.getType() == LutinProgressEvent.ProgressType.cancelAskStop) {
                if (MonitorMapper.this.changeCancelText) {
                    MonitorMapper.this.setText(MonitorMapper.this.cancel, "Cancel");
                }
            } else if (this.e.getType() == LutinProgressEvent.ProgressType.end) {
                if (MonitorMapper.this.parentContainer != null) {
                    MonitorMapper.this.parentContainer.setVisible(false);
                }
                MonitorMapper.this.progress.setMinimum(0);
                MonitorMapper.this.progress.setMaximum(0);
                MonitorMapper.this.progress.setValue(0);
                MonitorMapper.this.progress.setString("");
            }
        }
    }

    class HandleLogEvent
    implements Runnable {
        protected LutinLogEvent e;

        public HandleLogEvent(LutinLogEvent e) {
            this.e = e;
        }

        @Override
        public void run() {
            MonitorMapper.this.setText(MonitorMapper.this.label, this.e.getMsg());
        }
    }
}

