package org.nuiton.util;

/**
 * *##% Chorem-Commons
 * Copyright (C) 2009 CodeLutin
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>. ##%*
 */



import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/**
 * PeriodDates.java
 *
 * Created on 2009-08-13
 *
 * @author fdesbois
 * @version $Revision: 98 $
 *
 * Last update: $Date: 2009-12-04 01:28:16 +0100 (Fri, 04 Dec 2009) $
 * by : $Author: fdesbois $
 */
public class PeriodDates {

    private static final Log log = LogFactory.getLog(PeriodDates.class);

    private String pattern;

    private Date fromDate;

    private Calendar fromCalendar;

    private Date thruDate;

    private Calendar thruCalendar;

    public PeriodDates() {        
    }

    public PeriodDates(Date fromDate, Date thruDate) {
        this.fromCalendar = new GregorianCalendar();
        setFromDate(fromDate);
        
        this.thruCalendar = new GregorianCalendar();
        setThruDate(thruDate);
        
        this.pattern = DateUtils.DEFAULT_PATTERN;
    }

    public PeriodDates(Calendar fromCalendar, Calendar thruCalendar) {
        this.fromDate = fromCalendar.getTime();
        this.fromCalendar = fromCalendar;

        this.thruDate = thruCalendar.getTime();
        this.thruCalendar = thruCalendar;

        this.pattern = DateUtils.DEFAULT_PATTERN;
    }

    public static PeriodDates createMonthsPeriodFromToday(int monthAfter) {
        Calendar calendarFrom = new GregorianCalendar();
        Calendar calendarThru = new GregorianCalendar();

        calendarFrom.set(Calendar.DAY_OF_MONTH, 1);
        calendarFrom.set(Calendar.AM_PM, Calendar.AM);
        calendarFrom.set(Calendar.HOUR, 0);
        calendarFrom.set(Calendar.MINUTE, 0);
        calendarFrom.set(Calendar.SECOND, 0);
        calendarFrom.set(Calendar.MILLISECOND, 0);

        calendarThru.setTime(calendarFrom.getTime());
        calendarThru.add(Calendar.MONTH, monthAfter);
        int maximum = calendarThru.getActualMaximum(Calendar.DAY_OF_MONTH);
        calendarThru.set(Calendar.DAY_OF_MONTH, maximum);        

        PeriodDates period = new PeriodDates(calendarFrom, calendarThru);
        period.setPattern(DateUtils.MONTH_PATTERN);
        return period;
    }

    public String getPattern() {
        return pattern;
    }

    public void setPattern(String pattern) {
        this.pattern = pattern;
    }

    public void setFromDate(Date fromDate) {
        this.fromDate = fromDate;       
        if (fromDate != null) {
             if (fromCalendar == null) {
                fromCalendar = new GregorianCalendar();
            }
            this.fromCalendar.setTime(fromDate);
        } else {
            this.fromCalendar = null;
        }
    }

    public Date getFromDate() {
        return this.fromDate;
    }

    public int getFromMonth() {
        return this.fromCalendar.get(Calendar.MONTH);
    }

    public void setThruDate(Date thruDate) {
        this.thruDate = thruDate;       
        if (thruDate != null) {
             if (thruCalendar == null) {
                thruCalendar = new GregorianCalendar();
            }
            this.thruCalendar.setTime(thruDate);
        } else {
            this.thruCalendar = null;
        }
    }

    public Date getThruDate() {
        return this.thruDate;
    }

    public List<Date> getMonths() {
         List<Date> months = new ArrayList<Date>();
         if (fromCalendar == null || thruCalendar == null) {
             return months;
         }

        /*int mFrom = fromCalendar.get(Calendar.MONTH);
        int mThru = thruCalendar.get(Calendar.MONTH);
        int yFrom = fromCalendar.get(Calendar.YEAR);
        int yThru = thruCalendar.get(Calendar.YEAR);

        int nbYears = yThru - yFrom;
        int monthRatio = nbYears * 12;

        int y = yFrom;
        for(int i = mFrom; i <= mThru + monthRatio; i++) {
            Calendar result = new GregorianCalendar(y, i%12, 1);
            months.add(result.getTime());
            if (i != 0 && i%11 == 0) {
                y++;
            }
        }*/

        Calendar current = (Calendar) fromCalendar.clone();
        current.set(Calendar.DAY_OF_MONTH, 1);
        Calendar end = (Calendar) thruCalendar.clone();
        end.set(Calendar.DAY_OF_MONTH, 1);
        while (!current.equals(end)) {
            months.add(current.getTime());
            current.add(Calendar.MONTH, 1);
        }
        months.add(current.getTime());

        return months;
    }

    public List<String> getFormatedMonths() {
        List<String> results = new ArrayList<String>();
        for (Date date : getMonths()) {
            String str = DateUtils.formatDate(date, pattern);
            results.add(str);
        }
        return results;
    }

    public boolean beforeEnd(Calendar calendar) {
        return calendar.before(thruCalendar) || calendar.equals(thruCalendar);
    }

    public boolean afterEnd(Calendar calendar) {
        return calendar.after(thruCalendar);
    }

    public boolean afterBegin(Calendar calendar) {
        return calendar.after(fromCalendar) || calendar.equals(fromCalendar);
    }

    public boolean between(Calendar calendar) {
        return beforeEnd(calendar) && afterBegin(calendar);
    }
    

    @Override
    public String toString() {
        String fromStr = DateUtils.formatDate(fromDate, pattern);
        String thruStr = DateUtils.formatDate(thruDate, pattern);
        return "[ " + fromDate + " (pattern: " + fromStr + ") -> " + thruDate + " (pattern: " + thruStr + ") ]";
    }

}
