/* 
* *##% Nuiton utilities library
 * Copyright (C) 2004 - 2009 CodeLutin
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 *
 * You should have received a copy of the GNU General Lesser Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>. ##%* */
package org.nuiton.util;

import static org.nuiton.i18n.I18n._;

/**
 * Une énumération pour représenter les mois d'une année.
 *
 * @author chemit
 */

public enum MonthEnum {
    JANUARY(_("lutinutil.month.january")),
    FEBRUARY(_("lutinutil.month.february")),
    MARCH(_("lutinutil.month.march")),
    APRIL(_("lutinutil.month.april")),
    MAY(_("lutinutil.month.may")),
    JUNE(_("lutinutil.month.june")),
    JULY(_("lutinutil.month.july")),
    AUGUST(_("lutinutil.month.august")),
    SEPTEMBER(_("lutinutil.month.september")),
    OCTOBER(_("lutinutil.month.october")),
    NOVEMBER(_("lutinutil.month.november")),
    DECEMBER(_("lutinutil.month.december"));

    private final String libelle;

    MonthEnum(String libelle) {
        this.libelle = libelle;
    }

    public String getLibelle() {
        return libelle;
    }

    public static MonthEnum valueOf(String month, MonthEnum defaultValue) {
        MonthEnum monthEnum = null;
        try {
            monthEnum = MonthEnum.valueOf(month.toUpperCase());
        } catch (IllegalArgumentException e) {
            System.err.println(_("lutinutil.error.unfound.month", month, defaultValue));
        } catch (NullPointerException e) {
            System.err.println(_("lutinutil.error.unfound.month", month, defaultValue));
        }
        return monthEnum == null ? defaultValue : monthEnum;
    }

    @Override
    public String toString() {
        // on force la traduction (au cas où i18n n'était pas ini au moment
        // du chargement de l'enum...)
        return _(libelle);
    }
}
