/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.rss;

import java.io.IOException;
import java.io.PrintWriter;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.nuiton.rss.BaseServlet;
import org.nuiton.rss.ConfigInitializer;
import org.nuiton.rss.RSSConfig;
import org.nuiton.rss.RSSHelper;

public class RSSServlet
extends BaseServlet<RSSHelper> {
    protected static String js = "function rssincludeUpdateDiv(div, background) {\n    // mettre background a false est utile lorsque l'on appelle la methode\n    // depuis une fenetre que l'on ferme ensuite\n    var serlvetUrl = \"%1$s\";    \n    win = window;\n    var xhr = null;\n    var error=null;\n    var feedName = div.getAttribute(\"feedName\");\n    if (!feedName) // pas de feed name, fatal error\n        error = \"<span class='feed-error'>Aucun feed name detecte...</span>\";        \n    else if(win.XMLHttpRequest) // Firefox, Opera detected\n        xhr = new win.XMLHttpRequest();\n    else if(win.ActiveXObject) // Internet Explorer detected\n        xhr = new win.ActiveXObject(\"Microsoft.XMLHTTP\");\n    else  // XMLHttpRequest non supporte par le navigateur\n        error = \"<span class='feed-error'>Votre navigateur ne supporte pas les objets XMLHTTPRequest...</span>\";    \n    if (!!error) { div.innerHTML = error; return; } \n    \n    var nbItem = div.getAttribute(\"nbItem\");\n    var feedRepr = div.getAttribute(\"feedRepr\");            \n    var forceReload = div.getAttribute(\"forceReload\");            \n    var url = serlvetUrl+(serlvetUrl.indexOf('?')>-1?'&':'?')+\"feedName=\" + escape(feedName);        \n    if (!!nbItem) {url += '&nbItem=' + escape(nbItem);}        \n    if (!!feedRepr) {url += '&feedRepr=' + escape(feedRepr);}\n    if (!!forceReload) {url += '&forceReload=true';}\n\n    xhr.open(\"GET\", url, !!background);\n    xhr.onreadystatechange = function() {\n        if(xhr.readyState == 1) div.innerHTML = \"Chargement du flux '\"+feedName+\"'\";\n        if(xhr.readyState == 4) div.innerHTML = xhr.responseText;\n    }\n    xhr.send(null);\n}\nvar initRss =function () {\n    var divs = document.getElementsByTagName(\"div\");    \n    var i = 0;var max=divs.length;  \n    var toTreate = [];\n    while (i < max) {\n        var div = divs[i++];\n        if (div.getAttribute('name')=='rssinclude') toTreate[toTreate.length] = div;\n    }\n    i=0;max = toTreate.length;\n    while (i<max) rssincludeUpdateDiv(toTreate[i++], true);}\nif (window.addEventListener) window.addEventListener( 'load', initRss,false);\nelse if (window.attachEvent) window.attachEvent( 'onload', initRss);";
    private static final long serialVersionUID = 1L;

    public static String getJs(String url) {
        String code = String.format(js, url);
        return code;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doJs(HttpServletResponse response, HttpServletRequest request) throws IOException {
        response.setContentType("text/plain;charset=UTF-8");
        PrintWriter out = response.getWriter();
        try {
            String code = RSSServlet.getJs(request.getRequestURL().toString());
            out.println(code);
        }
        finally {
            out.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doRender(HttpServletResponse response, HttpServletRequest request, String feedName) throws IOException {
        response.setContentType("text/html;charset=UTF-8");
        PrintWriter out = response.getWriter();
        try {
            String feedRepr = request.getParameter("feedRepr");
            Integer nbItem = this.convertToInt(request.getParameter("nbItem"));
            boolean forceReload = "true".equalsIgnoreCase(request.getParameter("forceReload"));
            out.println(((RSSHelper)this.delegate).getHTML(feedName, feedRepr, nbItem, forceReload));
        }
        finally {
            out.close();
        }
    }

    @Override
    protected ConfigInitializer<ServletConfig, ?> newConfigInitializer() {
        return new RSSConfig.RSSConfigInitializer<ServletConfig>(){

            @Override
            protected String getConfigValue(ServletConfig config, String fullConfigName) {
                return config.getInitParameter(fullConfigName);
            }
        };
    }

    @Override
    protected RSSHelper newDelegate() throws Exception {
        return RSSHelper.newDefaultInstance();
    }

    @Override
    protected void processRequest(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String feedName = request.getParameter("feedName");
        if (feedName == null || "".equals(feedName)) {
            this.doJs(response, request);
        } else {
            this.doRender(response, request, feedName);
        }
    }
}

