/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.rss;

import com.sun.syndication.feed.synd.SyndEntry;
import com.sun.syndication.feed.synd.SyndFeed;
import com.sun.syndication.io.FeedException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.rss.FeedType;
import org.nuiton.rss.Field;
import org.nuiton.rss.RSSGeneratorConfig;
import org.nuiton.rss.RSSIOUtil;

public class RSSGenerator {
    static final Log log = LogFactory.getLog(RSSGenerator.class);
    public static final DateFormat DATE_PARSER = new SimpleDateFormat("dd/MM/yyyy hh:mm:ss");
    protected final EnumMap<Field, String> feedProperties;
    protected final EnumMap<Field, String> itemProperties;
    protected final File generatorDirectory;
    protected final FeedType format;
    protected final int nbItems;

    public static RSSGenerator newDefaultInstance() throws Exception {
        RSSGenerator helper = new RSSGenerator();
        return helper;
    }

    protected RSSGenerator() {
        this(null);
    }

    protected RSSGenerator(EnumMap<Field, String> feedProperties, EnumMap<Field, String> itemProperties, File generatorDirectory, FeedType format, int nbItems) {
        this.feedProperties = feedProperties;
        this.itemProperties = itemProperties;
        this.generatorDirectory = generatorDirectory;
        this.format = format;
        this.nbItems = nbItems;
    }

    protected RSSGenerator(File generatorDirectory) {
        this.feedProperties = new EnumMap(Field.class);
        this.feedProperties.put(Field.NAME, "title");
        this.feedProperties.put(Field.LINK, "link");
        this.feedProperties.put(Field.IMAGE, "image.url");
        this.feedProperties.put(Field.DESCRIPTION, "description");
        this.feedProperties.put(Field.AUTHOR, "author");
        this.feedProperties.put(Field.TIME, "publishedDate");
        this.feedProperties.put(Field.CATEGORY, "categories");
        this.itemProperties = new EnumMap(Field.class);
        this.itemProperties.put(Field.NAME, "title");
        this.itemProperties.put(Field.LINK, "link");
        this.itemProperties.put(Field.IMAGE, null);
        this.itemProperties.put(Field.DESCRIPTION, "description.value");
        this.itemProperties.put(Field.AUTHOR, "author");
        this.itemProperties.put(Field.TIME, "publishedDate");
        this.generatorDirectory = generatorDirectory == null ? new File(RSSGeneratorConfig.GENERATOR_DIRECTORY) : generatorDirectory;
        this.format = FeedType.valueOf(RSSGeneratorConfig.DEFAULT_GENERATOR_FORMAT);
        this.nbItems = RSSGeneratorConfig.DEFAULT_GENERATOR_NB_ITEM;
    }

    public void createFeedFile(URL url, FeedType type, Map<Field, Object> values) throws IOException, FeedException, ParseException {
        if (url == null) {
            throw new NullPointerException("can not create a feed with null url");
        }
        if (type == null) {
            throw new NullPointerException("can not create a feed with null feedtype");
        }
        if (values == null || values.isEmpty()) {
            throw new NullPointerException("can not create a feed with null nor empty values dictonnary");
        }
        File f = this.getFile(url);
        if (f.exists()) {
            throw new IllegalStateException("feed already existing in " + f.getName());
        }
        f.getParentFile().mkdirs();
        FileLock lock = this.acquireLock(f);
        try {
            SyndFeed feed = RSSIOUtil.createFeed(this.feedProperties, type, values);
            RSSIOUtil.saveFeed(f, feed);
        }
        catch (FeedException e) {
            f.delete();
            throw e;
        }
        catch (ParseException e) {
            f.delete();
            throw e;
        }
        finally {
            this.releaseLock(f, lock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addItemToFeedFile(URL url, int nbEntries, Map<Field, Object> values) throws IOException, FeedException, ParseException {
        if (url == null) {
            throw new NullPointerException("can not add a feed's entry with null url");
        }
        if (values == null || values.isEmpty()) {
            throw new NullPointerException("can not add a feed's entry  with null nor empty values dictonnary");
        }
        File f = this.getFile(url);
        if (!f.exists()) {
            throw new FileNotFoundException("file not existing " + f);
        }
        FileLock lock = this.acquireLock(f);
        try {
            SyndFeed feed = RSSIOUtil.readFeed(url);
            SyndEntry item = RSSIOUtil.createFeedItem(this.itemProperties, values);
            feed = RSSIOUtil.addItemToFeed(feed, item, nbEntries, values);
            File tmpFile = new File(f.getAbsolutePath() + "-tmp_" + System.nanoTime());
            RSSIOUtil.saveFeed(tmpFile, feed);
            tmpFile.renameTo(f);
        }
        finally {
            this.releaseLock(f, lock);
        }
    }

    public void deleteFeedFile(URL toURL) {
        File f = this.getFile(toURL);
        if (f.exists() && !f.delete()) {
            throw new IllegalStateException("could not delete feed " + f.getName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EnumSet<Field> updateFeedFile(URL url, Map<Field, Object> values) throws IOException, FeedException, ParseException {
        if (url == null) {
            throw new NullPointerException("can not add a feed's entry with null url");
        }
        if (values == null || values.isEmpty()) {
            throw new NullPointerException("can not add a feed's entry  with null nor empty values dictonnary");
        }
        File f = this.getFile(url);
        if (!f.exists()) {
            throw new FileNotFoundException("file not existing " + f);
        }
        FileLock lock = this.acquireLock(f);
        try {
            SyndFeed feed = RSSIOUtil.readFeed(url);
            EnumSet<Field> modifieds = RSSIOUtil.updateFeed(feed, this.feedProperties, values);
            File tmpFile = new File(f.getAbsolutePath() + "-tmp_" + System.nanoTime());
            RSSIOUtil.saveFeed(tmpFile, feed);
            tmpFile.renameTo(f);
            EnumSet<Field> enumSet = modifieds;
            return enumSet;
        }
        finally {
            this.releaseLock(f, lock);
        }
    }

    public FeedType getFormat() {
        return this.format;
    }

    public File getFeedFile(String name) {
        return new File(this.getGeneratorDirectory(), name + ".xml");
    }

    public int getNbItems() {
        return this.nbItems;
    }

    protected File getFile(URL url) throws IllegalStateException {
        try {
            return new File(url.toURI());
        }
        catch (URISyntaxException e) {
            throw new IllegalStateException("could not obtain file from url " + url, e);
        }
    }

    protected FileLock acquireLock(File f) throws IOException {
        File lockFile = this.getWriteFileLock(f);
        FileChannel channel = new RandomAccessFile(lockFile, "rw").getChannel();
        return channel.lock();
    }

    protected File getWriteFileLock(File f) {
        return new File(f.getParentFile(), f.getName() + ".wlock");
    }

    protected void releaseLock(File f, FileLock lock) throws IOException {
        lock.release();
        lock.channel().close();
        File lockFile = this.getWriteFileLock(f);
        lockFile.delete();
    }

    public File getGeneratorDirectory() {
        return this.generatorDirectory;
    }
}

