/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.math.matrix;

import java.util.Arrays;
import org.apache.commons.collections.primitives.ArrayFloatList;
import org.apache.commons.collections.primitives.FloatCollection;
import org.nuiton.math.matrix.MapFunction;
import org.nuiton.math.matrix.Vector;

public class FloatVector
implements Vector {
    protected int capacity = 0;
    protected float defaultValue = 0.0f;
    protected int[] position;
    protected int positionSize = 0;
    protected ArrayFloatList data = new ArrayFloatList();

    public FloatVector(int capacity) {
        this.capacity = capacity;
        this.position = new int[8];
        Arrays.fill(this.position, Integer.MAX_VALUE);
    }

    public FloatVector(int capacity, float defaultValue) {
        this(capacity);
        this.defaultValue = defaultValue;
    }

    @Override
    public int size() {
        return this.capacity;
    }

    @Override
    public double getMaxOccurence() {
        float result = this.defaultValue;
        float[] tmp = this.data.toArray();
        if (this.capacity < 2 * tmp.length) {
            Arrays.sort(tmp);
            int max = 1;
            int count = 1;
            result = tmp[0];
            float old = tmp[0];
            float current = tmp[0];
            for (int i = 1; max < tmp.length - i + count && i < tmp.length; ++i) {
                current = tmp[i];
                if (current == old) {
                    ++count;
                    continue;
                }
                if (count > max) {
                    max = count;
                    result = old;
                }
                count = 1;
                old = current;
            }
            if (count > max) {
                max = count;
                result = current;
            }
            if (max <= this.capacity - tmp.length) {
                result = this.defaultValue;
            }
        }
        return result;
    }

    protected void checkPos(int pos) {
        if (pos < 0 || pos >= this.capacity) {
            throw new IllegalArgumentException("pos " + pos + " is not in [0, " + this.capacity + "]");
        }
    }

    @Override
    public double getValue(int pos) {
        this.checkPos(pos);
        float result = this.defaultValue;
        int index = this.findIndex(pos);
        if (index >= 0) {
            result = this.data.get(index);
        }
        return result;
    }

    @Override
    public void setValue(int pos, double dValue) {
        this.checkPos(pos);
        float value = (float)dValue;
        int index = this.findIndex(pos);
        if (index >= 0) {
            if (value == this.defaultValue) {
                this.removeElementAt(index);
                this.data.removeElementAt(index);
            } else {
                this.data.set(index, value);
            }
        } else if (value != this.defaultValue) {
            index = -index - 1;
            this.addElementAt(index, pos);
            this.data.add(index, value);
        }
    }

    public boolean equals(Object o) {
        boolean result = false;
        if (o instanceof FloatVector) {
            FloatVector other = (FloatVector)o;
            result = Arrays.equals(this.position, other.position) && this.data.equals((Object)other.data);
        } else if (o instanceof Vector) {
            Vector other = (Vector)o;
            result = true;
            for (int i = 0; i < this.size() && result; ++i) {
                result = this.getValue(i) == other.getValue(i);
            }
        }
        return result;
    }

    protected int findIndex(int pos) {
        return Arrays.binarySearch(this.position, pos);
    }

    protected void ensureCapacity(int mincap) {
        if (mincap > this.position.length) {
            int newcap = this.position.length * 3 / 2 + 1;
            int[] olddata = this.position;
            this.position = new int[newcap >= mincap ? newcap : mincap];
            System.arraycopy(olddata, 0, this.position, 0, this.positionSize);
            for (int i = this.positionSize; i < this.position.length; ++i) {
                this.position[i] = Integer.MAX_VALUE;
            }
        }
    }

    protected void addElementAt(int index, int element) {
        this.ensureCapacity(this.positionSize + 1);
        int numtomove = this.positionSize - index;
        System.arraycopy(this.position, index, this.position, index + 1, numtomove);
        this.position[index] = element;
        ++this.positionSize;
    }

    protected int removeElementAt(int index) {
        int oldval = this.position[index];
        int numtomove = this.positionSize - index - 1;
        if (numtomove > 0) {
            System.arraycopy(this.position, index + 1, this.position, index, numtomove);
        }
        --this.positionSize;
        this.position[this.positionSize] = Integer.MAX_VALUE;
        return oldval;
    }

    @Override
    public boolean isImplementedPaste(Vector v) {
        return v instanceof FloatVector;
    }

    @Override
    public boolean isImplementedAdd(Vector v) {
        return false;
    }

    @Override
    public boolean isImplementedMinus(Vector v) {
        return false;
    }

    @Override
    public boolean isImplementedMap() {
        return true;
    }

    @Override
    public void paste(Vector v) {
        FloatVector fbv = (FloatVector)v;
        this.capacity = fbv.capacity;
        this.defaultValue = fbv.defaultValue;
        this.positionSize = fbv.positionSize;
        this.position = new int[fbv.position.length];
        System.arraycopy(fbv.position, 0, this.position, 0, this.position.length);
        this.data.clear();
        this.data.addAll((FloatCollection)fbv.data);
    }

    @Override
    public void add(Vector v) {
        FloatVector fbv = (FloatVector)v;
        for (int i = 0; i < this.data.size(); ++i) {
            this.data.set(i, this.data.get(i) + fbv.data.get(i));
        }
    }

    @Override
    public void minus(Vector v) {
        FloatVector fbv = (FloatVector)v;
        for (int i = 0; i < this.data.size(); ++i) {
            this.data.set(i, this.data.get(i) - fbv.data.get(i));
        }
    }

    @Override
    public void map(MapFunction f) {
        this.defaultValue = (float)f.apply(this.defaultValue);
        for (int i = this.data.size() - 1; i >= 0; --i) {
            double value = f.apply(this.data.get(i));
            if (value == (double)this.defaultValue) {
                this.removeElementAt(i);
                this.data.removeElementAt(i);
                continue;
            }
            this.data.set(i, (float)value);
        }
    }
}

