/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.math.matrix.gui;

import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JFileChooser;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import javax.swing.filechooser.FileFilter;
import org.nuiton.i18n.I18n;
import org.nuiton.math.matrix.MatrixND;
import org.nuiton.math.matrix.gui.MatrixEditor;
import org.nuiton.util.FileUtil;

@Deprecated
public class MatrixPopupMenu
extends JPopupMenu {
    private static final long serialVersionUID = 3349189688987885915L;
    private MatrixEditor matrixEditor;
    private JFileChooser fileChooser;
    private JMenu sendToClipBoard;
    private JMenu sendToFile;
    private JCheckBoxMenuItem withSemantics;
    private Action sendToClipBoardAllCopyAction;
    private Action sendToClipBoardAllPasteAction;
    private Action sendToClipBoardSelectionCopyAction;
    private Action sendToClipBoardCurrentPasteAction;
    private Action sendToFileAllCopyAction;
    private Action sendToFileAllPasteAction;
    private Action sendToFileSelectionCopyAction;
    private Action sendToFileCurrentPasteAction;

    public MatrixPopupMenu(MatrixEditor matrixEditor) {
        this.matrixEditor = matrixEditor;
        this.sendToClipBoard = this.getSendToClipBoard();
        this.sendToFile = this.getSendToFile();
        this.withSemantics = new JCheckBoxMenuItem(I18n._((String)"lutinmatrix.menu.option.semantics"), false);
        this.add(this.sendToClipBoard);
        this.add(this.sendToFile);
        this.add(new JSeparator());
        this.add(this.withSemantics);
    }

    public JMenu getSendToClipBoard() {
        if (this.sendToClipBoard == null) {
            this.sendToClipBoard = new JMenu(I18n._((String)"lutinmatrix.menu.action"));
            JMenuItem sendToClipBoardAllCopy = new JMenuItem(I18n._((String)"lutinmatrix.menu.action.copy"));
            JMenuItem sendToClipBoardAllPaste = new JMenuItem(I18n._((String)"lutinmatrix.menu.action.paste"));
            JMenuItem sendToClipBoardSelectionCopy = new JMenuItem(I18n._((String)"lutinmatrix.menu.action.copy.selection"));
            JMenuItem sendToClipBoardCurrentPaste = new JMenuItem(I18n._((String)"lutinmatrix.menu.action.paste.position"));
            this.sendToClipBoard.add(sendToClipBoardAllCopy);
            this.sendToClipBoard.add(sendToClipBoardAllPaste);
            this.sendToClipBoard.add(new JSeparator());
            this.sendToClipBoard.add(sendToClipBoardSelectionCopy);
            this.sendToClipBoard.add(sendToClipBoardCurrentPaste);
            sendToClipBoardAllCopy.addActionListener(this.getSendToClipBoardAllCopyAction());
            sendToClipBoardAllPaste.addActionListener(this.getSendToClipBoardAllPasteAction());
            sendToClipBoardSelectionCopy.addActionListener(this.getSendToClipBoardSelectionCopyAction());
            sendToClipBoardCurrentPaste.addActionListener(this.getSendToClipBoardCurrentPasteAction());
        }
        return this.sendToClipBoard;
    }

    public JMenu getSendToFile() {
        if (this.sendToFile == null) {
            this.sendToFile = new JMenu(I18n._((String)"lutinmatrix.menu.csv"));
            JMenuItem sendToFileAllCopy = new JMenuItem(I18n._((String)"lutinmatrix.menu.csv.export.file"));
            JMenuItem sendToFileAllPaste = new JMenuItem(I18n._((String)"lutinmatrix.menu.csv.import.file"));
            JMenuItem sendToFileSelectionCopy = new JMenuItem(I18n._((String)"lutinmatrix.menu.csv.export.selection"));
            JMenuItem sendToFileCurrentPaste = new JMenuItem(I18n._((String)"lutinmatrix.menu.csv.import.position"));
            this.sendToFile.add(sendToFileAllCopy);
            this.sendToFile.add(sendToFileAllPaste);
            this.sendToFile.add(new JSeparator());
            this.sendToFile.add(sendToFileSelectionCopy);
            this.sendToFile.add(sendToFileCurrentPaste);
            sendToFileAllCopy.addActionListener(this.getSendToFileAllCopyAction());
            sendToFileAllPaste.addActionListener(this.getSendToFileAllPasteAction());
            sendToFileSelectionCopy.addActionListener(this.getSendToFileSelectionCopyAction());
            sendToFileCurrentPaste.addActionListener(this.getSendToFileCurrentPasteAction());
        }
        return this.sendToFile;
    }

    private Writer getFileChooserWriter() throws IOException {
        int returnVal = this.getFileChooser().showOpenDialog(this.matrixEditor);
        if (returnVal == 0) {
            File selectedFile = this.getFileChooser().getSelectedFile();
            return FileUtil.getWriter((File)selectedFile);
        }
        return null;
    }

    private Writer getClipBoardWriter() {
        return new StringWriter();
    }

    private Reader getFileChooserReader() throws IOException {
        int returnVal = this.getFileChooser().showOpenDialog(this.matrixEditor);
        if (returnVal == 0) {
            File selectedFile = this.getFileChooser().getSelectedFile();
            return FileUtil.getReader((File)selectedFile);
        }
        return null;
    }

    private Reader getClipBoardReader() {
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        Transferable contents = clipboard.getContents(clipboard);
        if (contents != null) {
            try {
                String data = (String)contents.getTransferData(DataFlavor.stringFlavor);
                return new StringReader(data);
            }
            catch (Exception e) {
                JOptionPane.showMessageDialog(this.matrixEditor, "Impossible de coller les donn\u00e9es", "Warning", 2);
                e.printStackTrace();
            }
        }
        return null;
    }

    @Override
    protected void firePopupMenuWillBecomeVisible() {
        if (!this.getMatrix().isSupportedCSV()) {
            this.sendToClipBoard.setEnabled(false);
            this.sendToFile.setEnabled(false);
        } else {
            this.sendToClipBoard.setEnabled(true);
            this.sendToFile.setEnabled(true);
        }
        super.firePopupMenuWillBecomeVisible();
    }

    private MatrixND getMatrix() {
        return this.matrixEditor.getMatrix();
    }

    private MatrixND getSelectedMatrix() {
        int beginSelectedColumn = this.matrixEditor.getTable().getSelectedColumn();
        int nbSelectedColumn = this.matrixEditor.getTable().getSelectedColumnCount();
        int nbColumnDimRow = this.matrixEditor.getMatrix().getDimCount() - 1;
        if ((beginSelectedColumn -= nbColumnDimRow) < 0) {
            beginSelectedColumn = 0;
            nbSelectedColumn -= nbColumnDimRow;
        }
        int beginSelectedRow = this.matrixEditor.getTable().getSelectedRow() - 1;
        int nbSelectedRow = this.matrixEditor.getTable().getSelectedRowCount();
        MatrixND result = null;
        result = this.getMatrix().getDimCount() == 1 ? this.matrixEditor.getMatrix().getSubMatrix(0, beginSelectedColumn, nbSelectedColumn) : this.matrixEditor.getMatrix().getSubMatrix(0, beginSelectedRow, nbSelectedRow).getSubMatrix(1, beginSelectedColumn, nbSelectedColumn);
        return result;
    }

    private int[] getCoordinatesFirstCellSelectedMatrix() {
        int selectedColumn = this.matrixEditor.getTable().getSelectedColumn();
        int nbColumnDimRow = this.matrixEditor.getMatrix().getDimCount() - 1;
        if ((selectedColumn -= nbColumnDimRow) < 0) {
            selectedColumn = 0;
        }
        int selectedRow = this.matrixEditor.getTable().getSelectedRow() - 1;
        return new int[]{selectedRow, selectedColumn};
    }

    private JFileChooser getFileChooser() {
        if (this.fileChooser == null) {
            this.fileChooser = new JFileChooser();
            FileFilter filter = new FileFilter(){

                @Override
                public boolean accept(File pathname) {
                    if (pathname.isDirectory()) {
                        return true;
                    }
                    String extension = FileUtil.extension((File)pathname, (String[])new String[0]);
                    if (extension != null) {
                        return extension.equals("csv");
                    }
                    return false;
                }

                @Override
                public String getDescription() {
                    return "Texte CSV (*.csv)";
                }
            };
            this.fileChooser.setFileFilter(filter);
        }
        return this.fileChooser;
    }

    public Action getSendToClipBoardAllCopyAction() {
        if (this.sendToClipBoardAllCopyAction == null) {
            this.sendToClipBoardAllCopyAction = new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    MatrixPopupMenu.this.sendToClipBoardAllCopyPerformed();
                }
            };
        }
        return this.sendToClipBoardAllCopyAction;
    }

    public Action getSendToClipBoardAllPasteAction() {
        if (this.sendToClipBoardAllPasteAction == null) {
            this.sendToClipBoardAllPasteAction = new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    MatrixPopupMenu.this.sendToClipBoardAllPastePerformed();
                }
            };
        }
        return this.sendToClipBoardAllPasteAction;
    }

    public Action getSendToClipBoardSelectionCopyAction() {
        if (this.sendToClipBoardSelectionCopyAction == null) {
            this.sendToClipBoardSelectionCopyAction = new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    MatrixPopupMenu.this.sendToClipBoardSelectionCopyPerformed();
                }
            };
        }
        return this.sendToClipBoardSelectionCopyAction;
    }

    public Action getSendToClipBoardCurrentPasteAction() {
        if (this.sendToClipBoardCurrentPasteAction == null) {
            this.sendToClipBoardCurrentPasteAction = new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    MatrixPopupMenu.this.sendToClipBoardCurrentPastePerformed();
                }
            };
        }
        return this.sendToClipBoardCurrentPasteAction;
    }

    protected void sendToClipBoardAllCopyPerformed() {
        try {
            Writer writer = this.getClipBoardWriter();
            this.getMatrix().exportCSV(writer, this.withSemantics.getState());
            StringSelection contents = new StringSelection(writer.toString());
            Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
            clipboard.setContents(contents, contents);
            writer.close();
            this.matrixEditor.repaint();
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this.matrixEditor, I18n._((String)"lutinmatrix.error.clipboard.write"), I18n._((String)"lutinmatrix.error"), 0);
            e.printStackTrace();
        }
    }

    protected void sendToClipBoardAllPastePerformed() {
        try {
            Reader reader = this.getClipBoardReader();
            this.getMatrix().importCSV(reader, new int[]{0, 0});
            reader.close();
            this.matrixEditor.fireEvent();
            this.matrixEditor.repaint();
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this.matrixEditor, I18n._((String)"lutinmatrix.error.clipboard.read"), I18n._((String)"lutinmatrix.error"), 0);
            e.printStackTrace();
        }
    }

    protected void sendToClipBoardSelectionCopyPerformed() {
        try {
            Writer writer = this.getClipBoardWriter();
            this.getSelectedMatrix().exportCSV(writer, this.withSemantics.getState());
            StringSelection contents = new StringSelection(writer.toString());
            Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
            clipboard.setContents(contents, contents);
            writer.close();
            this.matrixEditor.repaint();
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this.matrixEditor, I18n._((String)"lutinmatrix.error.clipboard.write"), I18n._((String)"lutinmatrix.error"), 0);
            e.printStackTrace();
        }
    }

    protected void sendToClipBoardCurrentPastePerformed() {
        try {
            Reader reader = this.getClipBoardReader();
            this.getMatrix().importCSV(reader, this.getCoordinatesFirstCellSelectedMatrix());
            reader.close();
            this.matrixEditor.fireEvent();
            this.matrixEditor.repaint();
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this.matrixEditor, I18n._((String)"lutinmatrix.error.clipboard.read"), I18n._((String)"lutinmatrix.error"), 0);
            e.printStackTrace();
        }
    }

    public Action getSendToFileAllCopyAction() {
        if (this.sendToFileAllCopyAction == null) {
            this.sendToFileAllCopyAction = new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    MatrixPopupMenu.this.sendToFileAllCopyPerformed();
                }
            };
        }
        return this.sendToFileAllCopyAction;
    }

    public Action getSendToFileAllPasteAction() {
        if (this.sendToFileAllPasteAction == null) {
            this.sendToFileAllPasteAction = new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    MatrixPopupMenu.this.sendToFileAllPastePerformed();
                }
            };
        }
        return this.sendToFileAllPasteAction;
    }

    public Action getSendToFileSelectionCopyAction() {
        if (this.sendToFileSelectionCopyAction == null) {
            this.sendToFileSelectionCopyAction = new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    MatrixPopupMenu.this.sendToFileSelectionCopyPerformed();
                }
            };
        }
        return this.sendToFileSelectionCopyAction;
    }

    public Action getSendToFileCurrentPasteAction() {
        if (this.sendToFileCurrentPasteAction == null) {
            this.sendToFileCurrentPasteAction = new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    MatrixPopupMenu.this.sendToFileCurrentPastePerformed();
                }
            };
        }
        return this.sendToFileCurrentPasteAction;
    }

    protected void sendToFileAllCopyPerformed() {
        try {
            Writer writer = this.getFileChooserWriter();
            if (writer != null) {
                this.getMatrix().exportCSV(writer, this.withSemantics.getState());
                writer.close();
                this.matrixEditor.repaint();
            }
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this.matrixEditor, I18n._((String)"lutinmatrix.error.file.write"), I18n._((String)"lutinmatrix.error"), 0);
            e.printStackTrace();
        }
    }

    protected void sendToFileAllPastePerformed() {
        try {
            Reader reader = this.getFileChooserReader();
            if (reader != null) {
                this.getMatrix().importCSV(reader, new int[]{0, 0});
                reader.close();
                this.matrixEditor.fireEvent();
                this.matrixEditor.repaint();
            }
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this.matrixEditor, I18n._((String)"lutinmatrix.error.file.read"), I18n._((String)"lutinmatrix.error"), 0);
            e.printStackTrace();
        }
    }

    protected void sendToFileSelectionCopyPerformed() {
        try {
            Writer writer = this.getFileChooserWriter();
            if (writer != null) {
                this.getSelectedMatrix().exportCSV(writer, this.withSemantics.getState());
                writer.close();
                this.matrixEditor.repaint();
            }
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this.matrixEditor, I18n._((String)"lutinmatrix.error.file.write"), I18n._((String)"lutinmatrix.error"), 0);
            e.printStackTrace();
        }
    }

    protected void sendToFileCurrentPastePerformed() {
        try {
            Reader reader = this.getFileChooserReader();
            if (reader != null) {
                this.getMatrix().importCSV(reader, this.getCoordinatesFirstCellSelectedMatrix());
                reader.close();
                this.matrixEditor.fireEvent();
                this.matrixEditor.repaint();
            }
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this.matrixEditor, I18n._((String)"lutinmatrix.error.file.read"), I18n._((String)"lutinmatrix.error"), 0);
            e.printStackTrace();
        }
    }
}

