/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.math.matrix.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import jaxx.runtime.DataBindingListener;
import jaxx.runtime.DefaultJAXXContext;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXInitialContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.Util;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;
import org.nuiton.math.matrix.MatrixFactory;
import org.nuiton.math.matrix.MatrixND;
import org.nuiton.math.matrix.gui.MatrixEditor;
import org.nuiton.math.matrix.gui.MatrixPanelEvent;
import org.nuiton.math.matrix.gui.MatrixPanelListener;
import org.nuiton.math.matrix.gui.MatrixPopupMenu;
import org.nuiton.math.matrix.gui.MatrixTableModel;
import org.nuiton.math.matrix.gui.MatrixTableModelLinear;
import org.nuiton.math.matrix.gui.MatrixTableModelND;
import org.nuiton.util.ListenerSet;

public class JAXXMatrixEditor
extends MatrixEditor
implements JAXXObject {
    public static final Log log = LogFactory.getLog(JAXXMatrixEditor.class);
    private static String $jaxxObjectDescriptor = "H4sIAAAAAAAAAK1UPW9TMRR1QpO2CekXpTBQ0UK3Si9QhJBoVegHFa0SQA1DRRacPJO4cmxj+7WvDAiJFaFODCzAzsiOECMTK/8BIf4B134veWkJtBJkcKJ7zz0+9/qevP+OMlqh6W0chp4KuKEt4m0sbW3drW2Tulkluq6oNEKh6JNKo3QV5f1OXBt0sVqy5cW4vLgiWlJwwruq50sop80eI7pJiDHodFRR17pY6YTnQxmoNltHTC+2tz9/pPf9Z+/SCIUSVOWhhamjqpIO+kooTX2DxuCmHVxkmDdAhqK8AToLNrbCsNZ3cIs8Rk9RfwllJVZAZtCF47fqOFx9KA0atnVlDLfAyQkzaFaohscDagT3Wtg07QFZrxFQ9wIR+JYPACWlY8oalDO4xkhZ+EdRROX3O+iEIs8oJ1jFHKO2X8/OwFsWghHME+REF7LSFLur5BEOmLHZ0QRV8GEUXFPBrdhDyVMzFTeYdU4NxYw+IeqSQefdY9VhepQR5f0G+Wv9ZZs6+1fI3CHIAAFlS4pgg87YfkNP78JzextQKRi7By9ikYOdgowbM6zIAbSbpkVMJu9RC4yJOgclB9DLLhPzKpu0PWvtJSuf7GSqijIqgLBBI9XEHZsQinwRRx2Bi755/nrn1YeP19smyMIdhQOQLs/CUkolJFGG2iuGo80PDGXFMpbzVTSoCQPDO0OPdwmoxGEQAfzRstgy7zbWTSjN9H/79Hni4dcTKL2Gckxgfw1b/DoaNE0FXQrmh/LGTafk5O4AnCNWk0FZhvcEjAgNLfjY4Kka5T7MbTGEZse7mu0o+LL/onzu5eS1dsOpSNAhWNJ05gHKUm5X2Pk9tnJPf+elJoEvEsv2MnHKfudkvFWz7iz26mwIB0ZsEg2baK1jcXNhYL+uONn211XHNn0MtvE6YSzqzlqM2x30/5GzoNt8/0FgnyEhPOPYQjTsKWzgnwdsQRZ7c84cg7N/h2oam+0P0izNL/yVEdK/BgAA";
    protected List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected JButton buttonEdit;
    protected final JAXXContext delegateContext = new DefaultJAXXContext((JAXXObject)this);
    protected Boolean dimensionEdit;
    protected JScrollPane editArea;
    protected JAXXMatrixEditor jaxxMatrixManel = this;
    protected Boolean linearModel;
    protected Boolean linearModelShowDefault;
    protected JTable table;
    protected MatrixTableModel tableModel;
    private boolean allComponentsCreated;
    private boolean contextInitialized = true;
    Map $previousValues = new HashMap();
    private PropertyChangeListener $DataSource7 = new DataBindingListener((JAXXObject)this.jaxxMatrixManel, "buttonEdit.visible");
    private static final int DEFAULT_WIDTH = 150;
    private static final int DEFAULT_HEIGHT = 150;
    protected ListenerSet<MatrixPanelListener> listeners;
    protected MatrixPopupMenu popupMenu;
    protected MatrixND matrix;

    public JAXXMatrixEditor(MatrixND m, boolean dimensionEdit) {
        this(dimensionEdit, 150, 150);
    }

    public JAXXMatrixEditor(boolean dimensionEdit, int width, int height) {
        this.dimensionEdit = dimensionEdit;
        this.setPreferredSize(new Dimension(width, height));
        this.$initialize();
    }

    public JAXXMatrixEditor(boolean dimensionEdit) {
        this(dimensionEdit, 150, 150);
    }

    @Override
    public void setMatrix(MatrixND m) {
        this.matrix = m;
        this.initObject();
    }

    @Override
    public MatrixND getMatrix() {
        return this.matrix;
    }

    protected MatrixFactory getFactory() {
        return MatrixFactory.getInstance();
    }

    @Deprecated
    public void addMatrixListener(MatrixPanelListener l) {
        this.listeners.add((Object)l);
    }

    public void addMatrixPanelListener(MatrixPanelListener l) {
        this.listeners.add((Object)l);
    }

    public void removeMatrixPanelListener(MatrixPanelListener l) {
        this.listeners.remove((Object)l);
    }

    public MatrixPanelListener[] getMatrixPanelListeners() {
        ArrayList r = new ArrayList();
        Iterator itr = this.listeners.iterator();
        while (itr.hasNext()) {
            r.add(itr.next());
        }
        return r.toArray(new MatrixPanelListener[r.size()]);
    }

    protected void initObject() {
        if (this.getMatrix() == null) {
            this.editArea.setViewportView(null);
        } else {
            this.popupMenu = new MatrixPopupMenu(this);
            Util.assignment((Object)this.popupMenu, (String)"popupMenu", (JAXXObject)this);
            this.table = new JTable(){

                @Override
                public void processMouseEvent(MouseEvent event) {
                    if (event.isPopupTrigger()) {
                        JAXXMatrixEditor.this.popupMenu.show(event.getComponent(), event.getX(), event.getY());
                    }
                    super.processMouseEvent(event);
                }
            };
            this.table.getInputMap().put(KeyStroke.getKeyStroke(67, 2), "copy");
            this.table.getActionMap().put("copy", this.popupMenu.getSendToClipBoardSelectionCopyAction());
            this.table.getInputMap().put(KeyStroke.getKeyStroke(86, 2), "paste");
            this.table.getActionMap().put("paste", this.popupMenu.getSendToClipBoardCurrentPasteAction());
            if (this.isLinearModel().booleanValue()) {
                this.setTableModel(new MatrixTableModelLinear(this.getMatrix(), this.isLinearModelShowDefault()));
            } else {
                this.setTableModel(new MatrixTableModelND(this.getMatrix()));
            }
            this.getTableModel().addTableModelListener(new TableModelListener(){

                @Override
                public void tableChanged(TableModelEvent e) {
                    JAXXMatrixEditor.this.fireEvent();
                }
            });
            this.table.setModel(this.getTableModel());
            this.table.setDefaultRenderer(String.class, this.tableModel.getMatrixCellRenderer());
            this.table.setAutoResizeMode(0);
            this.table.setSelectionMode(1);
            this.editArea.setViewportView(this.table);
        }
        this.repaint();
    }

    protected void btnAction() {
        String dim = JOptionPane.showInputDialog(null, I18n._((String)"lutinmatrix.create.matrix.message"), I18n._((String)"lutinmatrix.create.matrix.title"), -1);
        if (dim != null) {
            String[] sdim = dim.split(";");
            int[] idim = new int[sdim.length];
            for (int i = 0; i < idim.length; ++i) {
                idim[i] = Integer.parseInt(sdim[i]);
            }
            this.setMatrix(this.getFactory().create(idim));
        }
    }

    @Override
    protected void fireEvent() {
        MatrixPanelEvent e = new MatrixPanelEvent(this);
        for (MatrixPanelListener l : this.listeners) {
            l.matrixChanged(e);
        }
    }

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return Util.decodeCompressedJAXXObjectDescriptor((String)$jaxxObjectDescriptor);
    }

    public JAXXMatrixEditor() {
        this.$initialize();
    }

    public JAXXMatrixEditor(JAXXContext parentContext) {
        if (parentContext instanceof JAXXInitialContext) {
            ((JAXXInitialContext)parentContext).to((JAXXContext)this);
        } else {
            this.setContextValue(parentContext);
        }
        this.$initialize();
    }

    public void applyDataBinding(String $binding) {
        if ("buttonEdit.visible".equals($binding)) {
            this.addPropertyChangeListener("dimensionEdit", this.$DataSource7);
        }
        this.processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    public Map<String, Object> get$objectMap() {
        return this.$objectMap;
    }

    public Object getObjectById(String id) {
        return this.$objectMap.get(id);
    }

    public void processDataBinding(String dest) {
        this.processDataBinding(dest, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processDataBinding(String $dest, boolean $force) {
        if (!$force && this.$activeBindings.contains($dest)) {
            return;
        }
        this.$activeBindings.add($dest);
        try {
            if ("buttonEdit.visible".equals($dest)) {
                this.buttonEdit.setVisible(this.isDimensionEdit());
            }
        }
        finally {
            this.$activeBindings.remove($dest);
        }
    }

    public void removeDataBinding(String $binding) {
        if ("buttonEdit.visible".equals($binding)) {
            this.removePropertyChangeListener("dimensionEdit", this.$DataSource7);
        }
    }

    public <T> T getContextValue(Class<T> clazz) {
        return (T)this.delegateContext.getContextValue(clazz, null);
    }

    public <T> T getContextValue(Class<T> clazz, String name) {
        return (T)this.delegateContext.getContextValue(clazz, name);
    }

    public JAXXContext getDelegateContext() {
        return this.delegateContext;
    }

    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return (O)this.delegateContext.getParentContainer(clazz);
    }

    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return (O)this.delegateContext.getParentContainer(source, clazz);
    }

    public <T> void removeContextValue(Class<T> clazz) {
        this.delegateContext.removeContextValue(clazz, null);
    }

    public <T> void removeContextValue(Class<T> clazz, String name) {
        this.delegateContext.removeContextValue(clazz, name);
    }

    public <T> void setContextValue(T o) {
        this.delegateContext.setContextValue(o, null);
    }

    public <T> void setContextValue(T o, String name) {
        this.delegateContext.setContextValue(o, name);
    }

    public void doActionPerformed__on__buttonEdit(ActionEvent event) {
        this.btnAction();
    }

    public List<Object> get$activeBindings() {
        return this.$activeBindings;
    }

    public Map<String, Object> get$bindingSources() {
        return this.$bindingSources;
    }

    @Override
    public JButton getButtonEdit() {
        return this.buttonEdit;
    }

    public Boolean getDimensionEdit() {
        return this.dimensionEdit;
    }

    public JScrollPane getEditArea() {
        return this.editArea;
    }

    public JAXXMatrixEditor getJaxxMatrixManel() {
        return this.jaxxMatrixManel;
    }

    public Boolean getLinearModel() {
        return this.linearModel;
    }

    public Boolean getLinearModelShowDefault() {
        return this.linearModelShowDefault;
    }

    @Override
    public JTable getTable() {
        return this.table;
    }

    public MatrixTableModel getTableModel() {
        return this.tableModel;
    }

    public Boolean isDimensionEdit() {
        return this.dimensionEdit != null && this.dimensionEdit != false;
    }

    @Override
    public Boolean isLinearModel() {
        return this.linearModel != null && this.linearModel != false;
    }

    @Override
    public Boolean isLinearModelShowDefault() {
        return this.linearModelShowDefault != null && this.linearModelShowDefault != false;
    }

    public void setDimensionEdit(Boolean newValue) {
        Boolean oldValue = this.dimensionEdit;
        this.dimensionEdit = newValue;
        this.firePropertyChange("dimensionEdit", oldValue, newValue);
    }

    @Override
    public void setLinearModel(Boolean newValue) {
        Boolean oldValue = this.linearModel;
        this.linearModel = newValue;
        this.firePropertyChange("linearModel", oldValue, newValue);
    }

    @Override
    public void setLinearModelShowDefault(Boolean newValue) {
        Boolean oldValue = this.linearModelShowDefault;
        this.linearModelShowDefault = newValue;
        this.firePropertyChange("linearModelShowDefault", oldValue, newValue);
    }

    public void setTableModel(MatrixTableModel newValue) {
        MatrixTableModel oldValue = this.tableModel;
        this.tableModel = newValue;
        this.firePropertyChange("tableModel", oldValue, newValue);
    }

    protected String get$jaxxObjectDescriptor() {
        return $jaxxObjectDescriptor;
    }

    protected Map get$previousValues() {
        return this.$previousValues;
    }

    protected boolean getAllComponentsCreated() {
        return this.allComponentsCreated;
    }

    protected boolean getContextInitialized() {
        return this.contextInitialized;
    }

    protected Log getLog() {
        return log;
    }

    private void $completeSetup() {
        this.allComponentsCreated = true;
        this.addChildrenToJaxxMatrixManel();
        this.addChildrenToEditArea();
        this.table.setAutoResizeMode(0);
        this.table.setCellSelectionEnabled(true);
        this.table.setSelectionMode(1);
        this.applyDataBinding("buttonEdit.visible");
    }

    private void $initialize() {
        if (this.allComponentsCreated || !this.contextInitialized) {
            return;
        }
        this.$objectMap.put("jaxxMatrixManel", this);
        this.createTableModel();
        this.createLinearModel();
        this.createLinearModelShowDefault();
        this.createDimensionEdit();
        this.listeners = new ListenerSet();
        this.popupMenu = null;
        this.matrix = null;
        this.createEditArea();
        this.createTable();
        this.createButtonEdit();
        this.jaxxMatrixManel.setName("jaxxMatrixManel");
        this.jaxxMatrixManel.setLayout(new BorderLayout());
        this.initObject();
        this.$completeSetup();
    }

    protected void addChildrenToEditArea() {
        if (!this.allComponentsCreated) {
            return;
        }
        this.editArea.getViewport().add(this.table);
    }

    protected void addChildrenToJaxxMatrixManel() {
        if (!this.allComponentsCreated) {
            return;
        }
        this.jaxxMatrixManel.add((Component)this.editArea, "Center");
        this.jaxxMatrixManel.add((Component)this.buttonEdit, "South");
    }

    protected void createButtonEdit() {
        this.buttonEdit = new JButton();
        this.$objectMap.put("buttonEdit", this.buttonEdit);
        this.buttonEdit.setName("buttonEdit");
        this.buttonEdit.setText(I18n._((String)"lutinmatrix.create.matrix.button"));
        this.buttonEdit.addActionListener((ActionListener)Util.getEventListener(ActionListener.class, (String)"actionPerformed", (Object)this.jaxxMatrixManel, (String)"doActionPerformed__on__buttonEdit"));
    }

    protected void createDimensionEdit() {
        this.dimensionEdit = false;
        this.$objectMap.put("dimensionEdit", this.dimensionEdit);
    }

    protected void createEditArea() {
        this.editArea = new JScrollPane();
        this.$objectMap.put("editArea", this.editArea);
        this.editArea.setName("editArea");
    }

    protected void createLinearModel() {
        this.linearModel = false;
        this.$objectMap.put("linearModel", this.linearModel);
    }

    protected void createLinearModelShowDefault() {
        this.linearModelShowDefault = false;
        this.$objectMap.put("linearModelShowDefault", this.linearModelShowDefault);
    }

    protected void createTable() {
        this.table = new JTable();
        this.$objectMap.put("table", this.table);
        this.table.setName("table");
    }

    protected void createTableModel() {
        this.tableModel = null;
        this.$objectMap.put("tableModel", this.tableModel);
    }
}

