/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.math.matrix;

import java.lang.reflect.Constructor;
import java.util.List;
import org.nuiton.math.matrix.DoubleBigVector;
import org.nuiton.math.matrix.MatrixND;
import org.nuiton.math.matrix.MatrixNDImpl;
import org.nuiton.math.matrix.Vector;

public class MatrixFactory {
    protected static Class<?> defaultVectorClass = DoubleBigVector.class;
    protected Class<?> vectorClass = null;

    protected MatrixFactory(Class<?> vectorClass) {
        this.vectorClass = vectorClass;
    }

    public static void setDefaultVectorClass(Class<?> vectorClass) {
        defaultVectorClass = vectorClass;
    }

    public static Class<?> getDefaultVectorClass() {
        return defaultVectorClass;
    }

    public static MatrixFactory getInstance(Class<?> vectorClass) {
        return new MatrixFactory(vectorClass);
    }

    public static MatrixFactory getInstance() {
        return MatrixFactory.getInstance(defaultVectorClass);
    }

    public MatrixND create(int[] dim) {
        return new MatrixNDImpl(this, dim);
    }

    public MatrixND create(double[] values, int[] dim) {
        int i;
        if (dim.length > 2) {
            return null;
        }
        MatrixNDImpl matrix = new MatrixNDImpl(this, dim);
        if (dim.length == 2) {
            for (i = 0; i < dim[0]; ++i) {
                for (int j = 0; j < dim[1]; ++j) {
                    int[] coordinates = new int[]{i, j};
                    matrix.setValue(coordinates, values[i * dim[1] + j]);
                }
            }
        }
        if (dim.length == 1) {
            for (i = 0; i < dim[0]; ++i) {
                int[] coordinates = new int[]{i};
                matrix.setValue(coordinates, values[i]);
            }
        }
        return matrix;
    }

    public MatrixND create(List<Object>[] semantics) {
        return new MatrixNDImpl(this, semantics);
    }

    public MatrixND create(String name, int[] dim) {
        return new MatrixNDImpl(this, name, dim);
    }

    public MatrixND create(String name, int[] dim, String[] dimNames) {
        return new MatrixNDImpl(this, name, dim, dimNames);
    }

    public MatrixND create(String name, List<?>[] semantics) {
        return new MatrixNDImpl(this, name, semantics);
    }

    public MatrixND create(String name, List<?>[] semantics, String[] dimNames) {
        return new MatrixNDImpl(this, name, semantics, dimNames);
    }

    public MatrixND create(MatrixND matrix) {
        return new MatrixNDImpl(this, matrix);
    }

    public MatrixND matrixId(int size) {
        MatrixND result = this.create(new int[]{size, size});
        for (int i = 0; i < size; ++i) {
            result.setValue(i, i, 1.0);
        }
        return result;
    }

    protected Vector createVector(int length) {
        try {
            Constructor<?> c = this.vectorClass.getConstructor(Integer.TYPE);
            return (Vector)c.newInstance(length);
        }
        catch (Exception eee) {
            throw new RuntimeException("Can't create vector", eee);
        }
    }
}

