/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.j2r.types;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.j2r.REngine;
import org.nuiton.j2r.RException;
import org.nuiton.j2r.types.REXP;
import org.nuiton.j2r.types.REXPAbstract;

public class RDataFrame
extends REXPAbstract
implements REXP {
    private Log log;
    private List<String> rowNames;
    private List<List<?>> data;

    public RDataFrame(REngine engine) {
        this.log = LogFactory.getLog(RDataFrame.class);
        this.names = new ArrayList();
        this.rowNames = new ArrayList<String>();
        this.data = new ArrayList();
        this.variable = "";
        this.engine = engine;
        this.attributes = new HashMap();
    }

    public RDataFrame(REngine engine, Object[] datatypes, int y) throws RException {
        this.log = LogFactory.getLog(RDataFrame.class);
        this.names = new ArrayList();
        this.rowNames = new ArrayList<String>();
        this.data = new ArrayList();
        for (Object datatype : datatypes) {
            this.checkType(datatype);
            ArrayList<Object> column = new ArrayList<Object>();
            for (int j = 0; j < y; ++j) {
                if (datatype instanceof Double) {
                    column.add(0.0);
                    continue;
                }
                if (datatype instanceof Integer) {
                    column.add(0);
                    continue;
                }
                if (datatype instanceof Boolean) {
                    column.add(true);
                    continue;
                }
                if (!(datatype instanceof String)) continue;
                column.add("");
            }
            this.data.add(column);
        }
        this.variable = "";
        this.engine = engine;
        this.attributes = new HashMap();
    }

    public RDataFrame(REngine engine, List<String> names, List<String> rowNames, List<List<?>> data, String variable) throws RException {
        this.log = LogFactory.getLog(RDataFrame.class);
        this.names = names;
        this.rowNames = rowNames;
        this.data = data;
        this.variable = variable;
        this.engine = engine;
        this.attributes = new HashMap();
        try {
            engine.eval(this.toRString());
        }
        catch (RException eee) {
            throw new RException("Cannot initialize data.frame in R", eee);
        }
    }

    public RDataFrame(REngine engine, String[] names, String[] rowNames, List<List<?>> data, String variable) {
        block4: {
            this.log = LogFactory.getLog(RDataFrame.class);
            String[] tempNames = new String[]{};
            if (names != null) {
                tempNames = (String[])names.clone();
            }
            String[] tempRowNames = new String[]{};
            if (rowNames != null) {
                tempRowNames = (String[])rowNames.clone();
            }
            this.names = new ArrayList();
            this.names.addAll(Arrays.asList(tempNames));
            this.rowNames = new ArrayList<String>();
            this.rowNames.addAll(Arrays.asList(tempRowNames));
            this.data = data;
            this.variable = variable;
            this.engine = engine;
            this.attributes = new HashMap();
            try {
                engine.eval(this.toRString());
            }
            catch (RException eee) {
                if (!this.log.isDebugEnabled()) break block4;
                this.log.debug((Object)("Cannot initialize data.frame in R : " + eee.getMessage()));
            }
        }
    }

    public List<String> getRowNames() throws RException {
        if (this.engine.isAutoCommit().booleanValue()) {
            String[] rowNamesArray = (String[])this.engine.eval(String.format("row.names(%s)", this.variable));
            if (rowNamesArray.length <= this.data.get(0).size()) {
                this.rowNames.clear();
                this.rowNames.addAll(Arrays.asList(rowNamesArray));
                return this.rowNames;
            }
            throw new IndexOutOfBoundsException(String.format(this.dataInconsistencyText, rowNamesArray.length, this.data.get(0)));
        }
        return this.rowNames;
    }

    public String getRowName(int y) throws RException {
        if (y < this.rowNames.size()) {
            String name;
            if (this.engine.isAutoCommit().booleanValue() && (name = (String)this.engine.eval(String.format("row.names(%s)[%s]", this.variable, y + 1))) != null && !name.equals("")) {
                this.rowNames.set(y, name);
            }
        } else {
            throw new IndexOutOfBoundsException(String.format(this.indexExceptionText, y, this.rowNames.size()));
        }
        return this.rowNames.get(y);
    }

    public void setRowNames(List<String> rowNames) throws RException {
        StringBuilder rowNamesString;
        if (rowNames.size() == this.data.get(0).size()) {
            this.rowNames = rowNames;
            rowNamesString = new StringBuilder();
            for (int i = 0; i < this.rowNames.size(); ++i) {
                if (i != 0) {
                    rowNamesString.append(",");
                }
                rowNamesString.append("\"");
                rowNamesString.append(rowNames.get(i));
                rowNamesString.append("\"");
            }
        } else {
            throw new IndexOutOfBoundsException(String.format(this.indexExceptionText, rowNames.size(), this.data.get(0).size()));
        }
        String rexp = String.format("row.names(%s)<-c(%s)", this.variable, rowNamesString.toString());
        this.engine.voidEval(rexp);
    }

    public void setRowName(int x, String rowName) throws RException {
        if (x >= this.rowNames.size()) {
            throw new IndexOutOfBoundsException(String.format(this.indexExceptionText, x, this.data.size()));
        }
        this.rowNames.set(x, rowName);
        String rexp = String.format("row.names(%s)[%s]<-\"%s\"", this.variable, x + 1, rowName);
        this.engine.voidEval(rexp);
    }

    @Override
    public String toRString() throws RException {
        this.checkVariable();
        StringBuilder returnString = new StringBuilder();
        returnString.append(this.variable);
        returnString.append("<-data.frame(");
        for (List<?> column : this.data) {
            if (column.isEmpty()) continue;
            if (!this.names.isEmpty()) {
                int index = this.data.indexOf(column);
                returnString.append((String)this.names.get(index));
                returnString.append("=c(");
            } else {
                returnString.append("c(");
            }
            Object firstElement = column.get(0);
            if (firstElement instanceof String) {
                for (Object obj : column) {
                    returnString.append("\"");
                    returnString.append(obj);
                    returnString.append("\",");
                }
            } else if (firstElement instanceof Boolean) {
                for (Object obj : column) {
                    if (((Boolean)obj).booleanValue()) {
                        returnString.append("TRUE,");
                        continue;
                    }
                    returnString.append("FALSE,");
                }
            } else if (firstElement instanceof Integer) {
                for (Object obj : column) {
                    returnString.append(String.format("as.integer(%s)", obj));
                    returnString.append(",");
                }
            } else {
                for (Object obj : column) {
                    returnString.append(obj);
                    returnString.append(",");
                }
            }
            returnString = new StringBuilder(returnString.substring(0, returnString.length() - 1));
            returnString.append("),");
        }
        if (!this.rowNames.isEmpty()) {
            returnString.append("row.names=c(");
            for (String rowName : this.rowNames) {
                returnString.append("\"");
                returnString.append(rowName);
                returnString.append("\",");
            }
            returnString = new StringBuilder(returnString.substring(0, returnString.length() - 1));
            returnString.append("),stringsAsFactors=FALSE)");
        } else if (this.data.isEmpty()) {
            returnString.append(")");
        } else {
            returnString.append("stringsAsFactors=FALSE)");
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)returnString);
        }
        return returnString.toString();
    }

    public void set(int x, int y, Double data) throws RException {
        this.checkVariable();
        this.checkX(x);
        this.checkY(y);
        try {
            if (!(this.data.get(x).get(y) instanceof Double)) {
                throw new RException("The data.frame does not accept this type on those coordinates : " + data.getClass());
            }
            ((ArrayList)this.data.get(x)).set(y, data);
            this.engine.voidEval(String.format("%s[%s,%s]<-%s", this.variable, y + 1, x + 1, data));
        }
        catch (ClassCastException eee) {
            throw new RException("The data.frame does not accept this type on those coordinates : " + data.getClass(), eee);
        }
    }

    public void set(int x, int y, Boolean data) throws RException {
        block5: {
            this.checkVariable();
            this.checkX(x);
            this.checkY(y);
            try {
                if (this.data.get(x).get(y) instanceof Boolean) {
                    ((ArrayList)this.data.get(x)).set(y, data);
                    if (data.booleanValue()) {
                        this.engine.voidEval(String.format("%s[%s,%s]<-%s", this.variable, y + 1, x + 1, "TRUE"));
                    } else {
                        this.engine.voidEval(String.format("%s[%s,%s]<-%s", this.variable, y + 1, x + 1, "FALSE"));
                    }
                    break block5;
                }
                throw new RException("The data.frame does not accept this type on those coordinates : " + data.getClass());
            }
            catch (ClassCastException eee) {
                throw new RException("The data.frame does not accept this type on those coordinates : " + data.getClass(), eee);
            }
        }
    }

    public void set(int x, int y, String data) throws RException {
        this.checkVariable();
        this.checkX(x);
        this.checkY(y);
        try {
            if (!(this.data.get(x).get(y) instanceof String)) {
                throw new RException("The data.frame does not accept this type on those coordinates : " + data.getClass());
            }
            ((ArrayList)this.data.get(x)).set(y, data);
            this.engine.voidEval(String.format("%s[%s,%s]<-%s", this.variable, y + 1, x + 1, "\"" + data + "\""));
        }
        catch (ClassCastException eee) {
            throw new RException("The data.frame does not accept this type on those coordinates : " + data.getClass(), eee);
        }
    }

    public void set(int x, int y, Integer data) throws RException {
        this.checkVariable();
        this.checkX(x);
        this.checkY(y);
        try {
            if (!(this.data.get(x).get(y) instanceof Integer)) {
                throw new RException("The data.frame does not accept this type on those coordinates : " + data.getClass());
            }
            ((ArrayList)this.data.get(x)).set(y, data);
            this.engine.voidEval(String.format("%s[%s,%s]<-%s", this.variable, y + 1, x + 1, String.format("as.integer(%s)", data)));
        }
        catch (ClassCastException eee) {
            throw new RException("The data.frame does not accept this type on those coordinates : " + data.getClass(), eee);
        }
    }

    public Object get(int x, int y) throws RException {
        this.checkX(x);
        this.checkY(y);
        if (this.engine.isAutoCommit().booleanValue()) {
            this.checkVariable();
            Object returnObject = this.engine.eval(String.format("%s[%s,%s]", this.variable, y + 1, x + 1));
            ((ArrayList)this.data.get(x)).set(y, returnObject);
        }
        return this.data.get(x).get(y);
    }

    public List<List<?>> getData() {
        if (this.engine.isAutoCommit().booleanValue()) {
            int columnNumber;
            int rowNumber;
            try {
                this.checkVariable();
                int[] dim = this.dim();
                rowNumber = dim[0];
                columnNumber = dim[1];
            }
            catch (RException eee) {
                return this.data;
            }
            this.initData(rowNumber, columnNumber);
            try {
                for (int i = 0; i < columnNumber; ++i) {
                    for (int j = 0; j < rowNumber; ++j) {
                        this.get(i, j);
                    }
                }
            }
            catch (RException eee) {
                this.log.error((Object)"An error occurred while trying to contact R");
            }
        }
        return this.data;
    }

    private void initData(int rowNumber, int columnNumber) {
        this.data = new ArrayList();
        for (int i = 0; i < columnNumber; ++i) {
            ArrayList<Object> column = new ArrayList<Object>();
            for (int j = 0; j < rowNumber; ++j) {
                column.add(new Object());
            }
            this.data.add(column);
        }
    }

    public void setData(List<List<?>> data) throws RException {
        this.data = data;
        this.engine.voidEval(this.toRString());
    }

    @Override
    public void getFrom(String variable) throws RException {
        this.variable = variable;
        if (this.engine.isAutoCommit().booleanValue()) {
            this.rowNames.clear();
            this.names.clear();
            this.data.clear();
            this.attributes.clear();
            this.getData();
            this.getRowNames();
            this.getNames();
            this.getAttributes();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exportCsv(File outputFile, boolean rowNames, boolean names) throws IOException {
        BufferedWriter file = null;
        try {
            file = new BufferedWriter(new FileWriter(outputFile));
            if (names) {
                if (rowNames) {
                    file.write(";");
                }
                for (String name : this.names) {
                    file.write(name + ";");
                }
                file.newLine();
            }
            for (int i = 0; i < this.data.get(0).size(); ++i) {
                if (rowNames) {
                    file.write(this.rowNames.get(i) + ";");
                }
                for (List<?> aData : this.data) {
                    file.write(aData.get(i) + ";");
                }
                file.newLine();
            }
        }
        finally {
            if (file != null) {
                file.close();
            }
        }
    }

    public void importCsv(File inputFile, boolean rowNames, boolean names) throws IOException {
        ArrayList<Object> tmp = new ArrayList<Object>();
        tmp.add("string");
        this.importCsv(inputFile, rowNames, names, tmp);
    }

    public void importCsv(File inputFile, boolean rowNames, boolean names, Object importType) throws IOException {
        ArrayList<Object> tmp = new ArrayList<Object>();
        if (importType instanceof String) {
            tmp.add(importType);
            this.importCsv(inputFile, rowNames, names, tmp);
        } else if (importType instanceof Double) {
            tmp.add(importType);
            this.importCsv(inputFile, rowNames, names, tmp);
        } else if (importType instanceof Integer) {
            tmp.add(importType);
            this.importCsv(inputFile, rowNames, names, tmp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void importCsv(File inputFile, boolean rowNames, boolean names, List<Object> importTypes) throws IOException {
        ArrayList tempData = new ArrayList();
        BufferedReader br = null;
        try {
            br = new BufferedReader(new FileReader(inputFile));
            String tmp = br.readLine();
            String[] splitted = tmp.split(";");
            Integer dataSize = rowNames ? Integer.valueOf(splitted.length - 1) : Integer.valueOf(splitted.length);
            this.data.clear();
            this.rowNames.clear();
            this.names.clear();
            if (names) {
                this.names.addAll(Arrays.asList(splitted).subList(1, splitted.length));
            }
            for (int i = 0; i < dataSize; ++i) {
                ArrayList column = new ArrayList();
                tempData.add(column);
            }
            while ((tmp = br.readLine()) != null) {
                splitted = tmp.split(";");
                int index = 0;
                if (rowNames) {
                    this.rowNames.add(splitted[0]);
                    index = 1;
                }
                for (int i = index; i < splitted.length; ++i) {
                    ArrayList objects = (ArrayList)tempData.get(i - index);
                    if (importTypes.size() == 1 && importTypes.get(0) instanceof String || importTypes.size() > i - index && importTypes.get(i - index) instanceof String) {
                        objects.add(splitted[i]);
                        continue;
                    }
                    if (importTypes.size() == 1 && importTypes.get(0) instanceof Double || importTypes.size() > i - index && importTypes.get(i - index) instanceof Double) {
                        objects.add(Double.valueOf(splitted[i]));
                        continue;
                    }
                    if ((importTypes.size() != 1 || !(importTypes.get(0) instanceof Integer)) && (importTypes.size() <= i - index || !(importTypes.get(i - index) instanceof Integer))) continue;
                    objects.add(Integer.valueOf(splitted[i]));
                }
            }
        }
        finally {
            if (br != null) {
                br.close();
            }
        }
        this.data = tempData;
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Imported DataFrame : \n" + this.toString()));
        }
    }

    protected void checkY(int y) {
        if (!this.data.get(0).isEmpty() && y > this.data.get(0).size()) {
            throw new IndexOutOfBoundsException(String.format(this.indexExceptionText, y, this.data.size()));
        }
    }

    @Override
    public void checkX(int x) {
        if (x > this.data.size() && !this.data.isEmpty()) {
            throw new IndexOutOfBoundsException(String.format(this.indexExceptionText, x, this.data.size()));
        }
    }

    protected void checkType(Object o) throws RException {
        if (!(o instanceof String || o instanceof Double || o instanceof Integer || o instanceof Boolean)) {
            throw new RException("Not supported type");
        }
    }

    public int[] dim() throws RException {
        int x = (Integer)this.engine.eval("dim(" + this.variable + ")[1]");
        int y = (Integer)this.engine.eval("dim(" + this.variable + ")[2]");
        return new int[]{x, y};
    }

    public String toString() {
        ArrayList<String> linesToDisplay = new ArrayList<String>();
        Boolean displayRowNames = !this.rowNames.isEmpty();
        Boolean displayNames = !this.names.isEmpty();
        Integer numberOfLines = 0;
        if (!this.data.isEmpty() && !this.data.get(0).isEmpty()) {
            numberOfLines = this.data.get(0).size();
        }
        if (displayNames.booleanValue()) {
            numberOfLines = numberOfLines + 1;
        }
        for (int i = 0; i < numberOfLines; ++i) {
            linesToDisplay.add(i, "");
        }
        if (displayRowNames.booleanValue()) {
            String str;
            int columnSize = 0;
            for (String name : this.rowNames) {
                if (name.length() <= columnSize) continue;
                columnSize = name.length();
            }
            columnSize += 2;
            if (displayNames.booleanValue()) {
                String line = (String)linesToDisplay.get(0);
                str = String.format("%-" + columnSize + "s", "");
                line = line + str;
                linesToDisplay.set(0, line);
            }
            for (int i = 0; i < this.rowNames.size(); ++i) {
                String line;
                str = String.format("%-" + columnSize + "s", this.rowNames.get(i));
                if (displayNames.booleanValue()) {
                    line = (String)linesToDisplay.get(i + 1);
                    line = line + str;
                    linesToDisplay.set(i + 1, line);
                    continue;
                }
                line = (String)linesToDisplay.get(i);
                line = line + str;
                linesToDisplay.set(i, line);
            }
        }
        for (List<?> column : this.data) {
            String columnName = "";
            int columnSize = 0;
            if (displayNames.booleanValue()) {
                columnName = (String)this.names.get(this.data.indexOf(column));
                columnSize = columnName.length();
            }
            for (Object obj : column) {
                String toString = obj.toString();
                if (toString.length() <= columnSize) continue;
                columnSize = toString.length();
            }
            columnSize += 2;
            if (displayNames.booleanValue()) {
                String str = String.format("%-" + columnSize + "s", columnName);
                String line = (String)linesToDisplay.get(0);
                line = line + str;
                linesToDisplay.set(0, line);
            }
            for (int i = 0; i < column.size(); ++i) {
                String line;
                String str = String.format("%-" + columnSize + "s", column.get(i));
                if (displayNames.booleanValue()) {
                    line = (String)linesToDisplay.get(i + 1);
                    line = line + str;
                    linesToDisplay.set(i + 1, line);
                    continue;
                }
                line = (String)linesToDisplay.get(i);
                line = line + str;
                linesToDisplay.set(i, line);
            }
        }
        StringBuffer returnString = new StringBuffer();
        for (String str : linesToDisplay) {
            returnString.append(str);
            returnString.append("\n");
        }
        return returnString.toString();
    }
}

