/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.j2r.types;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.j2r.REngine;
import org.nuiton.j2r.RException;
import org.nuiton.j2r.types.RDataFrame;
import org.nuiton.j2r.types.REXP;
import org.nuiton.j2r.types.REXPAbstract;

public class RList
extends REXPAbstract
implements REXP {
    private List<Object> data;
    private Log log;

    public RList(REngine engine) {
        this.log = LogFactory.getLog(RDataFrame.class);
        this.names = new ArrayList();
        this.data = new ArrayList<Object>();
        this.variable = "";
        this.engine = engine;
        this.attributes = new HashMap();
    }

    public RList(List<String> names, List<Object> data, REngine engine, String variable) throws RException {
        this.log = LogFactory.getLog(RDataFrame.class);
        this.names = names;
        this.data = (ArrayList)data;
        this.variable = variable;
        this.attributes = new HashMap();
        this.engine = engine;
        try {
            engine.voidEval(this.toRString());
        }
        catch (RException eee) {
            throw new RException("Cannot initialize list in R", eee);
        }
    }

    public RList(String[] names, List<Object> data, REngine engine, String variable) throws RException {
        block3: {
            this.log = LogFactory.getLog(RDataFrame.class);
            this.names = new ArrayList();
            for (int i = 0; i < names.length; ++i) {
                this.names.add(names[i]);
            }
            this.data = (ArrayList)data;
            this.variable = variable;
            this.attributes = new HashMap();
            this.engine = engine;
            try {
                engine.eval(this.toRString());
            }
            catch (RException eee) {
                if (!this.log.isDebugEnabled()) break block3;
                this.log.debug((Object)("Cannot initialize data.frame in R : " + eee.getMessage()));
            }
        }
    }

    @Override
    public String toRString() throws RException {
        this.checkVariable();
        String returnString = this.variable + "<-list(";
        if (this.data != null && !this.data.isEmpty()) {
            for (int i = 0; i < this.data.size(); ++i) {
                if (!this.names.isEmpty()) {
                    returnString = returnString + (String)this.names.get(i) + "=";
                }
                returnString = this.data.get(i) instanceof String ? returnString + "\"" + this.data.get(i) + "\"," : (this.data.get(i) instanceof Boolean && (Boolean)this.data.get(i) != false ? returnString + "TRUE," : (this.data.get(i) instanceof Boolean && (Boolean)this.data.get(i) == false ? returnString + "FALSE," : (this.data.get(i) instanceof Integer ? returnString + String.format("as.integer(%s)", this.data.get(i)) + "," : (this.data.get(i) instanceof REXP ? returnString + ((REXP)this.data.get(i)).toRString() + "," : returnString + this.data.get(i) + ","))));
            }
            returnString = returnString.substring(0, returnString.length() - 1);
        }
        returnString = returnString + ")";
        return returnString;
    }

    public void set(int x, Object data) throws RException {
        this.checkVariable();
        for (int i = 0; i <= x; ++i) {
            try {
                this.data.get(i);
                if (x != i) continue;
                this.data.set(x, data);
                continue;
            }
            catch (IndexOutOfBoundsException eee) {
                if (x == i) {
                    this.data.add(data);
                    continue;
                }
                this.data.add(null);
            }
        }
        if (data instanceof Double) {
            this.engine.voidEval(String.format("%s[[%s]]<-%s", this.variable, x + 1, data));
        } else if (data instanceof Integer) {
            String asInteger = String.format("as.integer(%s)", data);
            this.engine.voidEval(String.format("%s[[%s]]<-%s", this.variable, x + 1, asInteger));
        } else if (data instanceof Boolean) {
            if (((Boolean)data).booleanValue()) {
                this.engine.voidEval(String.format("%s[[%s]]<-%s", this.variable, x + 1, "TRUE"));
            } else {
                this.engine.voidEval(String.format("%s[[%s]]<-%s", this.variable, x + 1, "FALSE"));
            }
        } else if (data instanceof String) {
            this.engine.voidEval(String.format("%s[[%s]]<-%s", this.variable, x + 1, "\"" + data + "\""));
        } else if (data instanceof REXP) {
            this.engine.voidEval(((REXP)data).toRString());
            this.engine.voidEval(String.format("%s[[%s]]<-%s", this.variable, x + 1, ((REXP)data).getVariable()));
        }
    }

    public Object get(int x) throws RException {
        this.checkX(x);
        if (this.engine.isAutoCommit().booleanValue()) {
            Object returnObject = this.engine.eval(String.format("%s[[%s]]", this.variable, x + 1));
            if (returnObject instanceof String) {
                this.data.set(x, (String)returnObject);
            } else if (returnObject instanceof Double) {
                this.data.set(x, (Double)returnObject);
            } else if (returnObject instanceof Integer) {
                this.data.set(x, (Integer)returnObject);
            } else if (returnObject instanceof Boolean) {
                this.data.set(x, (Boolean)returnObject);
            }
        }
        return this.data.get(x);
    }

    public List<Object> getData() {
        return this.data;
    }

    public void setData(List<Object> data) throws RException {
        this.data = data;
        this.engine.voidEval(this.toRString());
    }

    @Override
    public void getFrom(String variable) throws RException {
        this.variable = variable;
        if (this.names != null) {
            this.names.clear();
        } else {
            this.names = new ArrayList();
        }
        if (this.data != null) {
            this.data.clear();
        } else {
            this.data = new ArrayList<Object>();
        }
        if (this.attributes != null) {
            this.attributes.clear();
        } else {
            this.attributes = new HashMap();
        }
        String[] namesArray = (String[])this.engine.eval(String.format("names(%s)", this.variable));
        for (int i = 0; i < namesArray.length; ++i) {
            this.names.add(namesArray[i]);
        }
        int length = (Integer)this.engine.eval(String.format("length(%s)", variable));
        for (int i = 0; i < length; ++i) {
            this.data.add(this.engine.eval(String.format("%s[[%s]]", this.variable, i + 1)));
        }
        Integer attributeslength = (Integer)this.engine.eval(String.format("length(attributes(%s))", this.variable));
        for (int i = 0; i < attributeslength; ++i) {
            String key = (String)this.engine.eval(String.format("names(attributes(%s))[%s]", this.variable, i + 1));
            Object attribute = this.engine.eval(String.format("attr(%s,\"%s\")", this.variable, key));
            this.attributes.put(key, attribute);
        }
    }

    @Override
    public void checkX(int x) {
        if (x > this.data.size()) {
            throw new IndexOutOfBoundsException(String.format(this.indexExceptionText, x, this.data.size()));
        }
    }
}

