/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.j2r.net;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.j2r.REngine;
import org.nuiton.j2r.REngineAbstract;
import org.nuiton.j2r.RException;
import org.nuiton.j2r.types.RDataFrame;
import org.rosuda.REngine.REXP;
import org.rosuda.REngine.REXPMismatchException;
import org.rosuda.REngine.RList;
import org.rosuda.REngine.Rserve.RConnection;
import org.rosuda.REngine.Rserve.RserveException;

public class RNetEngine
extends REngineAbstract
implements REngine {
    public static final int DEFAULT_PORT = 6311;
    public static final String DEFAULT_HOST = "127.0.0.1";
    private Log log = LogFactory.getLog(RNetEngine.class);
    private RConnection conn;
    private Boolean autocommit = true;
    private List<String> rInstructions = new LinkedList<String>();

    @Override
    public boolean init() {
        int port;
        String host;
        block7: {
            String typeProp = System.getProperty("R.type", "net");
            int urlPos = typeProp.indexOf("net://");
            host = null;
            String portAsString = null;
            if (urlPos != -1) {
                String url = typeProp.substring(urlPos + 6);
                int commaPos = url.indexOf(58);
                if (commaPos != -1) {
                    host = url.substring(0, commaPos);
                    portAsString = url.substring(commaPos + 1);
                } else {
                    host = url;
                }
            }
            if (host == null || "".equals(host)) {
                host = DEFAULT_HOST;
            }
            port = 6311;
            if (portAsString != null) {
                try {
                    port = Integer.parseInt(portAsString);
                }
                catch (NumberFormatException nfe) {
                    if (!this.log.isWarnEnabled()) break block7;
                    this.log.warn((Object)("Bad port format " + portAsString + ", using default" + " port : " + port));
                }
            }
        }
        return this.init(host, port);
    }

    public boolean init(String host, int port) {
        if (this.log.isInfoEnabled()) {
            this.log.info((Object)("Trying to connect to the Rserve on '" + host + ":" + port + "'"));
        }
        try {
            this.conn = new RConnection(host, port);
        }
        catch (RserveException eee) {
            this.log.error((Object)"Unable to establish a connection to the R server. Maybe you forgot to start it. Try using the command \"R CMD Rserve\".", (Throwable)eee);
            return false;
        }
        return this.conn.isConnected();
    }

    @Override
    public Object eval(String expr) throws RException {
        REXP result = null;
        try {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)String.format("try(%s,silent=TRUE)", expr));
            }
            if ((result = this.conn.eval(String.format("try(%s,silent=TRUE)", expr))).inherits("try-error")) {
                throw new RException(result.asString());
            }
        }
        catch (RserveException rse) {
            throw new RException("An error occured while eval on net", rse);
        }
        catch (REXPMismatchException rme) {
            throw new RException("Cannot read error message from R :", rme);
        }
        return this.convertResult(result);
    }

    private Object convertResult(REXP rexp) {
        Object result;
        block23: {
            if (rexp == null) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)"Null returned");
                }
                return null;
            }
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Converting : " + rexp.toString()));
            }
            result = null;
            try {
                if (rexp.isInteger()) {
                    int[] array = rexp.asIntegers();
                    Integer[] bigArray = new Integer[array.length];
                    for (int i = 0; i < array.length; ++i) {
                        bigArray[i] = array[i];
                    }
                    result = bigArray;
                    if (array.length == 1) {
                        result = array[0];
                    }
                    break block23;
                }
                if (rexp.isFactor()) {
                    result = rexp.asFactor();
                    break block23;
                }
                if (rexp.isNumeric()) {
                    double[] doublearray = rexp.asDoubles();
                    Double[] bigDoubleArray = new Double[doublearray.length];
                    for (int i = 0; i < doublearray.length; ++i) {
                        bigDoubleArray[i] = doublearray[i];
                    }
                    result = bigDoubleArray;
                    if (doublearray.length == 1) {
                        result = doublearray[0];
                    }
                    break block23;
                }
                if (rexp.isString()) {
                    result = rexp.asStrings();
                    Object stringArray = result;
                    if (((String[])stringArray).length == 1) {
                        result = stringArray[0];
                    }
                    break block23;
                }
                if (rexp.isLogical()) {
                    result = rexp.asStrings();
                    String[] strings = (String[])result;
                    Boolean[] booleanArray = new Boolean[strings.length];
                    for (int i = 0; i < ((String[])result).length; ++i) {
                        booleanArray[i] = Boolean.parseBoolean(strings[i]);
                    }
                    result = booleanArray.length == 1 ? booleanArray[0] : booleanArray;
                    break block23;
                }
                if (rexp.isNull()) {
                    return null;
                }
                if (rexp.inherits("data.frame")) {
                    RDataFrame temp = new RDataFrame(this);
                    ArrayList<List<? extends Object>> data = new ArrayList<List<? extends Object>>();
                    RList dataList = rexp.asList();
                    for (int i = 0; i < dataList.size(); ++i) {
                        List<Object> templist = new ArrayList();
                        REXP tempREXP = dataList.at(i);
                        Object[] convertedREXP = (Object[])this.convertResult(tempREXP);
                        templist = Arrays.asList(convertedREXP);
                        data.add(templist);
                    }
                    temp = new RDataFrame((REngine)this, rexp.getAttribute("names").asStrings(), rexp.getAttribute("row.names").asStrings(), data, "");
                    result = temp;
                    break block23;
                }
                if (rexp.isList()) {
                    org.nuiton.j2r.types.RList temp;
                    block24: {
                        temp = new org.nuiton.j2r.types.RList(this);
                        ArrayList<Object> data = new ArrayList<Object>();
                        RList dataList = rexp.asList();
                        for (int i = 0; i < dataList.size(); ++i) {
                            REXP tempREXP = dataList.at(i);
                            Object convertedREXP = this.convertResult(tempREXP);
                            data.add(convertedREXP);
                        }
                        try {
                            temp = new org.nuiton.j2r.types.RList(rexp.getAttribute("names").asStrings(), data, (REngine)this, "");
                        }
                        catch (RException re) {
                            if (!this.log.isDebugEnabled()) break block24;
                            this.log.debug((Object)"Converting REXP to RList. Creating list without variable name");
                        }
                    }
                    result = temp;
                    break block23;
                }
                this.log.error((Object)("Unknown return type on : " + rexp.toString()));
            }
            catch (REXPMismatchException eee) {
                this.log.error((Object)"An error occurred while getting the expression from R.", (Throwable)eee);
            }
        }
        return result;
    }

    @Override
    public void terminate() throws RException {
        if (this.conn != null && this.conn.isConnected()) {
            this.conn.close();
        }
    }

    @Override
    public void voidEval(String expr) throws RException {
        if (!this.autocommit.booleanValue()) {
            this.rInstructions.add(expr);
        } else {
            try {
                REXP r;
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)String.format("try(%s,silent=TRUE)", expr));
                }
                if ((r = this.conn.eval(String.format("try(%s,silent=TRUE)", expr))).inherits("try-error")) {
                    throw new RException(r.asString());
                }
            }
            catch (RserveException rse) {
                throw new RException("An error occured while eval on net", rse);
            }
            catch (REXPMismatchException rme) {
                throw new RException("Cannot read error message from R :", rme);
            }
        }
    }

    @Override
    public void commit() throws RException {
        for (int i = 0; i < this.rInstructions.size(); ++i) {
            String expr = this.rInstructions.get(i);
            this.voidEval(expr);
        }
        this.rInstructions = new LinkedList<String>();
    }
}

