/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.j2r.jni;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.j2r.REngine;
import org.nuiton.j2r.REngineAbstract;
import org.nuiton.j2r.RException;
import org.nuiton.j2r.types.RDataFrame;
import org.nuiton.j2r.types.RList;
import org.rosuda.JRI.REXP;
import org.rosuda.JRI.Rengine;

public class RJniEngine
extends REngineAbstract
implements REngine {
    private Log log = LogFactory.getLog(RJniEngine.class);
    private static Rengine engine;
    private Boolean autocommit = true;
    private List<String> rInstructions = new LinkedList<String>();

    @Override
    public boolean init() {
        if (engine == null) {
            try {
                String[] args = new String[]{"--no-save"};
                engine = new Rengine(args, false, null);
                if (!engine.waitForR()) {
                    if (this.log.isErrorEnabled()) {
                        this.log.error((Object)"Cannot load the R engine");
                    }
                    return false;
                }
            }
            catch (Exception eee) {
                this.log.error((Object)"An error occured during R/JNI initialization.", (Throwable)eee);
                return false;
            }
        }
        return true;
    }

    @Override
    public Object eval(String expr) throws RException {
        String klass;
        REXP result = null;
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)String.format("try(%s,silent=TRUE)", expr));
        }
        if ((result = engine.eval(String.format("try(%s,silent=TRUE)", expr))).getAttribute("class") != null && (klass = result.getAttribute("class").asString()).equals("try-error")) {
            throw new RException(result.asString());
        }
        return this.convertResult(result);
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private Object convertResult(REXP rexp) {
        if (rexp == null) {
            this.log.debug((Object)"Null returned");
            return null;
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Converting : " + rexp.toString()));
        }
        type = rexp.getType();
        result /* !! */  = null;
        switch (type) {
            case 3: {
                result /* !! */  = rexp.asString();
                break;
            }
            case 1: {
                result /* !! */  = rexp.asInt();
                break;
            }
            case 32: {
                array = rexp.asIntArray();
                bigArray = new Integer[array.length];
                for (i = 0; i < array.length; ++i) {
                    bigArray[i] = array[i];
                }
                result /* !! */  = bigArray;
                if (array.length != 1) break;
                result /* !! */  = array[0];
                break;
            }
            case 33: {
                doublearray = rexp.asDoubleArray();
                bigdoublearray = new Double[doublearray.length];
                for (i = 0; i < doublearray.length; ++i) {
                    bigdoublearray[i] = doublearray[i];
                }
                result /* !! */  = bigdoublearray;
                if (doublearray.length != 1) break;
                result /* !! */  = doublearray[0];
                break;
            }
            case 6: {
                result /* !! */  = rexp.asBool().isTRUE();
                break;
            }
            case 2: {
                result /* !! */  = (String[])rexp.asDoubleArray();
                result /* !! */  = ((double[])result /* !! */ )[0];
                break;
            }
            case 0: {
                result /* !! */  = null;
                break;
            }
            case 37: {
                result /* !! */  = (String[])rexp.asIntArray();
                integers = (int[])result /* !! */ ;
                booleanArray = new Boolean[integers.length];
                for (i = 0; i < integers.length; ++i) {
                    booleanArray[i] = integers[i] == 1 ? Boolean.TRUE : Boolean.FALSE;
                }
                if (booleanArray.length == 1) {
                    result /* !! */  = booleanArray[0];
                    break;
                }
                result /* !! */  = booleanArray;
                break;
            }
            case 34: {
                result /* !! */  = rexp.asStringArray();
                break;
            }
            case 16: {
                klass = "";
                klassAttribute = rexp.getAttribute("class");
                if (klassAttribute != null) {
                    klass = klassAttribute.asString();
                }
                list = rexp.asList();
                if (klass.equals("data.frame")) {
                    temp = new RDataFrame(this);
                    data = new ArrayList<List<? extends Object>>();
                    dataList = rexp.asList();
                    for (i = 0; i < dataList.keys().length; ++i) {
                        templist /* !! */  = new ArrayList<E>();
                        tempREXP = dataList.at(i);
                        convertedREXP = (Object[])this.convertResult(tempREXP);
                        templist /* !! */  = Arrays.asList(convertedREXP);
                        data.add(templist /* !! */ );
                    }
                    temp = new RDataFrame((REngine)this, rexp.getAttribute("names").asStringArray(), rexp.getAttribute("row.names").asStringArray(), data, "");
                    result /* !! */  = temp;
                    break;
                }
                if (list == null) ** GOTO lbl99
                temp = new RList(this);
                data = new ArrayList<Object>();
                dataList = rexp.asList();
                for (i = 0; i < dataList.keys().length; ++i) {
                    tempREXP = dataList.at(i);
                    convertedREXP = this.convertResult(tempREXP);
                    data.add(convertedREXP);
                }
                try {
                    temp = new RList(rexp.getAttribute("names").asStringArray(), data, (REngine)this, "");
                }
                catch (RException re) {
                    if (!this.log.isDebugEnabled()) ** GOTO lbl97
                    this.log.debug((Object)"Converting REXP to RList. Creating list without variable name");
                }
lbl97:
                // 3 sources

                result /* !! */  = temp;
                break;
lbl99:
                // 1 sources

                rexp.asVector();
                break;
            }
            default: {
                this.log.error((Object)("Unknown return type [" + type + "] " + "on : " + rexp.toString()));
            }
        }
        return result /* !! */ ;
    }

    @Override
    public void terminate() {
        if (engine.isAlive()) {
            engine.end();
        }
    }

    @Override
    public void voidEval(String expr) throws RException {
        if (!this.autocommit.booleanValue()) {
            this.rInstructions.add(expr);
        } else {
            String classe;
            REXP r;
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)String.format("try(%s,silent=TRUE)", expr));
            }
            if ((r = engine.eval(String.format("try(%s,silent=TRUE)", expr))).getAttribute("class") != null && (classe = r.getAttribute("class").asString()).equals("try-error")) {
                throw new RException(r.asString());
            }
        }
    }

    @Override
    public void commit() throws RException {
        for (int i = 0; i < this.rInstructions.size(); ++i) {
            String expr = this.rInstructions.get(i);
            engine.eval(expr);
        }
        this.rInstructions = new LinkedList<String>();
    }
}

