/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.csv;

import com.google.common.base.Preconditions;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Iterator;
import org.nuiton.csv.ExportModel;
import org.nuiton.csv.ExportableColumn;
import org.nuiton.csv.ExporterBuilder;
import org.nuiton.csv.ExporterConfiguration;
import org.nuiton.csv.ImportRuntimeException;
import org.nuiton.util.StringUtil;

public class Exporter<O> {
    protected final ExporterConfiguration<O> configuration;

    public static <O> Exporter<O> of(ExportModel<O> model) {
        return Exporter.builder(model).build();
    }

    public static <O> Exporter<O> of(ExporterConfiguration<O> configuration) {
        return Exporter.builder(configuration).build();
    }

    public static <O> ExporterBuilder<O> builder(ExportModel<O> model) {
        return Exporter.builder().addColumns(model.getColumnsForExport()).setCellSeparator(String.valueOf(model.getSeparator()));
    }

    public static <O> ExporterBuilder<O> builder(ExporterConfiguration<O> configuration) {
        return new ExporterBuilder<O>(configuration);
    }

    public static <O> ExporterBuilder<O> builder() {
        return new ExporterBuilder();
    }

    public void toOutputStream(Iterable<O> data, OutputStream outputStream) throws IOException {
        this.toOutputStream(data, true, outputStream);
    }

    public void toOutputStreamWithoutHeader(Iterable<O> data, OutputStream outputStream) throws IOException {
        this.toOutputStream(data, false, outputStream);
    }

    public void toOutputStream(Iterable<O> data, boolean writeHeader, OutputStream outputStream) throws IOException {
        ExporterAction<O> action = ExporterAction.of(this.configuration, data, writeHeader);
        action.export(outputStream);
    }

    public void toWriter(Iterable<O> data, Writer writer) throws IOException {
        this.toWriter(data, true, writer);
    }

    public void toWriterWithoutHeader(Iterable<O> data, Writer writer) throws IOException {
        this.toWriter(data, false, writer);
    }

    public void toWriter(Iterable<O> data, boolean writeHeader, Writer writer) throws IOException {
        ExporterAction<O> action = ExporterAction.of(this.configuration, data, writeHeader);
        action.export(writer);
    }

    public void toFile(Iterable<O> data, File file) throws IOException {
        this.toFile(data, true, file);
    }

    public void toFileWithoutHeader(Iterable<O> data, File file) throws IOException {
        this.toFile(data, false, file);
    }

    public void toFile(Iterable<O> data, boolean writeHeader, File file) throws IOException {
        try (FileOutputStream outputStream = new FileOutputStream(file);){
            this.toOutputStream(data, writeHeader, outputStream);
        }
    }

    public String toString(Iterable<O> data) throws IOException {
        String result = this.toString(data, true);
        return result;
    }

    public String toStringWithoutHeader(Iterable<O> data) throws IOException {
        String result = this.toString(data, false);
        return result;
    }

    public String toString(Iterable<O> data, boolean writeHeader) throws IOException {
        try (StringWriter writer = new StringWriter();){
            String result;
            this.toWriter(data, writeHeader, writer);
            String string = result = writer.toString();
            return string;
        }
    }

    public Reader toReader(Iterable<O> data) throws IOException {
        Reader reader = this.toReader(data, true);
        return reader;
    }

    public Reader toReaderWithoutHeader(Iterable<O> data) throws IOException {
        Reader reader = this.toReader(data, false);
        return reader;
    }

    public Reader toReader(Iterable<O> data, boolean writeHeader) throws IOException {
        ExporterAction<O> action = ExporterAction.of(this.configuration, data, writeHeader);
        Reader reader = action.toReader();
        return reader;
    }

    public InputStream toInputStream(Iterable<O> data) throws IOException {
        InputStream intputStream = this.toInputStream(data, true);
        return intputStream;
    }

    public InputStream toInputStreamWithoutHeader(Iterable<O> data) throws IOException {
        InputStream intputStream = this.toInputStream(data, false);
        return intputStream;
    }

    public InputStream toInputStream(Iterable<O> data, boolean writeHeader) throws IOException {
        ExporterAction<O> action = ExporterAction.of(this.configuration, data, writeHeader);
        InputStream intputStream = action.toInputStream();
        return intputStream;
    }

    protected Exporter(ExporterConfiguration<O> configuration) {
        this.configuration = configuration;
    }

    public ExporterBuilder<O> toBuilder() {
        return new ExporterBuilder<O>(this.configuration);
    }

    protected static class ExporterAction<E> {
        protected final Iterator<E> dataIterator;
        protected final boolean writeHeader;
        protected final ExporterConfiguration<E> configuration;
        protected final int nbCellsPerRow;
        protected boolean firstRowConsumed;
        protected byte[] currentRow;
        protected int currentRowPosition;

        protected static <E> ExporterAction<E> of(ExporterConfiguration<E> configuration, Iterable<E> data, boolean writeHeader) {
            return new ExporterAction<E>(configuration, writeHeader, data);
        }

        protected ExporterAction(ExporterConfiguration<E> configuration, boolean writeHeader, Iterable<E> data) {
            this.configuration = configuration;
            this.writeHeader = writeHeader;
            this.dataIterator = data.iterator();
            this.nbCellsPerRow = configuration.getColumns().size();
        }

        public void export(OutputStream outputStream) throws IOException {
            byte[] row = this.readFirstRowOrGetCurrentRow();
            while (row != null) {
                outputStream.write(row);
                row = this.readNextRow();
            }
        }

        public void export(Writer writer) throws IOException {
            byte[] row = this.readFirstRowOrGetCurrentRow();
            while (row != null) {
                writer.write(new String(row));
                row = this.readNextRow();
            }
        }

        public InputStream toInputStream() {
            return new InputStream(){

                @Override
                public int read() {
                    int result;
                    byte[] row = ExporterAction.this.readFirstRowOrGetCurrentRow();
                    if (row == null) {
                        result = -1;
                    } else {
                        int length = row.length;
                        result = ExporterAction.this.currentRow[ExporterAction.this.currentRowPosition++];
                        if (ExporterAction.this.currentRowPosition >= length) {
                            ExporterAction.this.currentRow = ExporterAction.this.readNextRow();
                        }
                    }
                    return result;
                }

                @Override
                public void close() {
                }
            };
        }

        public Reader toReader() {
            return new InputStreamReader(this.toInputStream(), this.configuration.getCharset());
        }

        protected byte[] readFirstRowOrGetCurrentRow() {
            if (!this.firstRowConsumed) {
                this.firstRowConsumed = true;
                if (this.writeHeader) {
                    this.readHeader();
                } else {
                    this.readNextRow();
                }
            }
            return this.currentRow;
        }

        protected byte[] readNextRow() {
            this.currentRowPosition = 0;
            if (this.dataIterator.hasNext()) {
                E row = this.dataIterator.next();
                try {
                    this.currentRow = this.readRow(row);
                }
                catch (Exception e) {
                    throw new ImportRuntimeException("Could not obtain row", e);
                }
            } else {
                this.currentRow = null;
            }
            return this.currentRow;
        }

        protected void readHeader() {
            this.currentRowPosition = 0;
            String cellSeparator = this.configuration.getCellSeparator();
            StringBuilder rowBuilder = new StringBuilder();
            int index = 0;
            for (ExportableColumn column : this.configuration.getColumns()) {
                String formattedCell = column.getHeaderName();
                this.addCellToRowBuilder(rowBuilder, ++index, formattedCell, cellSeparator);
            }
            this.currentRow = this.toCurrentRow(rowBuilder);
        }

        protected byte[] readRow(E row) throws Exception {
            String cellSeparator = this.configuration.getCellSeparator();
            StringBuilder rowBuilder = new StringBuilder();
            int index = 0;
            for (ExportableColumn column : this.configuration.getColumns()) {
                Object cell = column.getValue(row);
                String formattedCell = column.formatValue(cell);
                Preconditions.checkNotNull((Object)formattedCell, (Object)String.format("column for header %s (%s) returned a null value.", column.getHeaderName(), column.toString()));
                this.addCellToRowBuilder(rowBuilder, ++index, formattedCell, cellSeparator);
            }
            return this.toCurrentRow(rowBuilder);
        }

        protected void addCellToRowBuilder(StringBuilder rowBuilder, int index, String formattedCell, String cellSeparator) {
            String csvCell = StringUtil.escapeCsvValue((String)formattedCell, (String)cellSeparator);
            rowBuilder.append(csvCell);
            if (index < this.nbCellsPerRow) {
                rowBuilder.append(cellSeparator);
            }
        }

        protected byte[] toCurrentRow(StringBuilder rowBuilder) {
            rowBuilder.append(this.configuration.getEndOfLineSeparator());
            String formattedRow = rowBuilder.toString();
            return formattedRow.getBytes(this.configuration.getCharset());
        }
    }
}

